#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef int booleana;
#define FALS 0
#define CERT 1

#define PAUSA "pause >NUL"
#define ESBORRA "cls"

booleana obre_base_dades(char *nom_arxiu);
booleana insereix_alumne(int posicio, int codi);
void mostra_alumnes();
void cerca_nom();
void modifica_alumne();
void elimina_alumne();
void compacta_base_dades();
booleana tanca_base_dades();
int cerca_codi(int codi);

FILE *arxiu = NULL;
char nom_arxiu[255];

struct fitxa
{
       int codi;
       char nom[20];
       char cognom[20];
       float nota;
};

booleana main(int argc, char *argv[])
{
    int opcio;
    booleana base_dades_oberta = FALS;

    do
    {
      system(ESBORRA);
      printf("\n\n\t\t,.-={[< Menu: >]}=-.,\n\n\
                     1) Obre Base de Dades\n\
                     2) Insereix alumne\n\
                     3) Mostra alumnes\n\
                     4) Cerca nom\n\
                     5) Modifica alumne\n\
                     6) Elimina alumne\n\
                     7) Compacta Base de Dades\n\
                     8) Tanca Base de Dades\n\
                     9) Surt\n\n\
                     Opcio: ");
      scanf("%d", &opcio);
      fflush(stdin);

      switch (opcio)
      {
             case 1:
                  if (base_dades_oberta) { tanca_base_dades(); }
                  else { base_dades_oberta = CERT; }
                  obre_base_dades(nom_arxiu);
                  break;
             case 2:
                  if (base_dades_oberta) { fseek(arxiu, 0, SEEK_END); insereix_alumne(ftell(arxiu), 0); }
                  else { printf("\n\t\tHas d'obrir primer la base de dades!"); system(PAUSA); }
                  break;
             case 3:
                  if (base_dades_oberta) { mostra_alumnes(); }
                  else { printf("\n\t\tHas d'obrir primer la base de dades!"); system(PAUSA); }
                  break;
             case 4:
                  if (base_dades_oberta) { cerca_nom(); }
                  else { printf("\n\t\tHas d'obrir primer la base de dades!"); system(PAUSA); }
                  break;
             case 5:
                  if (base_dades_oberta) { modifica_alumne(); }
                  else { printf("\n\t\tHas d'obrir primer la base de dades!"); system(PAUSA); }
                  break;
             case 6:
                  if (base_dades_oberta) { elimina_alumne(); }
                  else { printf("\n\t\tHas d'obrir primer la base de dades!"); system(PAUSA); }
                  break;
             case 7:
                  if (base_dades_oberta) { compacta_base_dades(); }
                  else { printf("\n\t\tHas d'obrir primer la base de dades!"); system(PAUSA); }
                  break;
             case 8:
                  if (base_dades_oberta)
                  {
                     tanca_base_dades();
                     base_dades_oberta = FALS;
                     system(PAUSA);
                  } else { printf("\n\t\tEncara no has obert cap arxiu!"); system(PAUSA); }
                  break;
             case 9:
                  if (base_dades_oberta)
                  {
                     tanca_base_dades();
                     base_dades_oberta = FALS; /* Innecesari. */
                  }
                  printf("\n\t\tAdeu!");
                  break;
             default:
                     printf("Opcio incorrecta!");
                     system(PAUSA);
      }
    } while (opcio != 9);
    
    printf("\n\nFi del programa.");
    system(PAUSA);
    return FALS;
}

booleana obre_base_dades(char *nom_arxiu)
{
         char opcio;

         arxiu = NULL;

         while (arxiu == NULL)
         {
               printf("\n\t\tFica el nom de l'arxiu: ");
               gets(nom_arxiu);
    
               arxiu = fopen(nom_arxiu, "r+b");
    
               if (arxiu == NULL)
               {
                  printf("\n\t\tL'arxiu no existeix (o no es pot obrir)!\n\t\tvols intentar crear-ho? (s/n): ");
                  scanf("%c", &opcio);
                  fflush(stdin);
                  if (tolower(opcio) == 's')
                  {
                     arxiu = fopen(nom_arxiu, "w+b");
                     if (arxiu == NULL) { printf("\n\t\t\tError creant l'arxiu!\n"); }
                     else { printf("\n\t\t\tArxiu creat i obert!"); }
                  }
               }
               else
               {
                   printf("\n\t\t\tArxiu obert!");
               }
         }

         system(PAUSA);

         return CERT;    
}

booleana insereix_alumne(int posicio, int codi)
{
         struct fitxa alumne;
         booleana codi_posicio = -1;

         do
         {
           printf("\n\t\tFica un codi: ");
           scanf("%d", &alumne.codi);
           fflush(stdin);
           codi_posicio = cerca_codi(alumne.codi);
           if (alumne.codi == 0) { printf("\n\t\t\tEl codi no pot ser zero!\n"); }
           else if (codi_posicio != -1 && alumne.codi != codi) { printf("\n\t\t\tEl codi ja existeix!\n"); }
         } while (codi_posicio != -1 && alumne.codi != codi || alumne.codi == 0);

         do
         {
           printf("\n\t\tFica un nom: ");
           scanf("%s", alumne.nom);
           fflush(stdin);
           if (!strcmp(alumne.nom, "")) { printf("\n\t\t\tFica alguna cosa!\n"); }
         } while (!strcmp(alumne.nom, ""));

         do
         {
           printf("\n\t\tFica un cognom: ");
           gets(alumne.cognom);
           if (!strcmp(alumne.cognom, "")) { printf("\n\t\t\tFica alguna cosa!\n"); }
         } while (!strcmp(alumne.cognom, ""));

         do
         {
           printf("\n\t\tFica una nota: ");
           scanf("%f", &alumne.nota);
           fflush(stdin);
           if (alumne.nota < 0 || alumne.nota > 10) { printf("\n\t\t\tLa nota ha de ser entre 0 i 10!\n"); }
         } while (alumne.nota < 0 || alumne.nota > 10);

         /* fseek(arxiu, 0, SEEK_END); */
         fseek(arxiu, posicio, SEEK_SET);
         
         if (!fwrite(&alumne, sizeof(alumne), 1, arxiu))
         {
            printf("\n\t\tL'alumne no ha pogut ser insertat!");
            system(PAUSA);
            return FALS;
         }
         else { printf("\n\t\tAlumne insertat!"); }

         system(PAUSA);

         return CERT;
}

void mostra_alumnes()
{
     struct fitxa alumne;

     rewind(arxiu);

     printf("\n\n\t\t%-5s\t%-20s\t%-20s\t%-2s", "Codi", "Nom", "Cognom", "Nota");
     while (fread(&alumne, sizeof(struct fitxa), 1, arxiu))
     {
           if (alumne.codi != 0)
           {
              printf("\n\t\t%-5d\t%-20s\t%-20s\t%-2g", alumne.codi, alumne.nom, alumne.cognom, alumne.nota);
           }
     }

     system(PAUSA);

     return;
}

void cerca_nom()
{
         char nom[20], nom_cercat[20];
         struct fitxa alumne;

         rewind(arxiu);
         
         do
         {
           printf("\n\t\tFica el nom a cercar: ");
           gets(nom);
           if (!strcmp(nom, "")) { printf("\n\t\t\tFica alguna cosa!\n"); }
         } while (!strcmp(nom, ""));

         strlwr(nom);

         printf("\n\n\t\t%-5s\t%-20s\t%-20s\t%-2s", "Codi", "Nom", "Cognom", "Nota");
         
         while (fread(&alumne, sizeof(struct fitxa), 1, arxiu))
         {
               strcpy(nom_cercat, alumne.nom);
               strlwr(alumne.nom);
               if (strstr(alumne.nom, nom) && alumne.codi != 0)
               {
                  printf("\n\t\t%-5d\t%-20s\t%-20s\t%-2g", alumne.codi, nom_cercat, alumne.cognom, alumne.nota);
               }
         }

         system(PAUSA);

         return;         
}

void modifica_alumne()
{
         struct fitxa alumne;
         int codi_posicio;
         char opcio;
         
         do
         {
           printf("\n\t\tFica un codi (-1 per sortir): ");
           scanf("%d", &alumne.codi);
           fflush(stdin);
           if (alumne.codi == -1) { return; }
           codi_posicio = cerca_codi(alumne.codi);
           if (codi_posicio == -1) { printf("\n\t\t\tEl codi no existeix!\n"); }
           else if (alumne.codi == 0) { printf("\n\t\t\tEl codi no pot ser zero!\n"); }
         } while (codi_posicio == -1 || alumne.codi == 0);
         
         fseek(arxiu, codi_posicio, SEEK_SET);
         
         fread(&alumne, sizeof(struct fitxa), 1, arxiu);

         printf("\n\n\t\t%-5s\t%-20s\t%-20s\t%-2s", "Codi", "Nom", "Cognom", "Nota");
         printf("\n\t\t%-5d\t%-20s\t%-20s\t%-2g", alumne.codi, alumne.nom, alumne.cognom, alumne.nota);
         
         printf("\n\n\t\tVols modificar les dades? (s/n): ");
         scanf("%c", &opcio);
         fflush(stdin);

         if (tolower(opcio) == 's')
         {
            insereix_alumne(codi_posicio, alumne.codi);
         }
         
         return;
}

void elimina_alumne()
{
     struct fitxa alumne;
     int codi_posicio;
     char opcio;
         
     do
     {
       printf("\n\t\tFica un codi (-1 per sortir): ");
       scanf("%d", &alumne.codi);
       fflush(stdin);
       if (alumne.codi == -1) { return; }
       codi_posicio = cerca_codi(alumne.codi);
       if (codi_posicio == -1) { printf("\n\t\t\tEl codi no existeix!\n"); }
       else if (alumne.codi == 0) { printf("\n\t\t\tEl codi no pot ser zero!\n"); }
     } while (codi_posicio == -1 || alumne.codi == 0);
         
     fseek(arxiu, codi_posicio, SEEK_SET);
         
     fread(&alumne, sizeof(struct fitxa), 1, arxiu);

     printf("\n\n\t\t%-5s\t%-20s\t%-20s\t%-2s", "Codi", "Nom", "Cognom", "Nota");
     printf("\n\t\t%-5d\t%-20s\t%-20s\t%-2g", alumne.codi, alumne.nom, alumne.cognom, alumne.nota);
         
     printf("\n\n\t\tVols eliminar l'alumne? (s/n): ");
     scanf("%c", &opcio);
     fflush(stdin);

     if (tolower(opcio) == 's')
     {
        alumne.codi = 0;
            
        fseek(arxiu, codi_posicio, SEEK_SET);
         
        fwrite(&alumne, sizeof(struct fitxa), 1, arxiu);

        printf("\n\t\tAlumne eliminat!");
        system(PAUSA);
     }
         
     return;
}

void compacta_base_dades()
{
     int posicio = 0;
     booleana base_dades_compactada = FALS;
     struct fitxa alumne;
     FILE *arxiu_auxiliar = NULL;
     char nom_arxiu_auxiliar[255];
     
     strcpy(nom_arxiu_auxiliar, nom_arxiu);
     strcat(nom_arxiu_auxiliar, ".tmp");

     arxiu_auxiliar = fopen(nom_arxiu_auxiliar, "wb");
     
     if (arxiu_auxiliar == NULL)
     {
        printf("\n\t\tNo es pot crear l'arxiu auxiliar %s! no es pot compactar.");
        system(PAUSA);
        return;
     } else { printf("\n\t\tCompactant..."); }

     rewind(arxiu);

     while (fread(&alumne, sizeof(struct fitxa), 1, arxiu))
     {
           if (alumne.codi != 0)
           {
              fwrite(&alumne, sizeof(struct fitxa), 1, arxiu_auxiliar);
           } else { base_dades_compactada = CERT; }
     }

     fclose(arxiu_auxiliar);

     if (base_dades_compactada && tanca_base_dades())
     {
        if (!remove(nom_arxiu)) { printf("\n\t\tEsborrant arxiu original..."); }
        else { printf("\n\t\tNo es pot esborrar l'arxiu original!"); base_dades_compactada = FALS; }
        if (!rename(nom_arxiu_auxiliar, nom_arxiu)) { printf("\n\t\tRenombrant l'arxiu auxiliar (%s) com l'original (%s)...", nom_arxiu_auxiliar, nom_arxiu); }
        else { printf("\n\t\tNo es pot renombrar l'arxiu auxiliar (%s)\n\t\tcom l'original (%s)!", nom_arxiu_auxiliar, nom_arxiu); base_dades_compactada = FALS; }
     } else { base_dades_compactada = FALS; }

     if (base_dades_compactada)
     {
        printf("\n\t\tBase de dades compactada!");

        arxiu = fopen(nom_arxiu, "r+b");

        if (arxiu == NULL)
        {
           printf("\n\t\tNo es pot tornar a obrir l'arxiu %s!", nom_arxiu);
           
           /* Pregunta una altra vegada quin arxiu obrir: */
           obre_base_dades(nom_arxiu);
        }
     }
     else { printf("\n\t\tLa base de dades no es pot compactar!"); }

     system(PAUSA);

     return;
}

booleana tanca_base_dades()
{
         if (fclose(arxiu) != EOF) { printf("\n\t\tArxiu %s tancat!\n", nom_arxiu); return CERT; }
         else { printf("\n\t\tNo s'ha pogut tancar l'arxiu %s!\n", nom_arxiu); return FALS; }
}

int cerca_codi(int codi)
{
    struct fitxa alumne;

    if (codi == 0) { return -1; } /* Evita buscar el codi 0. */

    rewind(arxiu);

    while (fread(&alumne, sizeof(struct fitxa), 1, arxiu))
    {
          if (alumne.codi == codi) { return ftell(arxiu) - sizeof(struct fitxa); }
    }

    return -1;
}
