/*
23. Feu un programa que enregistri informaci relativa al nombre de productes venuts d'un assortit
de P productes diferents per part de V venedors. Amb la informaci anterior es demana:
a) Introduir tota la informaci necessria.
b) Trobar el venedor que ms ha venut.
c) Donat un producte introdut per teclat, trobar la quantitat total d'unitats venudes.
*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define P 25 /* maxim de productes. */
#define V P /* maxim de venedors (igual que P). */

#define ESBORRA_PANTALLA "cls"
#define PAUSA "pause >NUL"
#define VALOR_ALEATORI_MAXIM 123456

void introduir(int ventes[][P], int *v, int *p, int *dades_introduides);
void maxim_venedor(int ventes[][P], int v, int p);
void producte_ventes(int ventes[][P], int v, int p);

int main()
{
    int opcio = 0, ventes[V][P], v, p, dades_introduides = 0;

    do
    {
      system(ESBORRA_PANTALLA);
      printf("\t= Menu: =\n\n");
      printf("\t\t1) Introduir informacio\n\
                2) Trobar el venedor que mes ha venut\n\
                3) Trobar la quantitat venuda d'un producte\n\
                4) Sortir\n\n");
      printf("\t\tFica una opcio: ");
      scanf("%d", &opcio);
      switch (opcio)
      {
             case 1:
                    introduir(ventes, &v, &p, &dades_introduides);
                    break;
             case 2:
                    if (dades_introduides) { maxim_venedor(ventes, v, p); }
                    else { printf("\n\t\tEncara no s'han introduit les dades!"); system(PAUSA); }
                    break;
             case 3:
                    if (dades_introduides) { producte_ventes(ventes, v, p); }
                    else { printf("\n\t\tEncara no s'han introduit les dades!"); system(PAUSA); }
                    break;
             default:
                     if (opcio != 4) { printf("\n\t\tOpcio incorrecta!"); system(PAUSA); }
      }
    } while (opcio != 4);

    printf("\n\t\tAdeu!");
    system(PAUSA);
    return 0;    
}

void introduir(int ventes[][P], int *v, int *p, int *dades_introduides)
{
     int opcio, x, y;
     do
     {
       system(ESBORRA_PANTALLA);
       printf("\t= Introduir informacio: =\n\n");
       printf("\t\t1) Manualment\n\
                2) Aleatoriamente\n\
                3) Sortir\n\n");
       printf("\t\tFica una opcio: ");
       scanf("%d", &opcio);
       if (*dades_introduides && (opcio == 1 || opcio == 2))
       {
          printf("\n\n\t\tS'esborraran les dades introduides previament!\n\t\tSi estas segur torna a ficar l'opcio (3 per sortir): ");
          scanf("%d", &opcio);
       }
       switch (opcio)
       {
              case 1:
                       do
                       {
                         printf("\n\t\tFica el nombre de venedors: ");
                         scanf("%d", &*v);
                       } while (*v <= 0);
                       do
                       {
                         printf("\t\tFica el nombre de productes: ");
                         scanf("%d", &*p);
                       } while (*p <= 0);
                       for (x = 0; x < *v; x++)
                       {
                           for (y = 0; y < *p; y++)
                           {
                               do
                               {
                                 printf("\n\t\tFica les unitats del producte %d per al venedor %d: ", y, x);
                                 scanf("%d", &ventes[x][y]);
                                 if (ventes[x][y] < 0) { printf("\t\tHa de ser 0 o superior!\n"); }
                               } while (ventes[x][y] < 0);
                           }
                       }
                       *dades_introduides = 1;
                       printf("\n\t\tDades introduides satisfactoriament.");
                       system(PAUSA);
              break;
              case 2:
                       srand(time(NULL));
                       *v = rand() % V;
                       *p = rand() % P;
                       for (x = 0; x < *v; x++)
                       {
                           for (y = 0; y < *p; y++)
                           {
                               ventes[x][y] = rand() % VALOR_ALEATORI_MAXIM;
                           }
                       }
                       *dades_introduides = 1;
                       printf("\n\t\tDades introduides satisfactoriament!");
                       printf("\n\t\tTotal: %d venedors i %d productes.", *v, *p);
                       system(PAUSA);
              break;
              default:
                      if (opcio != 3) { printf("\n\t\tOpcio incorrecta!"); system(PAUSA); }
       }
     } while (opcio != 3);
}

void maxim_venedor(int ventes[][P], int v, int p)
{
     int venedor, producte, ventes_venedor[V] = { 0 }, maxim;
     
     for (venedor = 0; venedor < v; venedor++)
     {
         for (producte = 0; producte < v; producte++)
         {
             ventes_venedor[venedor] += ventes[venedor][producte];
         }
     }

     maxim = ventes_venedor[0];
     for (venedor = 0; venedor < v; venedor++)
     {
         if (ventes_venedor[venedor] > maxim) { maxim = ventes_venedor[venedor]; }
     }

     for (venedor = 0; venedor < v; venedor++)
     {
         if (ventes_venedor[venedor] == maxim) { printf("\n\t\tEl venedor %d te un maxim amb %d unitats venudes.", venedor, ventes_venedor[venedor]); }
     }

     system(PAUSA);
}

void producte_ventes(int ventes[][P], int v, int p)
{
     int producte, total = 0, x;

     do
     {
       printf("\n\t\tFica el nombre de producte que cerques (maxim %d): ", p);
       scanf("%d", &producte);
     } while (producte < 0 || producte > p);
     
     for (x = 0; x < v; x++)
     {
         total += ventes[x][producte];
     }
     
     printf("\n\t\tEl total venut del producte %d es: %d", producte, total);
     system(PAUSA);
}
