/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.trace.Tracer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

final class MysqlDefs {
    static final int COM_BINLOG_DUMP = 18;
    static final int COM_CHANGE_USER = 17;
    static final int COM_CLOSE_STATEMENT = 25;
    static final int COM_CONNECT_OUT = 20;
    static final int COM_END = 29;
    static final int COM_EXECUTE = 23;
    static final int COM_FETCH = 28;
    static final int COM_LONG_DATA = 24;
    static final int COM_PREPARE = 22;
    static final int COM_REGISTER_SLAVE = 21;
    static final int COM_RESET_STMT = 26;
    static final int COM_SET_OPTION = 27;
    static final int COM_TABLE_DUMP = 19;
    static final int CONNECT = 11;
    static final int CREATE_DB = 5;
    static final int DEBUG = 13;
    static final int DELAYED_INSERT = 16;
    static final int DROP_DB = 6;
    static final int FIELD_LIST = 4;
    static final int FIELD_TYPE_BIT = 16;
    static final int FIELD_TYPE_BLOB = 252;
    static final int FIELD_TYPE_DATE = 10;
    static final int FIELD_TYPE_DATETIME = 12;
    static final int FIELD_TYPE_DECIMAL = 0;
    static final int FIELD_TYPE_DOUBLE = 5;
    static final int FIELD_TYPE_ENUM = 247;
    static final int FIELD_TYPE_FLOAT = 4;
    static final int FIELD_TYPE_GEOMETRY = 255;
    static final int FIELD_TYPE_INT24 = 9;
    static final int FIELD_TYPE_LONG = 3;
    static final int FIELD_TYPE_LONG_BLOB = 251;
    static final int FIELD_TYPE_LONGLONG = 8;
    static final int FIELD_TYPE_MEDIUM_BLOB = 250;
    static final int FIELD_TYPE_NEW_DECIMAL = 246;
    static final int FIELD_TYPE_NEWDATE = 14;
    static final int FIELD_TYPE_NULL = 6;
    static final int FIELD_TYPE_SET = 248;
    static final int FIELD_TYPE_SHORT = 2;
    static final int FIELD_TYPE_STRING = 254;
    static final int FIELD_TYPE_TIME = 11;
    static final int FIELD_TYPE_TIMESTAMP = 7;
    static final int FIELD_TYPE_TINY = 1;
    static final int FIELD_TYPE_TINY_BLOB = 249;
    static final int FIELD_TYPE_VAR_STRING = 253;
    static final int FIELD_TYPE_VARCHAR = 15;
    static final int FIELD_TYPE_YEAR = 13;
    static final int INIT_DB = 2;
    static final long LENGTH_BLOB = 65535L;
    static final long LENGTH_LONGBLOB = 0xFFFFFFFFL;
    static final long LENGTH_MEDIUMBLOB = 0xFFFFFFL;
    static final long LENGTH_TINYBLOB = 255L;
    static final int MAX_ROWS = 50000000;
    public static final int NO_CHARSET_INFO = -1;
    static final byte OPEN_CURSOR_FLAG = 1;
    static final int PING = 14;
    static final int PROCESS_INFO = 10;
    static final int PROCESS_KILL = 12;
    static final int QUERY = 3;
    static final int QUIT = 1;
    static final int RELOAD = 7;
    static final int SHUTDOWN = 8;
    static final int SLEEP = 0;
    static final int STATISTICS = 9;
    static final int TIME = 15;
    private static Map mysqlToJdbcTypesMap;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;

    static {
        Factory factory = new Factory("MysqlDefs.java", Class.forName("com.mysql.jdbc.MysqlDefs"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8-mysqlToJavaType-com.mysql.jdbc.MysqlDefs-int:-mysqlType:--int-"), 194);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8-mysqlToJavaType-com.mysql.jdbc.MysqlDefs-java.lang.String:-mysqlType:--int-"), 330);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-typeToName-com.mysql.jdbc.MysqlDefs-int:-mysqlType:--java.lang.String-"), 407);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("18-appendJdbcTypeMappingQuery-com.mysql.jdbc.MysqlDefs-java.lang.StringBuffer:java.lang.String:-buf:mysqlTypeColumnName:--void-"), 557);
        mysqlToJdbcTypesMap = new HashMap();
        mysqlToJdbcTypesMap.put("BIT", new Integer(MysqlDefs.mysqlToJavaType(16)));
        mysqlToJdbcTypesMap.put("TINYINT", new Integer(MysqlDefs.mysqlToJavaType(1)));
        mysqlToJdbcTypesMap.put("SMALLINT", new Integer(MysqlDefs.mysqlToJavaType(2)));
        mysqlToJdbcTypesMap.put("MEDIUMINT", new Integer(MysqlDefs.mysqlToJavaType(9)));
        mysqlToJdbcTypesMap.put("INT", new Integer(MysqlDefs.mysqlToJavaType(3)));
        mysqlToJdbcTypesMap.put("INTEGER", new Integer(MysqlDefs.mysqlToJavaType(3)));
        mysqlToJdbcTypesMap.put("BIGINT", new Integer(MysqlDefs.mysqlToJavaType(8)));
        mysqlToJdbcTypesMap.put("INT24", new Integer(MysqlDefs.mysqlToJavaType(9)));
        mysqlToJdbcTypesMap.put("REAL", new Integer(MysqlDefs.mysqlToJavaType(5)));
        mysqlToJdbcTypesMap.put("FLOAT", new Integer(MysqlDefs.mysqlToJavaType(4)));
        mysqlToJdbcTypesMap.put("DECIMAL", new Integer(MysqlDefs.mysqlToJavaType(0)));
        mysqlToJdbcTypesMap.put("NUMERIC", new Integer(MysqlDefs.mysqlToJavaType(0)));
        mysqlToJdbcTypesMap.put("DOUBLE", new Integer(MysqlDefs.mysqlToJavaType(5)));
        mysqlToJdbcTypesMap.put("CHAR", new Integer(MysqlDefs.mysqlToJavaType(254)));
        mysqlToJdbcTypesMap.put("VARCHAR", new Integer(MysqlDefs.mysqlToJavaType(253)));
        mysqlToJdbcTypesMap.put("DATE", new Integer(MysqlDefs.mysqlToJavaType(10)));
        mysqlToJdbcTypesMap.put("TIME", new Integer(MysqlDefs.mysqlToJavaType(11)));
        mysqlToJdbcTypesMap.put("YEAR", new Integer(MysqlDefs.mysqlToJavaType(13)));
        mysqlToJdbcTypesMap.put("TIMESTAMP", new Integer(MysqlDefs.mysqlToJavaType(7)));
        mysqlToJdbcTypesMap.put("DATETIME", new Integer(MysqlDefs.mysqlToJavaType(12)));
        mysqlToJdbcTypesMap.put("TINYBLOB", new Integer(-2));
        mysqlToJdbcTypesMap.put("BLOB", new Integer(-4));
        mysqlToJdbcTypesMap.put("MEDIUMBLOB", new Integer(-4));
        mysqlToJdbcTypesMap.put("LONGBLOB", new Integer(-4));
        mysqlToJdbcTypesMap.put("TINYTEXT", new Integer(12));
        mysqlToJdbcTypesMap.put("TEXT", new Integer(-1));
        mysqlToJdbcTypesMap.put("MEDIUMTEXT", new Integer(-1));
        mysqlToJdbcTypesMap.put("LONGTEXT", new Integer(-1));
        mysqlToJdbcTypesMap.put("ENUM", new Integer(MysqlDefs.mysqlToJavaType(247)));
        mysqlToJdbcTypesMap.put("SET", new Integer(MysqlDefs.mysqlToJavaType(248)));
        mysqlToJdbcTypesMap.put("GEOMETRY", new Integer(MysqlDefs.mysqlToJavaType(255)));
    }

    MysqlDefs() {
    }

    static int mysqlToJavaType(int n) {
        int jdbcType;
        int mysqlType;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        switch (mysqlType) {
            case 0: 
            case 246: {
                jdbcType = 3;
                break;
            }
            case 1: {
                jdbcType = -6;
                break;
            }
            case 2: {
                jdbcType = 5;
                break;
            }
            case 3: {
                jdbcType = 4;
                break;
            }
            case 4: {
                jdbcType = 7;
                break;
            }
            case 5: {
                jdbcType = 8;
                break;
            }
            case 6: {
                jdbcType = 0;
                break;
            }
            case 7: {
                jdbcType = 93;
                break;
            }
            case 8: {
                jdbcType = -5;
                break;
            }
            case 9: {
                jdbcType = 4;
                break;
            }
            case 10: {
                jdbcType = 91;
                break;
            }
            case 11: {
                jdbcType = 92;
                break;
            }
            case 12: {
                jdbcType = 93;
                break;
            }
            case 13: {
                jdbcType = 91;
                break;
            }
            case 14: {
                jdbcType = 91;
                break;
            }
            case 247: {
                jdbcType = 1;
                break;
            }
            case 248: {
                jdbcType = 1;
                break;
            }
            case 249: {
                jdbcType = -3;
                break;
            }
            case 250: {
                jdbcType = -4;
                break;
            }
            case 251: {
                jdbcType = -4;
                break;
            }
            case 252: {
                jdbcType = -4;
                break;
            }
            case 15: 
            case 253: {
                jdbcType = 12;
                break;
            }
            case 254: {
                jdbcType = 1;
                break;
            }
            case 255: {
                jdbcType = -2;
                break;
            }
            case 16: {
                jdbcType = -7;
                break;
            }
            default: {
                jdbcType = 12;
            }
        }
        int n3 = jdbcType;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n3), joinPoint);
        return n3;
    }

    static int mysqlToJavaType(String string) {
        String mysqlType;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = mysqlType.equalsIgnoreCase("BIT") ? MysqlDefs.mysqlToJavaType(16) : (mysqlType.equalsIgnoreCase("TINYINT") ? MysqlDefs.mysqlToJavaType(1) : (mysqlType.equalsIgnoreCase("SMALLINT") ? MysqlDefs.mysqlToJavaType(2) : (mysqlType.equalsIgnoreCase("MEDIUMINT") ? MysqlDefs.mysqlToJavaType(9) : (mysqlType.equalsIgnoreCase("INT") || mysqlType.equalsIgnoreCase("INTEGER") ? MysqlDefs.mysqlToJavaType(3) : (mysqlType.equalsIgnoreCase("BIGINT") ? MysqlDefs.mysqlToJavaType(8) : (mysqlType.equalsIgnoreCase("INT24") ? MysqlDefs.mysqlToJavaType(9) : (mysqlType.equalsIgnoreCase("REAL") ? MysqlDefs.mysqlToJavaType(5) : (mysqlType.equalsIgnoreCase("FLOAT") ? MysqlDefs.mysqlToJavaType(4) : (mysqlType.equalsIgnoreCase("DECIMAL") ? MysqlDefs.mysqlToJavaType(0) : (mysqlType.equalsIgnoreCase("NUMERIC") ? MysqlDefs.mysqlToJavaType(0) : (mysqlType.equalsIgnoreCase("DOUBLE") ? MysqlDefs.mysqlToJavaType(5) : (mysqlType.equalsIgnoreCase("CHAR") ? MysqlDefs.mysqlToJavaType(254) : (mysqlType.equalsIgnoreCase("VARCHAR") ? MysqlDefs.mysqlToJavaType(253) : (mysqlType.equalsIgnoreCase("DATE") ? MysqlDefs.mysqlToJavaType(10) : (mysqlType.equalsIgnoreCase("TIME") ? MysqlDefs.mysqlToJavaType(11) : (mysqlType.equalsIgnoreCase("YEAR") ? MysqlDefs.mysqlToJavaType(13) : (mysqlType.equalsIgnoreCase("TIMESTAMP") ? MysqlDefs.mysqlToJavaType(7) : (mysqlType.equalsIgnoreCase("DATETIME") ? MysqlDefs.mysqlToJavaType(12) : (mysqlType.equalsIgnoreCase("TINYBLOB") ? -2 : (mysqlType.equalsIgnoreCase("BLOB") ? -4 : (mysqlType.equalsIgnoreCase("MEDIUMBLOB") ? -4 : (mysqlType.equalsIgnoreCase("LONGBLOB") ? -4 : (mysqlType.equalsIgnoreCase("TINYTEXT") ? 12 : (mysqlType.equalsIgnoreCase("TEXT") ? -1 : (mysqlType.equalsIgnoreCase("MEDIUMTEXT") ? -1 : (mysqlType.equalsIgnoreCase("LONGTEXT") ? -1 : (mysqlType.equalsIgnoreCase("ENUM") ? MysqlDefs.mysqlToJavaType(247) : (mysqlType.equalsIgnoreCase("SET") ? MysqlDefs.mysqlToJavaType(248) : (mysqlType.equalsIgnoreCase("GEOMETRY") ? MysqlDefs.mysqlToJavaType(255) : (mysqlType.equalsIgnoreCase("BINARY") ? -2 : (mysqlType.equalsIgnoreCase("VARBINARY") ? -3 : (mysqlType.equalsIgnoreCase("BIT") ? MysqlDefs.mysqlToJavaType(16) : 1111))))))))))))))))))))))))))))))));
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    public static String typeToName(int n) {
        String string;
        int mysqlType;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        switch (mysqlType) {
            case 0: {
                string = "FIELD_TYPE_DECIMAL";
                break;
            }
            case 1: {
                string = "FIELD_TYPE_TINY";
                break;
            }
            case 2: {
                string = "FIELD_TYPE_SHORT";
                break;
            }
            case 3: {
                string = "FIELD_TYPE_LONG";
                break;
            }
            case 4: {
                string = "FIELD_TYPE_FLOAT";
                break;
            }
            case 5: {
                string = "FIELD_TYPE_DOUBLE";
                break;
            }
            case 6: {
                string = "FIELD_TYPE_NULL";
                break;
            }
            case 7: {
                string = "FIELD_TYPE_TIMESTAMP";
                break;
            }
            case 8: {
                string = "FIELD_TYPE_LONGLONG";
                break;
            }
            case 9: {
                string = "FIELD_TYPE_INT24";
                break;
            }
            case 10: {
                string = "FIELD_TYPE_DATE";
                break;
            }
            case 11: {
                string = "FIELD_TYPE_TIME";
                break;
            }
            case 12: {
                string = "FIELD_TYPE_DATETIME";
                break;
            }
            case 13: {
                string = "FIELD_TYPE_YEAR";
                break;
            }
            case 14: {
                string = "FIELD_TYPE_NEWDATE";
                break;
            }
            case 247: {
                string = "FIELD_TYPE_ENUM";
                break;
            }
            case 248: {
                string = "FIELD_TYPE_SET";
                break;
            }
            case 249: {
                string = "FIELD_TYPE_TINY_BLOB";
                break;
            }
            case 250: {
                string = "FIELD_TYPE_MEDIUM_BLOB";
                break;
            }
            case 251: {
                string = "FIELD_TYPE_LONG_BLOB";
                break;
            }
            case 252: {
                string = "FIELD_TYPE_BLOB";
                break;
            }
            case 253: {
                string = "FIELD_TYPE_VAR_STRING";
                break;
            }
            case 254: {
                string = "FIELD_TYPE_STRING";
                break;
            }
            case 15: {
                string = "FIELD_TYPE_VARCHAR";
                break;
            }
            case 255: {
                string = "FIELD_TYPE_GEOMETRY";
                break;
            }
            default: {
                string = " Unknown MySQL Type # " + mysqlType;
                break;
            }
        }
        String string2 = string;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string2, joinPoint);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    static final void appendJdbcTypeMappingQuery(StringBuffer stringBuffer, String string) {
        StringBuffer buf;
        StringBuffer stringBuffer2 = stringBuffer;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)stringBuffer2, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        buf.append("CASE ");
        HashMap<String, Integer> typesMap = new HashMap<String, Integer>();
        typesMap.putAll(mysqlToJdbcTypesMap);
        typesMap.put("BINARY", new Integer(-2));
        typesMap.put("VARBINARY", new Integer(-3));
        Iterator mysqlTypes = typesMap.keySet().iterator();
        while (mysqlTypes.hasNext()) {
            void mysqlTypeColumnName;
            String mysqlTypeName = (String)mysqlTypes.next();
            buf.append(" WHEN ");
            buf.append((String)mysqlTypeColumnName);
            buf.append("='");
            buf.append(mysqlTypeName);
            buf.append("' THEN ");
            buf.append(typesMap.get(mysqlTypeName));
            if (!mysqlTypeName.equalsIgnoreCase("DOUBLE") && !mysqlTypeName.equalsIgnoreCase("FLOAT") && !mysqlTypeName.equalsIgnoreCase("DECIMAL") && !mysqlTypeName.equalsIgnoreCase("NUMERIC")) continue;
            buf.append(" WHEN ");
            buf.append((String)mysqlTypeColumnName);
            buf.append("='");
            buf.append(mysqlTypeName);
            buf.append(" unsigned' THEN ");
            buf.append(typesMap.get(mysqlTypeName));
        }
        buf.append(" ELSE ");
        buf.append(1111);
        buf.append(" END ");
        Object var8_8 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var8_8, joinPoint);
    }
}

