/*
 * Decompiled with CFR 0.152.
 */
package logica;

import java.awt.Graphics;
import logica.Paleta;
import logica.Pieza;

public class Tablero {
    protected byte ancho;
    protected byte alto;
    protected int[][] mapa;
    protected Paleta paleta;
    public final int VACIO = 0;
    private final int numeroCodificacionPiezas = -1;

    public Tablero(byte ancho, byte alto, Paleta paleta) {
        this.vaciar();
        this.setAncho(ancho);
        this.setAlto(alto);
        this.setPaleta(paleta);
    }

    public byte getAncho() {
        return this.ancho;
    }

    protected void setAncho(byte ancho) {
        this.ancho = ancho;
    }

    public byte getAlto() {
        return this.alto;
    }

    protected void setAlto(byte alto) {
        this.alto = alto;
    }

    public void vaciar() {
        for (byte f = 0; f < this.getAlto(); f = (byte)(f + 1)) {
            this.borrarLinea(f);
        }
    }

    protected void setPaleta(Paleta paleta) {
        this.paleta = paleta;
    }

    protected Paleta getPaleta() {
        return this.paleta;
    }

    public boolean estaLleno() {
        boolean lleno = false;
        for (byte c = 0; c < this.getAncho(); c = (byte)(c + 1)) {
            if (this.getMapa()[0][c] == this.VACIO) continue;
            lleno = true;
        }
        return lleno;
    }

    public byte procesarLineas() {
        byte numeroLineas = 0;
        for (byte f = 0; f < this.getAlto(); f = (byte)(f + 1)) {
            if (!this.hayLinea(f)) continue;
            numeroLineas = (byte)(numeroLineas + 1);
            this.borrarLinea(f);
        }
        if (numeroLineas > 0) {
            this.bajarPiezas();
        }
        return numeroLineas;
    }

    protected boolean hayLinea(byte fila) {
        boolean hayLinea = true;
        for (byte c = 0; c < this.getAncho(); c = (byte)(c + 1)) {
            if (this.getMapa()[fila][c] != this.VACIO) continue;
            hayLinea = false;
            break;
        }
        return hayLinea;
    }

    protected void borrarLinea(byte fila) {
        for (byte c = 0; c < this.getAncho(); c = (byte)(c + 1)) {
            this.getMapa()[fila][c] = this.VACIO;
        }
    }

    protected boolean lineaVacia(byte fila) {
        boolean vacia = true;
        for (byte c = 0; c < this.getAncho(); c = (byte)(c + 1)) {
            if (this.getMapa()[fila][c] == this.VACIO) continue;
            vacia = false;
            break;
        }
        return vacia;
    }

    protected void bajarPiezas() {
        for (byte f = 1; f < this.getAlto(); f = (byte)(f + 1)) {
            if (!this.lineaVacia(f)) continue;
            for (byte fSuperior = (byte)(f - 1); fSuperior >= 0 && !this.lineaVacia(fSuperior); fSuperior = (byte)(fSuperior - 1)) {
                this.copiarFila(fSuperior, (byte)(fSuperior + 1));
            }
        }
    }

    protected void copiarFila(byte fOrigen, byte fDestino) {
        for (byte c = 0; c < this.getAncho(); c = (byte)(c + 1)) {
            this.getMapa()[fDestino][c] = this.getMapa()[fOrigen][c];
        }
    }

    public void agregarPieza(Pieza pieza, byte left, byte top) {
        if (this.cabePieza(pieza, left, top)) {
            int fPieza = 0;
            byte f = top;
            while (f < top + pieza.getAlto()) {
                int cPieza = 0;
                byte c = left;
                while (c < left + pieza.getAncho()) {
                    this.getMapa()[f][c] = pieza.getForma()[fPieza][cPieza] * this.numeroCodificacionPiezas;
                    c = (byte)(c + 1);
                    cPieza = (byte)(cPieza + 1);
                }
                f = (byte)(f + 1);
                fPieza = (byte)(fPieza + 1);
            }
        }
    }

    public void agregarPieza(Pieza pieza) {
        this.agregarPieza(pieza, pieza.getLeft(), pieza.getTop());
    }

    public boolean cabePieza(Pieza pieza, byte left, byte top) {
        return pieza.cabePieza(this, left, top);
    }

    public boolean cabePieza(Pieza pieza) {
        return this.cabePieza(pieza, pieza.getLeft(), pieza.getTop());
    }

    public int[][] getMapa() {
        return this.mapa;
    }

    public void dibujar(Graphics contenedor) {
    }
}

