/*
 * Decompiled with CFR 0.152.
 */
package gui;

import configuracion.Aspecto;
import configuracion.Otros;
import java.awt.Color;
import java.awt.Graphics;
import logica.Paleta;
import logica.Panel;
import logica.Pieza;
import logica.Tablero;

public class MotorGrafico {
    protected static int[][] graficoBackup = new int[127][127];
    protected static boolean graficoInicializado = false;
    protected static final int numeroCodificacionPiezas = Otros.getNumeroCodificacionPiezas();
    protected static byte celdaAncho = Aspecto.getCeldaAncho();
    protected static byte celdaAlto = Aspecto.getCeldaAlto();

    private MotorGrafico() {
    }

    public static void setCeldaAncho(byte celdaAncho) {
        MotorGrafico.celdaAncho = celdaAncho;
    }

    public static byte getCeldaAncho() {
        return celdaAncho;
    }

    public static void setCeldaAlto(byte celdaAlto) {
        MotorGrafico.celdaAlto = celdaAlto;
    }

    public static byte getCeldaAlto() {
        return celdaAlto;
    }

    public static void dibujar(Graphics g, Object objeto) {
        if (objeto instanceof Pieza) {
            MotorGrafico.dibujarPieza(g, (Pieza)objeto);
        } else if (objeto instanceof Tablero) {
            MotorGrafico.dibujarTablero(g, (Tablero)objeto);
        } else if (objeto instanceof Panel) {
            MotorGrafico.dibujarPanel(g, (Panel)objeto);
        }
    }

    public static void dibujarPieza(Graphics g, Pieza pieza) {
        Paleta paleta = pieza.getPaleta();
        byte x = pieza.getLeft();
        byte y = pieza.getTop();
        byte ancho = pieza.getAncho();
        byte alto = pieza.getAlto();
        int[][] matriz = pieza.getForma();
        MotorGrafico.dibujarMatriz(g, paleta, matriz, x, y, ancho, alto);
    }

    public static void dibujarTablero(Graphics g, Tablero tablero) {
        if (!graficoInicializado) {
            MotorGrafico.inicializarGraficoBackup();
            graficoInicializado = true;
        }
        Paleta paleta = tablero.getPaleta();
        byte x = 0;
        byte y = 0;
        byte ancho = tablero.getAncho();
        byte alto = tablero.getAlto();
        int[][] matriz = tablero.getMapa();
        MotorGrafico.dibujarMatriz(g, paleta, matriz, x, y, ancho, alto);
    }

    public static void dibujarPanel(Graphics g, Panel panel) {
        Paleta paleta = panel.getPaleta();
        byte x = panel.getLeft();
        byte y = panel.getTop();
        byte ancho = panel.getAncho();
        byte alto = panel.getAlto();
        int[][] matriz = panel.getMapa();
        MotorGrafico.dibujarMatriz(g, paleta, matriz, x, y, ancho, alto);
        MotorGrafico.dibujarPanelInformacion(g, panel);
    }

    protected static void dibujarPanelInformacion(Graphics g, Panel panel) {
        int nivel = panel.getNivel();
        int puntos = panel.getPuntos();
        int lineas = panel.getLineas();
        int lineasNivel = panel.getLineasNivel();
        int x = panel.getLeft() * MotorGrafico.getCeldaAncho();
        int y = (panel.getTop() + panel.getAlto() + panel.getMargen()) * MotorGrafico.getCeldaAlto();
        Color colorTexto = panel.getPaleta().getColor(panel.getColorTexto());
        g.setColor(colorTexto);
        g.drawString("Nivel: " + nivel, x, y);
        g.drawString("Puntos: " + puntos, x, y += MotorGrafico.getCeldaAlto());
        g.drawString("Lineas totales: " + lineas, x, y += MotorGrafico.getCeldaAlto());
        g.drawString("Lineas nivel: " + lineasNivel, x, y += MotorGrafico.getCeldaAlto());
        y += MotorGrafico.getCeldaAlto();
    }

    public static void dibujarMatriz(Graphics g, Paleta paleta, int[][] matriz, byte left, byte top, byte ancho, byte alto) {
        byte y = top;
        for (byte f = 0; f < alto; f = (byte)(f + 1)) {
            byte x = left;
            for (byte c = 0; c < ancho; c = (byte)(c + 1)) {
                int indiceColor = matriz[f][c];
                MotorGrafico.dibujarCasilla(g, paleta, indiceColor, x, y);
                x = (byte)(x + 1);
            }
            y = (byte)(y + 1);
        }
    }

    protected static void dibujarCasilla(Graphics g, Paleta paleta, int indiceColor, byte x, byte y) {
        if (x < 0 || y < 0) {
            return;
        }
        if (indiceColor < 0) {
            indiceColor /= numeroCodificacionPiezas;
        }
        MotorGrafico.actualizarGraficoBackup(indiceColor, x, y);
        Color color = paleta.getColor(indiceColor);
        g.setColor(color);
        int xReal = x * MotorGrafico.getCeldaAncho();
        int yReal = y * MotorGrafico.getCeldaAlto();
        g.fillRect(xReal, yReal, MotorGrafico.getCeldaAncho(), MotorGrafico.getCeldaAlto());
    }

    protected static void actualizarGraficoBackup(int indiceColor, byte x, byte y) {
        if (graficoBackup[x][y] != indiceColor) {
            MotorGrafico.graficoBackup[x][y] = indiceColor;
        }
    }

    protected static void inicializarGraficoBackup() {
        for (int f = 0; f < graficoBackup.length; f = (int)((byte)(f + 1))) {
            for (int c = 0; c < graficoBackup[0].length; c = (int)((byte)(c + 1))) {
                MotorGrafico.graficoBackup[f][c] = -1;
            }
        }
    }
}

