/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.core.index.IIndex;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.jdt.internal.core.search.processing.IJob;

public abstract class IndexRequest
implements IJob {
    protected boolean isCancelled = false;
    protected IPath containerPath;
    protected IndexManager manager;

    public IndexRequest(IPath containerPath, IndexManager manager) {
        this.containerPath = containerPath;
        this.manager = manager;
    }

    public boolean belongsTo(String projectNameOrJarPath) {
        return projectNameOrJarPath.equals(this.containerPath.segment(0)) || projectNameOrJarPath.equals(this.containerPath.toString());
    }

    public void cancel() {
        this.manager.jobWasCancelled(this.containerPath);
        this.isCancelled = true;
    }

    public void ensureReadyToRun() {
        this.manager.aboutToUpdateIndex(this.containerPath, this.updatedIndexState());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void saveIfNecessary(IIndex index, ReadWriteMonitor monitor) throws IOException {
        if (!index.hasChanged()) return;
        try {
            monitor.exitRead();
            monitor.enterWrite();
            this.manager.saveIndex(index);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            monitor.exitWriteEnterRead();
            throw throwable;
        }
        {
            Object var3_5 = null;
            monitor.exitWriteEnterRead();
            return;
        }
    }

    protected Integer updatedIndexState() {
        return IndexManager.UPDATING_STATE;
    }
}

