/*
 * Decompiled with CFR 0.152.
 */
package logica;

import configuracion.Piezas;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import logica.Paleta;
import logica.Pieza;

public class Juego {
    private int[] TeclaArriba;
    private int[] TeclaAbajo;
    private int[] TeclaDerecha;
    private int[] TeclaIzquierda;
    private int[] TeclaRotarDerecha;
    private int[] TeclaRotarIzquierda;
    private Graphics contenedorGrafico;
    private Paleta paleta;
    private Pieza[] piezasBase;
    private int velocidad;
    private final int velocidadMinima = 10;
    private final int velocidadMaxima = 3000;
    private final int incrementoVelocidad = 100;
    private boolean juegoPausado;
    private int nivel;
    private int puntos;
    private int lineas;

    public Juego(Graphics contenedor, Paleta paleta) {
        this(contenedor, paleta, null);
    }

    public Juego(Graphics contenedor, Paleta paleta, Pieza[] piezasBase) {
        this.setContenedorGrafico(contenedor);
        this.setPaleta(paleta);
        if (piezasBase == null) {
            piezasBase = Piezas.getPiezas(this.getPaleta());
        }
        this.setPiezasBase(piezasBase);
    }

    public void setContenedorGrafico(Graphics contenedor) {
        this.contenedorGrafico = contenedor;
    }

    public Graphics getContenedorGrafico() {
        return this.contenedorGrafico;
    }

    public void setPaleta(Paleta paleta) {
        this.paleta = paleta;
    }

    public Paleta getPaleta() {
        return this.paleta;
    }

    public void setPiezasBase(Pieza[] piezasBase) {
        this.piezasBase = piezasBase;
    }

    protected int numeroPiezasBase() {
        return this.getPiezasBase().length;
    }

    public Pieza[] getPiezasBase() {
        return this.piezasBase;
    }

    public void definirTeclas(int[] TeclaArriba, int[] TeclaAbajo, int[] TeclaDerecha, int[] TeclaIzquierda, int[] TeclaRotarDerecha, int[] TeclaRotarIzquierda) {
        this.TeclaArriba = TeclaArriba;
        this.TeclaAbajo = TeclaAbajo;
        this.TeclaDerecha = TeclaDerecha;
        this.TeclaIzquierda = TeclaIzquierda;
        this.TeclaRotarDerecha = TeclaRotarDerecha;
        this.TeclaRotarIzquierda = TeclaRotarIzquierda;
    }

    public void setVelocidad(int velocidad) {
        if (velocidad >= this.velocidadMinima && velocidad <= this.velocidadMaxima) {
            this.velocidad = velocidad;
        }
    }

    public int getVelocidad() {
        return this.velocidad;
    }

    protected void subirVelocidad() {
        this.setVelocidad(this.getVelocidad() + this.incrementoVelocidad);
    }

    public void setNivel(int nivel) {
        this.nivel = nivel;
    }

    public int getNivel() {
        return this.nivel;
    }

    protected void subirNivel() {
        this.setNivel(this.getNivel() + 1);
    }

    protected void setPuntos(int puntos) {
        this.puntos = puntos;
    }

    public int getPuntos() {
        return this.puntos;
    }

    protected void sumarPuntos(int puntos) {
        this.setPuntos(this.getPuntos() + puntos);
    }

    protected void setLineas(int lineas) {
        if (lineas >= 0) {
            this.lineas = lineas;
        }
    }

    public int getLineas() {
        return this.lineas;
    }

    protected void sumarLineas(int numeroLineas) {
        if (numeroLineas > 0) {
            this.setLineas(this.getLineas() + numeroLineas);
        }
    }

    public int leerTeclado(KeyEvent evento) {
        return 0;
    }

    public void procesarTecla(int tecla) {
    }

    public boolean comprobarGameOver() {
        return true;
    }

    public void iniciarJuego() {
    }

    public void finalizarJuego() {
    }

    public void pausarJuego() {
        this.juegoPausado = true;
    }

    public void reanudarJuego() {
        this.juegoPausado = false;
    }

    public void reiniciarJuego() {
        this.finalizarJuego();
        this.iniciarJuego();
    }

    protected Pieza obtenerPieza() {
        return null;
    }

    protected void sacarPieza() {
    }

    protected void cicloJuego() {
        if (this.juegoPausado) {
            return;
        }
    }

    protected void actualizarPanel(Graphics contenedor) {
    }

    protected void representarTodo(Graphics contenedor) {
    }
}

