/*
 * Decompiled with CFR 0.152.
 */
package gui;

import configuracion.Aspecto;
import configuracion.Idiomas;
import configuracion.Otros;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;
import logica.Menu;
import logica.Paleta;
import logica.Panel;
import logica.Pieza;
import logica.Tablero;
import principal.Main;

public class MotorGrafico {
    protected static int[][] graficoBackup = new int[127][127];
    protected static boolean[][] graficoBackupPintado = new boolean[127][127];
    protected static boolean graficoInicializado = false;
    protected static final int numeroCodificacionPiezas = Otros.getNumeroCodificacionPiezas();
    protected static final int VACIO = Otros.getNumeroVacio();
    protected static boolean usarImagenes = Aspecto.getUsarImagenes();
    protected static byte celdaAncho = Aspecto.getCeldaAncho();
    protected static byte celdaAlto = Aspecto.getCeldaAlto();
    protected static Image[] imagenes = new Image[127];
    protected static String directorioImagenes = Otros.getDirectorioImagenes();

    public static void setUsarImagenes(boolean usarImagenes) {
        MotorGrafico.usarImagenes = usarImagenes;
    }

    public static boolean getUsarImagenes() {
        return usarImagenes;
    }

    public static void setCeldaAncho(byte celdaAncho) {
        MotorGrafico.celdaAncho = celdaAncho;
    }

    public static byte getCeldaAncho() {
        return celdaAncho;
    }

    public static void setCeldaAlto(byte celdaAlto) {
        MotorGrafico.celdaAlto = celdaAlto;
    }

    public static byte getCeldaAlto() {
        return celdaAlto;
    }

    public static void dibujar(Graphics g, Object objeto) {
        if (objeto instanceof Pieza) {
            MotorGrafico.dibujarPieza(g, (Pieza)objeto);
        } else if (objeto instanceof Tablero) {
            MotorGrafico.dibujarTablero(g, (Tablero)objeto);
        } else if (objeto instanceof Panel) {
            MotorGrafico.dibujarPanel(g, (Panel)objeto);
        } else if (objeto instanceof Menu) {
            MotorGrafico.dibujarMenu(g, (Menu)objeto);
        }
    }

    public static void dibujarPieza(Graphics g, Pieza pieza) {
        Paleta paleta = pieza.getPaleta();
        byte x = pieza.getLeft();
        byte y = pieza.getTop();
        byte ancho = pieza.getAncho();
        byte alto = pieza.getAlto();
        int[][] matriz = pieza.getForma();
        MotorGrafico.dibujarMatriz(g, paleta, matriz, x, y, ancho, alto, false);
    }

    public static void dibujarTablero(Graphics g, Tablero tablero) {
        Paleta paleta = tablero.getPaleta();
        byte x = 0;
        byte y = 0;
        byte ancho = tablero.getAncho();
        byte alto = tablero.getAlto();
        int[][] matriz = tablero.getMapa();
        MotorGrafico.dibujarMatriz(g, paleta, matriz, x, y, ancho, alto, true);
    }

    public static void dibujarPanel(Graphics g, Panel panel) {
        Paleta paleta = panel.getPaleta();
        byte x = panel.getLeft();
        byte y = panel.getTop();
        byte ancho = panel.getAncho();
        byte alto = panel.getAlto();
        int[][] matriz = panel.getMapa();
        MotorGrafico.dibujarMatriz(g, paleta, matriz, x, y, ancho, alto, true);
        MotorGrafico.dibujarPanelInformacion(g, panel);
    }

    protected static void dibujarPanelInformacion(Graphics g, Panel panel) {
        int nivel = panel.getNivel();
        int puntos = panel.getPuntos();
        int lineas = panel.getLineas();
        int lineasNivel = panel.getLineasNivel();
        int x = panel.getLeft() * MotorGrafico.getCeldaAncho();
        int y = (panel.getTop() + panel.getAlto() + panel.getMargen()) * MotorGrafico.getCeldaAlto() + Aspecto.getEspacioLineasTexto();
        g.clearRect(x, y - Aspecto.getEspacioLineasTexto(), 400, Aspecto.getEspacioLineasTexto() * 5);
        Color colorTexto = panel.getPaleta().getColor(panel.getColorTexto());
        Font fuenteTexto = new Font("SansSerif", 0, Aspecto.getDimensionTexto());
        g.setColor(colorTexto);
        g.setFont(fuenteTexto);
        MotorGrafico.dibujarTexto(g, Idiomas.nivel[Main.getIdiomaActual()] + ": " + nivel, x += Aspecto.getDimensionTexto(), y, Aspecto.getEspacioLineasTexto());
        MotorGrafico.dibujarTexto(g, Idiomas.puntuacion[Main.getIdiomaActual()] + ": " + puntos, x, y += Aspecto.getEspacioLineasTexto(), Aspecto.getEspacioLineasTexto());
        MotorGrafico.dibujarTexto(g, Idiomas.lineasTotales[Main.getIdiomaActual()] + ": " + lineas, x, y += Aspecto.getEspacioLineasTexto(), Aspecto.getEspacioLineasTexto());
        MotorGrafico.dibujarTexto(g, Idiomas.lineasNivel[Main.getIdiomaActual()] + ": " + lineasNivel, x, y += Aspecto.getEspacioLineasTexto(), Aspecto.getEspacioLineasTexto());
        y += Aspecto.getEspacioLineasTexto();
    }

    public static void dibujarMenu(Graphics g, Menu menu) {
        String[] opciones = menu.getOpciones();
        Color colorTexto = menu.getPaleta().getColor(menu.getColorTexto());
        Color colorTextoFijo = menu.getPaleta().getColor(menu.getColorTextoFijo());
        Color colorTextoFondo = menu.getPaleta().getColor(menu.getColorTextoFondo());
        Color colorTextoSeleccionado = menu.getPaleta().getColor(menu.getColorTextoSeleccionado());
        Color colorTextoFondoSeleccionado = menu.getPaleta().getColor(menu.getColorTextoFondoSeleccionado());
        Color colorTextoAlternativo = menu.getPaleta().getColor(menu.getColorTextoAlternativo());
        Color colorTextoFondoAlternativo = menu.getPaleta().getColor(menu.getColorTextoFondoAlternativo());
        Font fuenteTexto = new Font("SansSerif", 0, Aspecto.getDimensionTexto());
        g.setFont(fuenteTexto);
        g.setColor(colorTextoFijo);
        MotorGrafico.dibujarTexto(g, menu.getTextoFijo(), menu.getTextoFijoLeft(), menu.getTextoFijoTop(), Aspecto.getEspacioLineasTexto());
        int[][] logo = menu.getLogo();
        MotorGrafico.dibujarMatriz(g, menu.getPaleta(), logo, menu.getLeftLogo(), menu.getTopLogo(), (byte)logo[0].length, (byte)logo.length, false);
        int top = menu.getTop();
        int left = menu.getLeft();
        int[][] dibujo = menu.getDibujoActual();
        if (dibujo != null) {
            MotorGrafico.dibujarMatriz(g, menu.getPaleta(), dibujo, menu.getLeftDibujoActual(), menu.getTopDibujoActual(), (byte)dibujo[0].length, (byte)dibujo.length, false);
        }
        for (int x = 0; x < opciones.length; ++x) {
            if (x == menu.getOpcionActualIndice()) {
                g.setColor(colorTextoSeleccionado);
            } else {
                g.setColor(colorTexto);
            }
            MotorGrafico.dibujarTexto(g, opciones[x], left, top, Aspecto.getEspacioLineasTexto());
            top += Aspecto.getEspacioLineasTexto();
        }
        if (menu.getTextoAlternativoActual() != null && menu.getTextoAlternativoActual().trim() != "") {
            g.setColor(colorTextoAlternativo);
            left = menu.getLeftTextoAlternativoActual();
            top = menu.getTopTextoAlternativoActual();
            MotorGrafico.dibujarTexto(g, menu.getTextoAlternativoActual(), left, top, Aspecto.getEspacioLineasTexto());
        }
    }

    public static void dibujarTexto(Graphics g, String texto, int left, int top, int espacioEntreLineas, Color colorTexto) {
        g.setColor(colorTexto);
        MotorGrafico.dibujarTexto(g, texto, left, top, espacioEntreLineas);
    }

    public static void dibujarTexto(Graphics g, String texto, int left, int top, int espacioEntreLineas) {
        int widthMayor = 0;
        int lineas = 0;
        String[] textoLineas = new String[100];
        int topActual = top;
        while (texto.trim().length() > 0) {
            String textoParcial = texto.indexOf("\n") != -1 ? texto.substring(0, texto.indexOf("\n")) : texto;
            texto = texto.indexOf("\n") != -1 ? texto.substring(texto.indexOf("\n") + 1) : "";
            if (widthMayor < textoParcial.length()) {
                widthMayor = textoParcial.length();
            }
            textoLineas[lineas] = textoParcial;
            ++lineas;
        }
        for (int x = 0; x < lineas; ++x) {
            g.drawString(textoLineas[x], left, topActual);
            topActual += espacioEntreLineas;
        }
    }

    public static void dibujarGraficoBackup(Graphics g, Paleta paleta, int[][] matriz, byte left, byte top, byte ancho, byte alto, boolean dibujarVacios) {
        int[][] graficoBackup = new int[alto][ancho];
        for (int f = 0; f < alto; ++f) {
            for (int c = 0; c < ancho; ++c) {
                graficoBackup[f][c] = graficoBackupPintado[f][c] ? matriz[f][c] : VACIO;
            }
        }
        MotorGrafico.dibujarMatriz(g, paleta, graficoBackup, left, top, (byte)ancho, (byte)alto, dibujarVacios);
    }

    public static synchronized void dibujarMatriz(Graphics g, Paleta paleta, int[][] matriz, byte left, byte top, byte ancho, byte alto, boolean dibujarVacios) {
        if (g == null) {
            System.out.println("Graphics es null!!!!!");
            return;
        }
        if (!graficoInicializado) {
            MotorGrafico.inicializarGraficoBackup();
            graficoInicializado = true;
        }
        byte y = top;
        for (byte f = 0; f < alto; f = (byte)(f + 1)) {
            byte x = left;
            for (byte c = 0; c < ancho; c = (byte)(c + 1)) {
                int indiceColor = matriz[f][c];
                if (indiceColor == VACIO && !dibujarVacios) {
                    x = (byte)(x + 1);
                    continue;
                }
                MotorGrafico.dibujarCasilla(g, paleta, indiceColor, x, y);
                x = (byte)(x + 1);
            }
            y = (byte)(y + 1);
        }
    }

    protected static synchronized void dibujarCasilla(Graphics g, Paleta paleta, int indiceColor, byte x, byte y) {
        if (x < 0 || y < 0) {
            return;
        }
        if (indiceColor < 0) {
            indiceColor /= numeroCodificacionPiezas;
        }
        if (graficoBackup[y][x] == indiceColor && graficoBackupPintado[y][x]) {
            return;
        }
        MotorGrafico.actualizarGraficoBackup(indiceColor, x, y);
        Color color = paleta.getColor(indiceColor);
        g.setColor(color);
        int xReal = x * MotorGrafico.getCeldaAncho();
        int yReal = y * MotorGrafico.getCeldaAlto();
        boolean celdaRepresentada = false;
        if (MotorGrafico.getUsarImagenes()) {
            Image img;
            if (imagenes[indiceColor] == null) {
                MotorGrafico.cargarImagen(indiceColor);
            }
            if ((img = imagenes[indiceColor]) != null) {
                MediaTracker tracker = null;
                if (Otros.getTipoPrograma() == 0) {
                    tracker = new MediaTracker(Main.ventanaPrincipal);
                } else if (Otros.getTipoPrograma() == 1) {
                    tracker = new MediaTracker(Main.appletPrincipal);
                }
                if (tracker != null) {
                    tracker.addImage(img, 1);
                    try {
                        tracker.waitForAll();
                    }
                    catch (Exception e) {
                        System.out.println("Excepcion: " + e.getMessage());
                    }
                    g.drawImage(img, xReal, yReal, MotorGrafico.getCeldaAncho(), MotorGrafico.getCeldaAlto(), null);
                    celdaRepresentada = true;
                }
            }
        }
        if (!celdaRepresentada) {
            g.fillRect(xReal, yReal, MotorGrafico.getCeldaAncho(), MotorGrafico.getCeldaAlto());
        }
    }

    protected static void actualizarGraficoBackup(int indiceColor, byte x, byte y) {
        if (graficoBackup[y][x] != indiceColor) {
            MotorGrafico.graficoBackup[y][x] = indiceColor;
            MotorGrafico.graficoBackupPintado[y][x] = true;
        }
    }

    public static void inicializarGraficoBackup() {
        for (int f = 0; f < graficoBackup.length; f = (int)((byte)(f + 1))) {
            for (int c = 0; c < graficoBackup[0].length; c = (int)((byte)(c + 1))) {
                MotorGrafico.graficoBackup[f][c] = -1;
                MotorGrafico.graficoBackupPintado[f][c] = false;
            }
        }
    }

    protected static void cargarImagen(int indice) {
        Image img = null;
        ClassLoader classLoader = MotorGrafico.class.getClassLoader();
        URL gifURL = classLoader.getResource(MotorGrafico.getDirectorioImagenes() + indice + ".gif");
        URL jpgURL = classLoader.getResource(MotorGrafico.getDirectorioImagenes() + indice + ".jpg");
        URL jpegURL = classLoader.getResource(MotorGrafico.getDirectorioImagenes() + indice + ".jpeg");
        URL pngURL = classLoader.getResource(MotorGrafico.getDirectorioImagenes() + indice + ".png");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (gifURL != null) {
            img = toolkit.getImage(gifURL);
        } else if (jpgURL != null) {
            img = toolkit.getImage(jpgURL);
        } else if (jpegURL != null) {
            img = toolkit.getImage(jpegURL);
        } else if (pngURL != null) {
            img = toolkit.getImage(pngURL);
        }
        MotorGrafico.imagenes[indice] = img;
    }

    protected static Image getImagenFondo() {
        Image img = null;
        ClassLoader classLoader = MotorGrafico.class.getClassLoader();
        URL gifURL = classLoader.getResource(MotorGrafico.getDirectorioImagenes() + "bg.gif");
        URL jpgURL = classLoader.getResource(MotorGrafico.getDirectorioImagenes() + "bg.jpg");
        URL jpegURL = classLoader.getResource(MotorGrafico.getDirectorioImagenes() + "bg.jpeg");
        URL pngURL = classLoader.getResource(MotorGrafico.getDirectorioImagenes() + "bg.png");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (gifURL != null) {
            img = toolkit.getImage(gifURL);
        } else if (jpgURL != null) {
            img = toolkit.getImage(jpgURL);
        } else if (jpegURL != null) {
            img = toolkit.getImage(jpegURL);
        } else if (pngURL != null) {
            img = toolkit.getImage(pngURL);
        }
        return img;
    }

    public static void setDirectorioImagenes(String directorioImagenes) {
        MotorGrafico.directorioImagenes = directorioImagenes;
    }

    public static String getDirectorioImagenes() {
        String directorio = directorioImagenes;
        return directorio;
    }

    public static void limpiarImagenBuffer(BufferedImage imagenBuffer, Paleta paleta) {
        Image img;
        Graphics contenedorBuffer = imagenBuffer.getGraphics();
        contenedorBuffer.setColor(Aspecto.getColorFondoImagenBuffer());
        contenedorBuffer.fillRect(0, 0, imagenBuffer.getWidth(), imagenBuffer.getHeight());
        if (Aspecto.getUsarImagenFondo() && (img = MotorGrafico.getImagenFondo()) != null) {
            MediaTracker tracker = null;
            if (Otros.getTipoPrograma() == 0) {
                tracker = new MediaTracker(Main.ventanaPrincipal);
            } else if (Otros.getTipoPrograma() == 1) {
                tracker = new MediaTracker(Main.appletPrincipal);
            }
            if (tracker != null) {
                tracker.addImage(img, 1);
                try {
                    tracker.waitForAll();
                }
                catch (Exception e) {
                    System.out.println("Excepcion: " + e.getMessage());
                }
                contenedorBuffer.drawImage(img, 0, 0, imagenBuffer.getWidth(), imagenBuffer.getHeight(), null);
            }
        }
        int ancho = imagenBuffer.getWidth() / MotorGrafico.getCeldaAncho() + 1;
        int alto = imagenBuffer.getHeight() / MotorGrafico.getCeldaAlto() + 1;
        if (ancho > 127) {
            ancho = 127;
        }
        if (alto > 127) {
            alto = 127;
        }
        MotorGrafico.dibujarGraficoBackup(contenedorBuffer, paleta, graficoBackup, (byte)0, (byte)0, (byte)ancho, (byte)alto, false);
        MotorGrafico.inicializarGraficoBackup();
    }

    public static void dibujarImagenBuffer(Graphics contenedor, BufferedImage imagenBuffer) {
        MediaTracker tracker = null;
        if (Otros.getTipoPrograma() == 0) {
            tracker = new MediaTracker(Main.ventanaPrincipal);
        } else if (Otros.getTipoPrograma() == 1) {
            tracker = new MediaTracker(Main.appletPrincipal);
        }
        if (tracker != null) {
            tracker.addImage(imagenBuffer, 1);
            try {
                tracker.waitForAll();
            }
            catch (Exception e) {
                System.out.println("Excepcion: " + e.getMessage());
            }
            contenedor.drawImage(imagenBuffer, 0, 0, null);
        }
    }

    public String toString() {
        return MotorGrafico.toString(null);
    }

    public static String toString(Object o) {
        String cadena = "\n";
        int filas = 30;
        int columnas = 30;
        if (Main.juego != null) {
            filas = Main.juego.getTablero().getAlto();
            columnas = (byte)(Main.juego.getPanel().getLeft() + Main.juego.getPanel().getAncho());
        }
        for (int f = 0; f < filas; f = (int)((byte)(f + 1))) {
            for (int c = 0; c < columnas; c = (int)((byte)(c + 1))) {
                cadena = cadena + graficoBackup[f][c] + "   ";
            }
            cadena = cadena + "\n";
        }
        return cadena;
    }
}

