/*
 * Decompiled with CFR 0.152.
 */
package logica;

import configuracion.Menus;
import configuracion.Otros;
import configuracion.PaletaColores;
import configuracion.Piezas;
import configuracion.Teclas;
import gui.MotorGrafico;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import logica.Menu;
import logica.Paleta;
import logica.Panel;
import logica.Pieza;
import logica.Tablero;
import logica.TimerJuego;
import logica.TimerRepintado;
import logica.TimerTeclado;
import principal.Main;
import sonido.MotorSonido;

public class Juego {
    protected int[] teclaArriba = Teclas.getTeclaArriba();
    protected int[] teclaAbajo = Teclas.getTeclaAbajo();
    protected int[] teclaDerecha = Teclas.getTeclaDerecha();
    protected int[] teclaIzquierda = Teclas.getTeclaIzquierda();
    protected int[] teclaRotarDerecha = Teclas.getTeclaRotarDerecha();
    protected int[] teclaRotarIzquierda = Teclas.getTeclaRotarIzquierda();
    protected int[] teclaAceptar = Teclas.getTeclaAceptar();
    protected int[] teclaPausa = Teclas.getTeclaPausa();
    protected int[] teclaSalir = Teclas.getTeclaSalir();
    protected Timer timerJuego = null;
    protected Timer timerRepintado = null;
    protected Timer timerLectorTeclado = null;
    protected int velocidadLectorTeclado = Otros.getVelocidadLectorTeclado();
    protected Graphics contenedorGrafico;
    protected BufferedImage imagenBuffer = null;
    protected boolean sonidoActivado = Otros.getSonidoActivado();
    protected boolean musicaActivada = Otros.getMusicaActivada();
    protected Panel panel = null;
    protected Menu menuPrincipal = null;
    protected Menu menuPausa = null;
    protected Paleta paleta;
    protected Pieza[] piezasBase;
    protected int velocidad = Otros.getVelocidadInicial();
    protected int velocidadMinima = Otros.getVelocidadMinima();
    protected int velocidadMaxima = Otros.getVelocidadMaxima();
    protected int incrementoVelocidad = Otros.getIncrementoVelocidad();
    protected boolean juegoComenzado = false;
    protected boolean juegoPausado = false;
    protected int nivel;
    protected int puntos;
    protected int puntosPorPiezaPuesta = Otros.getPuntosPorPiezaPuesta();
    protected int puntosPorLinea = Otros.getPuntosPorLinea();
    protected int lineas;
    protected int lineasNivel;
    protected int lineasNecesariasNivel = Otros.getLineasNecesariasNivel();
    protected Tablero tablero;
    protected boolean desplazarPiezaSiNoCabeAlRotar = Otros.getDesplazarPiezaSiNoCabeAlRotar();
    protected Pieza piezaActual;
    protected Pieza piezaSiguiente;
    protected boolean piezaColisionada;

    public Juego(Graphics contenedor) {
        this(contenedor, null, null);
    }

    public Juego(Graphics contenedor, Paleta paleta) {
        this(contenedor, paleta, null);
    }

    public Juego(Graphics contenedor, Paleta paleta, Pieza[] piezasBase) {
        this.setContenedorGrafico(contenedor);
        if (paleta == null) {
            paleta = PaletaColores.getPaleta();
        }
        this.setPaleta(paleta);
        if (piezasBase == null) {
            piezasBase = Piezas.getPiezas(this.getPaleta());
        }
        this.setPiezasBase(piezasBase);
        byte alto = Otros.getTableroAlto();
        byte ancho = Otros.getTableroAncho();
        this.tablero = new Tablero(ancho, alto, this.getPaleta());
        this.panel = new Panel(this.getPiezasBase(), this.getPaleta(), this.getTablero());
        this.menuPrincipal = Menus.getMenuPrincipal();
        this.menuPrincipal.setPaleta(this.getPaleta());
        this.menuPausa = Menus.getMenuPausa();
        this.menuPausa.setPaleta(this.getPaleta());
        try {
            Thread.sleep(100L);
        }
        catch (Exception e) {
            System.out.println("Excepcion: " + e.getMessage());
        }
        this.redimensionarImagenBuffer();
        this.iniciarRepintado();
        this.iniciarLectorTeclado();
    }

    public void setContenedorGrafico(Graphics contenedor) {
        this.contenedorGrafico = contenedor;
    }

    public Graphics getContenedorGrafico() {
        return this.contenedorGrafico;
    }

    public void setPaleta(Paleta paleta) {
        this.paleta = paleta;
        if (this.getPanel() != null) {
            this.getPanel().setPaleta(paleta);
        }
        if (this.getMenuPrincipal() != null) {
            this.getMenuPrincipal().setPaleta(paleta);
        }
        if (this.getMenuPausa() != null) {
            this.getMenuPausa().setPaleta(paleta);
        }
    }

    public Paleta getPaleta() {
        return this.paleta;
    }

    public int[] getTeclaArriba() {
        return this.teclaArriba;
    }

    public void setTeclaArriba(int[] teclaArriba) {
        this.teclaArriba = teclaArriba;
    }

    public int[] getTeclaAbajo() {
        return this.teclaAbajo;
    }

    public void setTeclaAbajo(int[] teclaAbajo) {
        this.teclaAbajo = teclaAbajo;
    }

    public int[] getTeclaDerecha() {
        return this.teclaDerecha;
    }

    public void setTeclaDerecha(int[] teclaDerecha) {
        this.teclaDerecha = teclaDerecha;
    }

    public int[] getTeclaIzquierda() {
        return this.teclaIzquierda;
    }

    public void setTeclaIzquierda(int[] teclaIzquierda) {
        this.teclaIzquierda = teclaIzquierda;
    }

    public int[] getTeclaRotarDerecha() {
        return this.teclaRotarDerecha;
    }

    public void setTeclaRotarDerecha(int[] teclaRotarDerecha) {
        this.teclaRotarDerecha = teclaRotarDerecha;
    }

    public int[] getTeclaRotarIzquierda() {
        return this.teclaRotarIzquierda;
    }

    public void setTeclaRotarIzquierda(int[] teclaRotarIzquierda) {
        this.teclaRotarIzquierda = teclaRotarIzquierda;
    }

    public int[] getTeclaAceptar() {
        return this.teclaAceptar;
    }

    public void setTeclaAceptar(int[] teclaAceptar) {
        this.teclaAceptar = teclaAceptar;
    }

    public int[] getTeclaPausa() {
        return this.teclaPausa;
    }

    public void setTeclaPausa(int[] teclaPausa) {
        this.teclaPausa = teclaPausa;
    }

    public int[] getTeclaSalir() {
        return this.teclaSalir;
    }

    public void setTeclaSalir(int[] teclaSalir) {
        this.teclaSalir = teclaSalir;
    }

    public int getVelocidadLectorTeclado() {
        return this.velocidadLectorTeclado;
    }

    public void setVelocidadLectorTeclado(int velocidadLectorTeclado) {
        if (velocidadLectorTeclado > 0) {
            this.velocidadLectorTeclado = velocidadLectorTeclado;
        }
    }

    public Panel getPanel() {
        return this.panel;
    }

    public Menu getMenuPrincipal() {
        return this.menuPrincipal;
    }

    public Menu getMenuPausa() {
        return this.menuPausa;
    }

    public Tablero getTablero() {
        return this.tablero;
    }

    public void setPiezasBase(Pieza[] piezasBase) {
        this.piezasBase = piezasBase;
        if (this.getPanel() != null) {
            this.getPanel().setPiezasBase(piezasBase);
            Main.redimensionarVentana();
            this.redimensionarImagenBuffer();
        }
    }

    protected int numeroPiezasBase() {
        return this.getPiezasBase().length;
    }

    public Pieza[] getPiezasBase() {
        return this.piezasBase;
    }

    public void setDesplazarPiezaSiNoCabeAlRotar(boolean desplazarPiezaSiNoCabeAlRotar) {
        this.desplazarPiezaSiNoCabeAlRotar = desplazarPiezaSiNoCabeAlRotar;
    }

    public boolean getDesplazarPiezaSiNoCabeAlRotar() {
        return this.desplazarPiezaSiNoCabeAlRotar;
    }

    public void setSonidoActivado(boolean sonidoActivado) {
        this.sonidoActivado = sonidoActivado;
    }

    public boolean getSonidoActivado() {
        return this.sonidoActivado;
    }

    public void desactivarSonido() {
        this.setSonidoActivado(false);
    }

    public void activarSonido() {
        this.setSonidoActivado(true);
    }

    public void alternarSonido() {
        if (this.getSonidoActivado()) {
            this.desactivarSonido();
        } else {
            this.activarSonido();
        }
    }

    public void setMusicaActivada(boolean musicaActivada) {
        this.musicaActivada = musicaActivada;
    }

    public boolean getMusicaActivada() {
        return this.musicaActivada;
    }

    public void desactivarMusica() {
        this.setMusicaActivada(false);
    }

    public void activarMusica() {
        this.setMusicaActivada(true);
    }

    public void alternarMusica() {
        if (this.getMusicaActivada()) {
            this.desactivarMusica();
        } else {
            this.activarMusica();
        }
    }

    public void definirTeclas(int[] teclaArriba, int[] teclaAbajo, int[] teclaDerecha, int[] teclaIzquierda, int[] teclaRotarDerecha, int[] teclaRotarIzquierda, int[] teclaAceptar, int[] teclaPausa, int[] teclaSalir) {
        this.setTeclaArriba(teclaArriba);
        this.setTeclaAbajo(teclaAbajo);
        this.setTeclaDerecha(teclaDerecha);
        this.setTeclaIzquierda(teclaIzquierda);
        this.setTeclaRotarDerecha(teclaRotarDerecha);
        this.setTeclaRotarIzquierda(teclaRotarIzquierda);
        this.setTeclaAceptar(teclaAceptar);
        this.setTeclaPausa(teclaPausa);
        this.setTeclaSalir(teclaSalir);
    }

    public void modificarDimensionesTablero(byte ancho, byte alto) {
        this.getTablero().setAncho(ancho);
        this.getTablero().setAlto(alto);
        this.getPanel().setTablero(this.getTablero());
        Main.redimensionarVentana();
        this.redimensionarImagenBuffer();
    }

    public void redimensionarImagenBuffer() {
        int imagenAncho = 0;
        int imagenAlto = 0;
        if (Otros.getTipoPrograma() == 0) {
            imagenAncho = Main.ventanaPrincipal.getWidth();
            imagenAlto = Main.ventanaPrincipal.getHeight();
        } else if (Otros.getTipoPrograma() == 1) {
            imagenAncho = Main.appletPrincipal.getWidth();
            imagenAlto = Main.appletPrincipal.getHeight();
        }
        this.imagenBuffer = new BufferedImage(imagenAncho, imagenAlto, 7);
        this.limpiarImagenBuffer();
        this.representarTodo(this.getContenedorGrafico());
    }

    protected void limpiarImagenBuffer() {
        MotorGrafico.limpiarImagenBuffer(this.imagenBuffer, this.getPaleta());
    }

    public void setVelocidad(int velocidad) {
        this.velocidad = velocidad <= this.velocidadMinima && velocidad >= this.velocidadMaxima ? velocidad : (velocidad < this.velocidadMaxima ? this.velocidadMaxima : this.velocidadMinima);
    }

    public int getVelocidad() {
        return this.velocidad;
    }

    public void setVelocidadMinima(int velocidadMinima) {
        if (velocidadMinima > 0 && velocidadMinima > this.velocidadMaxima) {
            this.velocidadMinima = velocidadMinima;
        }
    }

    public int getVelocidadMinima() {
        return this.velocidadMinima;
    }

    public void setVelocidadMaxima(int velocidadMaxima) {
        if (velocidadMaxima > 0 && velocidadMaxima < this.velocidadMinima) {
            this.velocidadMaxima = velocidadMaxima;
        }
    }

    public int getVelocidadMaxima() {
        return this.velocidadMaxima;
    }

    public void setIncrementoVelocidad(int incrementoVelocidad) {
        if (incrementoVelocidad > 0 && incrementoVelocidad <= this.velocidadMinima - this.velocidadMaxima) {
            this.incrementoVelocidad = incrementoVelocidad;
        }
    }

    public int getIncrementoVelocidad() {
        return this.incrementoVelocidad;
    }

    protected void subirVelocidad() {
        this.setVelocidad(this.getVelocidad() + this.getIncrementoVelocidad());
        if (this.juegoComenzado) {
            this.pararCiclo();
            this.iniciarCiclo();
        }
    }

    protected void bajarVelocidad() {
        this.setVelocidad(this.getVelocidad() - this.getIncrementoVelocidad());
        if (this.juegoComenzado) {
            this.pararCiclo();
            this.iniciarCiclo();
        }
    }

    public void setNivel(int nivel) {
        this.nivel = nivel;
        this.getPanel().setNivel(nivel);
    }

    public int getNivel() {
        return this.nivel;
    }

    protected void subirNivel() {
        this.setNivel(this.getNivel() + 1);
        this.subirVelocidad();
    }

    protected void setPuntos(int puntos) {
        this.puntos = puntos;
        this.getPanel().setPuntos(this.getPuntos());
    }

    public int getPuntos() {
        return this.puntos;
    }

    protected void setPuntosPorPiezaPuesta(int puntosPorPiezaPuesta) {
        if (puntosPorPiezaPuesta >= 0) {
            this.puntosPorPiezaPuesta = puntosPorPiezaPuesta;
        }
    }

    protected int getPuntosPorPiezaPuesta() {
        return this.puntosPorPiezaPuesta;
    }

    protected void setPuntosPorLinea(int puntosPorLinea) {
        if (puntosPorLinea >= 0) {
            this.puntosPorLinea = puntosPorLinea;
        }
    }

    protected int getPuntosPorLinea() {
        return this.puntosPorLinea;
    }

    protected void sumarPuntos(int puntos) {
        this.setPuntos(this.getPuntos() + puntos);
    }

    protected void setLineas(int lineas) {
        if (lineas >= 0) {
            this.lineas = lineas;
            this.getPanel().setLineas(lineas);
        }
    }

    public int getLineas() {
        return this.lineas;
    }

    protected void setLineasNivel(int lineasNivel) {
        if (lineasNivel >= 0) {
            this.lineasNivel = lineasNivel;
            this.getPanel().setLineasNivel(lineasNivel);
        }
    }

    public int getLineasNivel() {
        return this.lineasNivel;
    }

    public void setLineasNecesariasNivel(int lineasNecesariasNivel) {
        if (lineasNecesariasNivel >= 1) {
            this.lineasNecesariasNivel = lineasNecesariasNivel;
        }
    }

    public int getLineasNecesariasNivel() {
        return this.lineasNecesariasNivel;
    }

    protected void sumarLineas(int numeroLineas) {
        if (numeroLineas > 0) {
            this.setLineas(this.getLineas() + numeroLineas);
        }
    }

    protected void sumarLineasNivel(int numeroLineas) {
        if (numeroLineas > 0) {
            this.setLineasNivel(this.getLineasNivel() + numeroLineas);
        }
    }

    public void procesarTecla(int tecla) {
        boolean piezaRotada;
        boolean limpiarBuffer = false;
        boolean repintarTodo = false;
        boolean impedirRotacion = false;
        if (this.teclaEnTeclas(tecla, this.getTeclaAceptar())) {
            if (this.getMenuPrincipal() != null && this.getMenuPrincipal().getMostrar()) {
                this.getMenuPrincipal().aceptarOpcionActual();
                this.procesarMenuPrincipal();
                limpiarBuffer = true;
                if (this.getMenuPrincipal().getMostrar()) {
                    repintarTodo = true;
                }
            }
            if (this.getMenuPausa() != null && this.getMenuPausa().getMostrar()) {
                this.getMenuPausa().aceptarOpcionActual();
                this.procesarMenuPausa();
                limpiarBuffer = true;
                if (this.getMenuPausa().getMostrar()) {
                    repintarTodo = true;
                }
                impedirRotacion = true;
            }
        }
        if (this.teclaEnTeclas(tecla, this.getTeclaArriba())) {
            if (this.getMenuPrincipal() != null && this.getMenuPrincipal().getMostrar()) {
                this.getMenuPrincipal().subirOpcion();
                limpiarBuffer = true;
                if (this.getMenuPrincipal().getMostrar()) {
                    repintarTodo = true;
                }
            }
            if (this.getMenuPausa() != null && this.getMenuPausa().getMostrar()) {
                this.getMenuPausa().subirOpcion();
                limpiarBuffer = true;
                if (this.getMenuPausa().getMostrar()) {
                    repintarTodo = true;
                }
            }
        }
        if (this.teclaEnTeclas(tecla, this.getTeclaAbajo())) {
            if (this.getJuegoComenzado() && !this.getJuegoPausado() && this.piezaActual != null) {
                this.piezaActual.moverAbajo(this.getTablero());
                repintarTodo = true;
            }
            if (this.getMenuPrincipal() != null && this.getMenuPrincipal().getMostrar()) {
                this.getMenuPrincipal().bajarOpcion();
                limpiarBuffer = true;
                if (this.getMenuPrincipal().getMostrar()) {
                    repintarTodo = true;
                }
            }
            if (this.getMenuPausa() != null && this.getMenuPausa().getMostrar()) {
                this.getMenuPausa().bajarOpcion();
                limpiarBuffer = true;
                if (this.getMenuPausa().getMostrar()) {
                    repintarTodo = true;
                }
            }
        }
        if (this.teclaEnTeclas(tecla, this.getTeclaDerecha()) && this.getJuegoComenzado() && !this.getJuegoPausado() && this.piezaActual != null) {
            this.piezaActual.moverDerecha(this.getTablero());
            repintarTodo = true;
        }
        if (this.teclaEnTeclas(tecla, this.getTeclaIzquierda()) && this.getJuegoComenzado() && !this.getJuegoPausado() && this.piezaActual != null) {
            this.piezaActual.moverIzquierda(this.getTablero());
            repintarTodo = true;
        }
        if (!impedirRotacion && this.teclaEnTeclas(tecla, this.getTeclaRotarDerecha()) && this.getJuegoComenzado() && !this.getJuegoPausado() && this.piezaActual != null) {
            piezaRotada = this.piezaActual.rotarDerecha(this.getTablero(), this.getDesplazarPiezaSiNoCabeAlRotar());
            if (this.getSonidoActivado() && piezaRotada) {
                MotorSonido.piezaRotada();
            }
            repintarTodo = true;
        }
        if (!impedirRotacion && this.teclaEnTeclas(tecla, this.getTeclaRotarIzquierda()) && this.getJuegoComenzado() && !this.getJuegoPausado() && this.piezaActual != null) {
            piezaRotada = this.piezaActual.rotarIzquierda(this.getTablero(), this.getDesplazarPiezaSiNoCabeAlRotar());
            if (this.getSonidoActivado() && piezaRotada) {
                MotorSonido.piezaRotada();
            }
            repintarTodo = true;
        }
        boolean menuPausaMostradoAhora = false;
        if (this.teclaEnTeclas(tecla, this.getTeclaPausa()) && this.getJuegoComenzado() && !this.getJuegoPausado() && this.getMenuPausa() != null && !this.getMenuPausa().getMostrar() && this.getMenuPrincipal() != null && !this.getMenuPrincipal().getMostrar()) {
            this.pausarJuego();
            menuPausaMostradoAhora = true;
        }
        if (this.teclaEnTeclas(tecla, this.getTeclaSalir())) {
            if (this.getJuegoComenzado() && !this.getJuegoPausado() && this.getMenuPausa() != null && !this.getMenuPausa().getMostrar() && this.getMenuPrincipal() != null && !this.getMenuPrincipal().getMostrar()) {
                this.pausarJuego();
                repintarTodo = true;
            }
            if (this.getMenuPrincipal() != null && this.getMenuPrincipal().getMostrar()) {
                if (this.getMenuPrincipal().obtenerSubmenu(this.getMenuPrincipal().getOpcionActualIndiceSinRecursividad()) != null && this.getMenuPrincipal().getOpcionAceptada()) {
                    this.getMenuPrincipal().cancelarOpcionActual();
                    if (this.getMenuPrincipal().getMostrar()) {
                        repintarTodo = true;
                    }
                } else {
                    this.getMenuPrincipal().setOpcionActual("FINALIZAR");
                    if (this.getMenuPrincipal().getMostrar()) {
                        repintarTodo = true;
                    }
                }
                limpiarBuffer = true;
            }
            if (this.getMenuPausa() != null && this.getMenuPausa().getMostrar()) {
                if (this.getMenuPausa().obtenerSubmenu(this.getMenuPausa().getOpcionActualIndiceSinRecursividad()) != null && this.getMenuPausa().getOpcionAceptada()) {
                    this.getMenuPausa().cancelarOpcionActual();
                    if (this.getMenuPausa().getMostrar()) {
                        repintarTodo = true;
                    }
                } else if (!menuPausaMostradoAhora) {
                    this.reanudarJuego();
                    repintarTodo = true;
                }
                limpiarBuffer = true;
            }
        }
        if (limpiarBuffer) {
            this.limpiarImagenBuffer();
        }
        if (repintarTodo) {
            this.representarTodo(this.getContenedorGrafico());
        }
    }

    protected void procesarMenuPrincipal() {
        if (this.getMenuPrincipal() != null && this.getMenuPrincipal().getMostrar() && this.getMenuPrincipal().getOpcionAceptada()) {
            String opcionSeleccionada = this.getMenuPrincipal().getOpcionActualValor();
            if (opcionSeleccionada.toUpperCase().equals("INICIAR")) {
                if (!this.getJuegoComenzado()) {
                    this.ocultarMenuPrincipal();
                    this.iniciarJuego();
                } else {
                    this.ocultarMenuPrincipal();
                    this.reiniciarJuego();
                }
            } else if (!opcionSeleccionada.toUpperCase().equals("OPCIONES") && !opcionSeleccionada.toUpperCase().equals("FINALIZAR")) {
                if (opcionSeleccionada.toUpperCase().equals("FINALIZAR_SI")) {
                    if (this.getMenuPrincipal().getOpcionAceptadaSubmenu()) {
                        if (this.getJuegoComenzado()) {
                            this.finalizarJuego();
                        }
                        System.exit(0);
                    }
                } else if (opcionSeleccionada.toUpperCase().equals("FINALIZAR_NO") && this.getMenuPrincipal().getOpcionAceptadaSubmenu()) {
                    this.getMenuPrincipal().cancelarOpcionActual();
                }
            }
        }
    }

    protected void procesarMenuPausa() {
        if (this.getMenuPausa() != null && this.getMenuPausa().getMostrar() && this.getMenuPausa().getOpcionAceptada()) {
            String opcionSeleccionada = this.getMenuPausa().getOpcionActualValor();
            if (opcionSeleccionada.toUpperCase().equals("CONTINUAR")) {
                this.reanudarJuego();
            } else if (!opcionSeleccionada.toUpperCase().equals("TERMINAR")) {
                if (opcionSeleccionada.toUpperCase().equals("FINALIZAR_SI")) {
                    if (this.getMenuPausa().getOpcionAceptadaSubmenu()) {
                        this.getMenuPausa().cancelarOpcionActual();
                        if (this.getJuegoComenzado()) {
                            this.finalizarJuego();
                        }
                        this.iniciarJuego();
                        this.ocultarMenuPausa();
                        this.mostrarMenuPrincipal();
                    }
                } else if (opcionSeleccionada.toUpperCase().equals("FINALIZAR_NO") && this.getMenuPausa().getOpcionAceptadaSubmenu()) {
                    this.getMenuPausa().cancelarOpcionActual();
                }
            }
        }
    }

    protected boolean teclaEnTeclas(int tecla, int[] teclas) {
        boolean encontrada = false;
        for (int x = 0; x < teclas.length; ++x) {
            if (teclas[x] != tecla) continue;
            encontrada = true;
            break;
        }
        return encontrada;
    }

    public boolean teclaEnTeclasTodas(int tecla) {
        boolean encontrada = false;
        if (this.teclaEnTeclas(tecla, this.getTeclaArriba())) {
            encontrada = true;
        }
        if (this.teclaEnTeclas(tecla, this.getTeclaAbajo())) {
            encontrada = true;
        }
        if (this.teclaEnTeclas(tecla, this.getTeclaDerecha())) {
            encontrada = true;
        }
        if (this.teclaEnTeclas(tecla, this.getTeclaIzquierda())) {
            encontrada = true;
        }
        if (this.teclaEnTeclas(tecla, this.getTeclaRotarDerecha())) {
            encontrada = true;
        }
        if (this.teclaEnTeclas(tecla, this.getTeclaRotarIzquierda())) {
            encontrada = true;
        }
        if (this.teclaEnTeclas(tecla, this.getTeclaAceptar())) {
            encontrada = true;
        }
        if (this.teclaEnTeclas(tecla, this.getTeclaPausa())) {
            encontrada = true;
        }
        if (this.teclaEnTeclas(tecla, this.getTeclaSalir())) {
            encontrada = true;
        }
        return encontrada;
    }

    public boolean comprobarGameOver() {
        return true;
    }

    public boolean getJuegoComenzado() {
        return this.juegoComenzado;
    }

    public boolean getJuegoPausado() {
        return this.juegoPausado;
    }

    public void restaurarValores() {
        this.getTablero().vaciar();
        this.getPanel().vaciar();
        this.piezaActual = null;
        this.piezaSiguiente = null;
        this.piezaColisionada = false;
        this.setNivel(0);
        this.setPuntos(0);
        this.setLineas(0);
        this.setLineasNivel(0);
    }

    public void iniciarJuego() {
        if (this.getJuegoComenzado()) {
            return;
        }
        this.reanudarJuego();
        this.juegoComenzado = true;
        this.restaurarValores();
        this.iniciarCiclo();
    }

    public void finalizarJuego() {
        if (!this.juegoComenzado) {
            return;
        }
        this.juegoComenzado = false;
        this.pararCiclo();
        this.restaurarValores();
    }

    public void pausarJuego() {
        if (this.getJuegoComenzado() && !this.getJuegoPausado()) {
            this.juegoPausado = true;
            this.mostrarMenuPausa();
            this.iniciarRepintado();
            this.pararCiclo();
        }
    }

    public void reanudarJuego() {
        if (this.getJuegoPausado()) {
            this.juegoPausado = false;
            this.ocultarMenuPausa();
            this.iniciarCiclo();
        }
    }

    public void reiniciarJuego() {
        this.finalizarJuego();
        this.iniciarJuego();
    }

    protected Pieza obtenerPieza() {
        int indiceAleatorio = new Random().nextInt(this.getPiezasBase().length);
        return this.getPiezasBase()[indiceAleatorio];
    }

    protected void sacarPieza() {
        if (this.piezaSiguiente == null) {
            Pieza piezaAleatoria = this.obtenerPieza();
            int[][] piezaForma = piezaAleatoria.getForma();
            byte piezaAncho = piezaAleatoria.getAncho();
            byte piezaPosicionHorizontal = (byte)(this.getTablero().getAncho() / 2 - piezaAncho / 2);
            this.piezaActual = new Pieza(piezaForma, this.getPaleta(), piezaPosicionHorizontal);
            this.piezaSiguiente = this.obtenerPieza();
        } else {
            int[][] piezaForma = this.piezaSiguiente.getForma();
            byte piezaAncho = this.piezaSiguiente.getAncho();
            byte piezaPosicionHorizontal = (byte)(this.getTablero().getAncho() / 2 - piezaAncho / 2);
            this.piezaActual = new Pieza(piezaForma, this.getPaleta(), piezaPosicionHorizontal);
            this.piezaSiguiente = this.obtenerPieza();
        }
        this.getPanel().insertarPieza(this.piezaSiguiente);
    }

    protected void cicloJuego() {
        if (this.juegoPausado) {
            this.representarTodo(this.getContenedorGrafico());
            return;
        }
        if (!this.getJuegoComenzado()) {
            return;
        }
        if (this.piezaColisionada) {
            if (this.piezaActual.calcularColision(this.getTablero())) {
                byte lineasHechas;
                this.sumarPuntos(this.getPuntosPorPiezaPuesta());
                this.piezaColisionada = false;
                this.getTablero().agregarPieza(this.piezaActual);
                this.piezaActual = null;
                if (this.getSonidoActivado()) {
                    MotorSonido.piezaColisionada();
                }
                if ((lineasHechas = this.getTablero().procesarLineas()) > 0) {
                    this.sumarLineas(lineasHechas);
                    this.sumarLineasNivel(lineasHechas);
                    this.sumarPuntos(lineasHechas * this.getPuntosPorLinea());
                    if (this.getSonidoActivado()) {
                        MotorSonido.lineaHecha();
                    }
                    while (this.getLineasNivel() >= this.lineasNecesariasNivel) {
                        this.setLineasNivel(this.getLineasNivel() - this.lineasNecesariasNivel);
                        this.subirNivel();
                    }
                }
                if (this.getTablero().estaLleno()) {
                    this.reiniciarJuego();
                }
            } else {
                this.piezaColisionada = false;
            }
        }
        if (this.piezaActual == null) {
            this.sacarPieza();
        }
        if (this.piezaActual != null && this.piezaActual.calcularColision(this.getTablero())) {
            this.piezaColisionada = true;
        } else if (this.piezaActual != null) {
            this.piezaActual.moverAbajo(this.getTablero());
        }
    }

    protected void pararCiclo() {
        if (this.timerJuego != null) {
            this.timerJuego.cancel();
            this.timerJuego.purge();
            this.timerJuego = null;
        }
    }

    protected void iniciarCiclo() {
        if (this.timerJuego != null) {
            this.pararCiclo();
        }
        this.timerJuego = new Timer();
        TimerJuego tarea = new TimerJuego(this);
        this.timerJuego.scheduleAtFixedRate((TimerTask)tarea, 0L, (long)this.getVelocidad());
    }

    protected void pararRepintado() {
        if (this.timerRepintado != null) {
            this.timerRepintado.cancel();
            this.timerRepintado.purge();
            this.timerRepintado = null;
        }
    }

    protected void iniciarRepintado() {
        if (this.timerRepintado != null) {
            this.pararRepintado();
        }
        this.timerRepintado = new Timer();
        TimerRepintado tarea = new TimerRepintado(this);
        this.timerRepintado.scheduleAtFixedRate((TimerTask)tarea, 0L, (long)this.getVelocidad());
    }

    protected void pararLectorTeclado() {
        if (this.timerLectorTeclado != null) {
            this.timerLectorTeclado.cancel();
            this.timerLectorTeclado.purge();
            this.timerLectorTeclado = null;
        }
    }

    protected void iniciarLectorTeclado() {
        if (this.timerLectorTeclado != null) {
            this.pararLectorTeclado();
        }
        this.timerLectorTeclado = new Timer();
        TimerTeclado tarea = new TimerTeclado();
        this.timerLectorTeclado.scheduleAtFixedRate((TimerTask)tarea, 0L, (long)this.getVelocidadLectorTeclado());
    }

    public void mostrarMenuPrincipal() {
        this.getMenuPrincipal().setMostrar(true);
        this.getMenuPrincipal().dibujar(this.getContenedorGrafico(), this.imagenBuffer);
    }

    public void ocultarMenuPrincipal() {
        this.getMenuPrincipal().setMostrar(false);
        this.limpiarImagenBuffer();
        this.representarTodo(this.getContenedorGrafico());
    }

    public void mostrarMenuPausa() {
        this.getMenuPausa().setMostrar(true);
        this.getMenuPausa().dibujar(this.getContenedorGrafico(), this.imagenBuffer);
    }

    public void ocultarMenuPausa() {
        this.getMenuPausa().setMostrar(false);
        this.limpiarImagenBuffer();
        this.representarTodo(this.getContenedorGrafico());
    }

    protected void actualizarPanel(Graphics contenedor, BufferedImage imagenBuffer) {
        this.getPanel().dibujar(contenedor, imagenBuffer);
    }

    protected void actualizarPanel(Graphics contenedor) {
        this.getPanel().dibujar(contenedor);
    }

    protected void dibujarImagenBuffer(Graphics contenedor, BufferedImage imagenBuffer) {
        MotorGrafico.dibujarImagenBuffer(contenedor, imagenBuffer);
    }

    protected void representarTodo(Graphics contenedor) {
        Graphics contenedorBackup = contenedor;
        contenedor = this.imagenBuffer.getGraphics();
        this.getTablero().dibujar(contenedor);
        if (this.piezaActual != null) {
            this.piezaActual.dibujar(contenedor);
        }
        this.actualizarPanel(contenedor);
        if (this.getMenuPrincipal().getMostrar()) {
            this.getMenuPrincipal().dibujar(contenedor);
        }
        if (this.getMenuPausa().getMostrar()) {
            this.getMenuPausa().dibujar(contenedor);
        }
        this.dibujarImagenBuffer(contenedorBackup, this.imagenBuffer);
    }
}

