/*
 * Decompiled with CFR 0.152.
 */
package logica;

import configuracion.Otros;
import gui.MotorGrafico;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import logica.Paleta;
import logica.Tablero;

public class Pieza {
    protected byte ancho = 0;
    protected byte alto = 0;
    protected byte left = 0;
    protected byte top = 0;
    protected int[][] forma = new int[this.alto][this.ancho];
    protected Paleta paleta;
    protected final int VACIO = Otros.getNumeroVacio();
    protected boolean desplazarPiezaSiNoCabeAlRotar;

    public Pieza(int[][] forma, Paleta paleta) {
        this(forma, paleta, 0, 0);
    }

    public Pieza(int[][] forma, Paleta paleta, byte left) {
        this(forma, paleta, left, (byte)(forma.length * -1));
    }

    public Pieza(int[][] forma, Paleta paleta, byte left, byte top) {
        this.setForma(forma);
        this.setPaleta(paleta);
        this.setLeft(left);
        this.setTop(top);
    }

    protected void setForma(int[][] forma) {
        this.forma = forma;
        this.setAncho(this.calcularAncho(this.getForma()));
        this.setAlto((byte)this.getForma().length);
        int[][] formaRectangular = new int[this.getAlto()][this.getAncho()];
        for (byte f = 0; f < this.getAlto(); f = (byte)(f + 1)) {
            for (byte c = 0; c < this.getAncho(); c = (byte)(c + 1)) {
                formaRectangular[f][c] = f < this.getForma().length && c < this.getForma()[f].length ? forma[f][c] : 0;
            }
        }
        this.forma = formaRectangular;
    }

    public int[][] getForma() {
        return this.forma;
    }

    protected void setPaleta(Paleta paleta) {
        this.paleta = paleta;
    }

    public Paleta getPaleta() {
        return this.paleta;
    }

    protected void setAncho(byte ancho) {
        this.ancho = ancho;
    }

    public byte getAncho() {
        return this.ancho;
    }

    public byte calcularAncho(int[][] forma) {
        byte ancho = (byte)forma[0].length;
        for (int f = 0; f < forma.length; f = (int)((byte)(f + 1))) {
            if (forma[f].length <= ancho) continue;
            ancho = (byte)forma[f].length;
        }
        return ancho;
    }

    protected void setAlto(byte alto) {
        this.alto = alto;
    }

    public byte getAlto() {
        return this.alto;
    }

    protected void setLeft(byte left) {
        this.left = left;
    }

    public byte getLeft() {
        return this.left;
    }

    protected void setTop(byte top) {
        this.top = top;
    }

    public byte getTop() {
        return this.top;
    }

    public void setDesplazarPiezaSiNoCabeAlRotar(boolean desplazarPiezaSiNoCabeAlRotar) {
        this.desplazarPiezaSiNoCabeAlRotar = desplazarPiezaSiNoCabeAlRotar;
    }

    public boolean getDesplazarPiezaSiNoCabeAlRotar() {
        return this.desplazarPiezaSiNoCabeAlRotar;
    }

    public void moverIzquierda(Tablero tablero) {
        this.mover(tablero, (byte)(this.getLeft() - 1), this.getTop());
    }

    public void moverDerecha(Tablero tablero) {
        this.mover(tablero, (byte)(this.getLeft() + 1), this.getTop());
    }

    public void moverAbajo(Tablero tablero) {
        this.mover(tablero, this.getLeft(), (byte)(this.getTop() + 1));
    }

    public void moverArriba(Tablero tablero) {
        this.mover(tablero, this.getLeft(), (byte)(this.getTop() - 1));
    }

    public void mover(Tablero tablero, byte left, byte top) {
        if (this.cabePieza(tablero, left, top)) {
            this.setLeft(left);
            this.setTop(top);
        }
    }

    protected boolean calcularColision(Tablero tablero) {
        boolean colision = false;
        if (!this.cabePieza(tablero)) {
            colision = true;
        } else if (!this.cabePieza(tablero, this.getLeft(), (byte)(this.getTop() + 1))) {
            colision = true;
        }
        return colision;
    }

    public void rotarIzquierda(Tablero tablero) {
        this.rotarIzquierda(tablero, this.getDesplazarPiezaSiNoCabeAlRotar());
    }

    public boolean rotarIzquierda(Tablero tablero, boolean desplazarPiezaSiNoCabeAlRotar) {
        boolean esIgual = true;
        if (this.getAncho() != this.getAlto()) {
            esIgual = false;
        }
        int[][] formaRotada = new int[this.getAncho()][this.getAlto()];
        for (byte f = 0; f < this.getAlto(); f = (byte)(f + 1)) {
            for (byte c = 0; c < this.getAncho(); c = (byte)(c + 1)) {
                byte fRotada = (byte)(this.getAncho() - c - 1);
                byte cRotada = f;
                formaRotada[fRotada][cRotada] = this.getForma()[f][c];
                if (!esIgual || formaRotada[fRotada][cRotada] == this.getForma()[f][c]) continue;
                esIgual = false;
            }
        }
        Pieza piezaRotada = new Pieza(formaRotada, this.getPaleta(), this.getLeft(), this.getTop());
        if (!this.cabePieza(piezaRotada, tablero) && desplazarPiezaSiNoCabeAlRotar) {
            if (piezaRotada.getTop() > piezaRotada.getLeft()) {
                piezaRotada.desplazarIzquierdaArriba(tablero);
            } else {
                piezaRotada.desplazarDerechaArriba(tablero);
            }
        }
        boolean piezaCabida = false;
        if (this.cabePieza(piezaRotada, tablero)) {
            piezaCabida = true;
            this.setForma(formaRotada);
            this.setLeft(piezaRotada.getLeft());
            this.setTop(piezaRotada.getTop());
        }
        return !esIgual && piezaCabida;
    }

    public void rotarDerecha(Tablero tablero) {
        this.rotarDerecha(tablero, this.getDesplazarPiezaSiNoCabeAlRotar());
    }

    public boolean rotarDerecha(Tablero tablero, boolean desplazarPiezaSiNoCabeAlRotar) {
        boolean esIgual = true;
        if (this.getAncho() != this.getAlto()) {
            esIgual = false;
        }
        int[][] formaRotada = new int[this.getAncho()][this.getAlto()];
        for (byte f = 0; f < this.getAlto(); f = (byte)(f + 1)) {
            for (byte c = 0; c < this.getAncho(); c = (byte)(c + 1)) {
                byte fRotada = c;
                byte cRotada = (byte)(this.getAlto() - f - 1);
                formaRotada[fRotada][cRotada] = this.getForma()[f][c];
                if (!esIgual || formaRotada[fRotada][cRotada] == this.getForma()[f][c]) continue;
                esIgual = false;
            }
        }
        Pieza piezaRotada = new Pieza(formaRotada, this.getPaleta(), this.getLeft(), this.getTop());
        if (!this.cabePieza(piezaRotada, tablero) && desplazarPiezaSiNoCabeAlRotar) {
            if (piezaRotada.getTop() > piezaRotada.getLeft()) {
                piezaRotada.desplazarDerechaArriba(tablero);
            } else {
                piezaRotada.desplazarIzquierdaArriba(tablero);
            }
        }
        boolean piezaCabida = false;
        if (this.cabePieza(piezaRotada, tablero)) {
            piezaCabida = true;
            this.setForma(formaRotada);
            this.setLeft(piezaRotada.getLeft());
            this.setTop(piezaRotada.getTop());
        }
        return !esIgual && piezaCabida;
    }

    protected void desplazarIzquierdaArriba(Tablero tablero) {
        this.desplazarIzquierdaArriba(this, tablero);
    }

    protected void desplazarIzquierdaArriba(Pieza pieza, Tablero tablero) {
        if (!this.cabePieza(pieza, tablero)) {
            byte leftInicial = pieza.getLeft();
            byte topInicial = pieza.getTop();
            byte leftOptimo = -1;
            byte topOptimo = -1;
            int intentosRealizadosX = -1;
            int intentosMaximoX = pieza.getAncho() / 2;
            int intentosMaximoY = pieza.getAlto() / 4;
            int intentosRealizadosMinimo = intentosMaximoX + intentosMaximoY;
            while (!this.cabePieza(pieza, tablero) && ++intentosRealizadosX <= intentosMaximoX && pieza.getLeft() - 1 >= 0) {
                pieza.setLeft((byte)(pieza.getLeft() - 1));
                if (this.cabePieza(pieza, tablero)) continue;
                int intentosRealizadosY = -1;
                while (!this.cabePieza(pieza, tablero) && ++intentosRealizadosY <= intentosMaximoY && pieza.getTop() - 1 >= 0) {
                    pieza.setTop((byte)(pieza.getTop() - 1));
                }
                if (!this.cabePieza(pieza, tablero)) {
                    pieza.setTop(topInicial);
                    continue;
                }
                if (intentosRealizadosX + intentosRealizadosY > intentosRealizadosMinimo) continue;
                leftOptimo = pieza.getLeft();
                topOptimo = pieza.getTop();
            }
            if (leftOptimo != -1 && topOptimo != -1) {
                pieza.setLeft(leftOptimo);
                pieza.setTop(topOptimo);
            }
        }
    }

    protected void desplazarDerechaArriba(Tablero tablero) {
        this.desplazarDerechaArriba(this, tablero);
    }

    protected void desplazarDerechaArriba(Pieza pieza, Tablero tablero) {
        if (!this.cabePieza(pieza, tablero)) {
            byte leftInicial = pieza.getLeft();
            byte topInicial = pieza.getTop();
            byte leftOptimo = -1;
            byte topOptimo = -1;
            int intentosRealizadosX = -1;
            int intentosMaximoX = pieza.getAncho() / 2;
            int intentosMaximoY = pieza.getAlto() / 4;
            int intentosRealizadosMinimo = intentosMaximoX + intentosMaximoY;
            while (!this.cabePieza(pieza, tablero) && intentosRealizadosX++ < intentosMaximoX && pieza.getLeft() + pieza.getAncho() + 1 < tablero.getAncho()) {
                pieza.setLeft((byte)(pieza.getLeft() + 1));
                if (this.cabePieza(pieza, tablero)) continue;
                int intentosRealizadosY = -1;
                while (!this.cabePieza(pieza, tablero) && intentosRealizadosY++ < intentosMaximoY && pieza.getTop() - 1 >= 0) {
                    pieza.setTop((byte)(pieza.getTop() - 1));
                }
                if (!this.cabePieza(pieza, tablero)) {
                    pieza.setTop(topInicial);
                    continue;
                }
                if (intentosRealizadosX + intentosRealizadosY > intentosRealizadosMinimo) continue;
                leftOptimo = pieza.getLeft();
                topOptimo = pieza.getTop();
            }
            if (leftOptimo != -1 && topOptimo != -1) {
                pieza.setLeft(leftOptimo);
                pieza.setTop(topOptimo);
            }
        }
    }

    public boolean cabePieza(Pieza pieza, Tablero tablero) {
        return this.cabePieza(pieza, tablero, pieza.getLeft(), pieza.getTop());
    }

    public boolean cabePieza(Tablero tablero) {
        return this.cabePieza(this, tablero, this.getLeft(), this.getTop());
    }

    public boolean cabePieza(Tablero tablero, byte left, byte top) {
        return this.cabePieza(this, tablero, left, top);
    }

    public boolean cabePieza(Pieza pieza, Tablero tablero, byte left, byte top) {
        boolean cabe = true;
        int fPieza = 0;
        byte f = top;
        while (f < top + pieza.getAlto()) {
            int cPieza = 0;
            byte c = left;
            while (c < left + pieza.getAncho()) {
                if (pieza.getForma()[fPieza][cPieza] != pieza.VACIO) {
                    if (f >= tablero.getAlto()) {
                        cabe = false;
                    } else if (c < 0) {
                        cabe = false;
                    } else if (c >= tablero.getAncho()) {
                        cabe = false;
                    } else if (f >= 0 && c >= 0 && tablero.getMapa()[f][c] != tablero.VACIO) {
                        cabe = false;
                    }
                }
                if (!cabe) break;
                c = (byte)(c + 1);
                cPieza = (byte)(cPieza + 1);
            }
            if (!cabe) break;
            f = (byte)(f + 1);
            fPieza = (byte)(fPieza + 1);
        }
        return cabe;
    }

    public void dibujar(Graphics contenedor, BufferedImage imagenBuffer) {
        this.dibujar(imagenBuffer.getGraphics());
        contenedor.drawImage(imagenBuffer, 0, 0, null);
    }

    public void dibujar(Graphics contenedor) {
        MotorGrafico.dibujarPieza(contenedor, this);
    }

    public String toString() {
        String cadena = "\n";
        for (byte f = 0; f < this.getAlto(); f = (byte)(f + 1)) {
            for (byte c = 0; c < this.getAncho(); c = (byte)(c + 1)) {
                cadena = cadena + this.getForma()[f][c] + "   ";
            }
            cadena = cadena + "\n";
        }
        return cadena;
    }
}

