/*
 * Decompiled with CFR 0.152.
 */
package logica;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.Hashtable;
import principal.Main;

public class Teclado
implements KeyListener {
    protected static Hashtable<Integer, Boolean> teclasPulsadas = new Hashtable();
    protected static long ultimaLecturaTeclado = 0L;

    public static void vaciarTeclas() {
        teclasPulsadas.clear();
    }

    public static synchronized void leerTeclado(boolean limitadorTiempo) {
        if (Main.juego == null) {
            return;
        }
        if (limitadorTiempo) {
            long tiempoNecesario = Main.juego.getVelocidadLectorTeclado();
            long tiempoActual = System.currentTimeMillis();
            long tiempoTranscurrido = tiempoActual - ultimaLecturaTeclado;
            if (tiempoTranscurrido < tiempoNecesario) {
                return;
            }
        }
        Enumeration<Integer> teclas = teclasPulsadas.keys();
        while (teclas.hasMoreElements()) {
            int tecla = teclas.nextElement();
            boolean pulsada = teclasPulsadas.get(tecla);
            if (!pulsada || !Main.juego.teclaEnTeclasTodas(tecla)) continue;
            Main.juego.procesarTecla(tecla);
        }
        ultimaLecturaTeclado = System.currentTimeMillis();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int tecla;
        if (Main.juego != null && Main.juego.teclaEnTeclasTodas(tecla = e.getKeyCode())) {
            teclasPulsadas.put(tecla, true);
            int[] teclasIzquierda = Main.juego.getTeclaIzquierda();
            int[] teclasDerecha = Main.juego.getTeclaDerecha();
            int[] teclasArriba = Main.juego.getTeclaArriba();
            int[] teclasAbajo = Main.juego.getTeclaAbajo();
            if (Main.juego.teclaEnTeclas(tecla, teclasIzquierda)) {
                for (int x = 0; x < teclasDerecha.length; ++x) {
                    teclasPulsadas.put(teclasDerecha[x], false);
                }
            } else if (Main.juego.teclaEnTeclas(tecla, teclasDerecha)) {
                for (int x = 0; x < teclasIzquierda.length; ++x) {
                    teclasPulsadas.put(teclasIzquierda[x], false);
                }
            } else if (Main.juego.teclaEnTeclas(tecla, teclasArriba)) {
                for (int x = 0; x < teclasAbajo.length; ++x) {
                    teclasPulsadas.put(teclasAbajo[x], false);
                }
            } else if (Main.juego.teclaEnTeclas(tecla, teclasAbajo)) {
                for (int x = 0; x < teclasArriba.length; ++x) {
                    teclasPulsadas.put(teclasArriba[x], false);
                }
            }
            Teclado.leerTeclado(false);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (Main.juego != null && Main.juego.teclaEnTeclasTodas(e.getKeyCode())) {
            teclasPulsadas.put(e.getKeyCode(), false);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

