/*
 * Decompiled with CFR 0.152.
 */
package principal;

import configuracion.Aspecto;
import configuracion.Idiomas;
import configuracion.Otros;
import gui.MotorGrafico;
import gui.TetrisApplet;
import gui.TetrisForm;
import java.awt.Graphics;
import logica.Juego;
import logica.Paleta;
import logica.Pieza;

public class Main {
    public static Juego juego = null;
    public static TetrisForm ventanaPrincipal;
    public static TetrisApplet appletPrincipal;
    protected static int idiomaActual;

    public static void main(String[] args) {
        if (appletPrincipal == null) {
            Otros.setTipoPrograma((byte)0);
        }
        if (Otros.getTipoPrograma() == 0) {
            ventanaPrincipal = new TetrisForm();
            Main.mostrarVentana();
            juego = new Juego(ventanaPrincipal.getPanelJuego());
        } else if (Otros.getTipoPrograma() == 1) {
            juego = new Juego(appletPrincipal.getPanelJuego());
        }
        Main.iniciarJuego();
        Main.redimensionarVentana();
        juego.mostrarMenuPrincipal();
    }

    public static int getIdiomaActual() {
        return idiomaActual;
    }

    protected static void mostrarVentana() {
        TetrisForm.main(null);
    }

    public static void redimensionarVentana() {
        int ancho = 640;
        int alto = 480;
        if (juego != null) {
            ancho = (juego.getPanel().getLeft() + juego.getPanel().getAncho()) * MotorGrafico.getCeldaAncho();
            alto = juego.getTablero().getAlto() * MotorGrafico.getCeldaAlto();
        }
        byte margenHorizontal = Aspecto.getMargenHorizontal();
        byte margenVertical = Aspecto.getMargenVertical();
        if (Otros.getTipoPrograma() == 0) {
            ventanaPrincipal.setSize(ancho + margenHorizontal, alto + margenVertical);
        } else if (Otros.getTipoPrograma() == 1) {
            appletPrincipal.setSize(ancho + margenHorizontal, alto + margenVertical);
        }
        if (juego != null) {
            juego.redimensionarImagenBuffer();
        }
    }

    public static void iniciarJuego() {
        Main.redimensionarVentana();
        if (juego == null) {
            return;
        }
        juego.iniciarJuego();
    }

    public static void finalizarJuego() {
        if (juego == null) {
            return;
        }
        juego.finalizarJuego();
    }

    public static void reiniciarJuego() {
        if (juego == null) {
            return;
        }
        juego.reiniciarJuego();
    }

    public static void pausarJuego() {
        if (juego == null) {
            return;
        }
        juego.pausarJuego();
    }

    public static void reanudarJuego() {
        if (juego == null) {
            return;
        }
        juego.reanudarJuego();
    }

    public static void cambiarContenedorGraficoJuego(Graphics contenedor) {
        if (juego == null) {
            return;
        }
        juego.setContenedorGrafico(contenedor);
    }

    public static void cambiarPaletaJuego(Paleta paleta) {
        if (juego == null) {
            return;
        }
        juego.setPaleta(paleta);
    }

    public static void cambiarPiezasBaseJuego(Pieza[] piezasBase) {
        if (juego == null) {
            return;
        }
        juego.setPiezasBase(piezasBase);
    }

    public static void cambiarTeclasJuego(int[] teclaArriba, int[] teclaAbajo, int[] teclaDerecha, int[] teclaIzquierda, int[] teclaRotarDerecha, int[] teclaRotarIzquierda, int[] teclaAceptar, int[] teclaPausa, int[] teclaSalir) {
        if (juego == null) {
            return;
        }
        juego.definirTeclas(teclaArriba, teclaAbajo, teclaDerecha, teclaIzquierda, teclaRotarDerecha, teclaRotarIzquierda, teclaAceptar, teclaPausa, teclaSalir);
    }

    public static void procesarTecla(int codigoTecla) {
        if (juego == null) {
            return;
        }
        juego.procesarTecla(codigoTecla);
    }

    public static void cambiarIdiomaActual(int idioma) {
        if (idioma >= 0 && idioma < Idiomas.idiomas.length) {
            idiomaActual = idioma;
        }
    }

    public static void desactivarSonido() {
        if (juego == null) {
            return;
        }
        juego.desactivarSonido();
    }

    public static void activarSonido() {
        if (juego == null) {
            return;
        }
        juego.activarSonido();
    }

    public static void alternarSonido() {
        if (juego == null) {
            return;
        }
        juego.alternarSonido();
    }

    static {
        idiomaActual = 2;
    }
}

