/*
 * Decompiled with CFR 0.152.
 */
package sonido;

import configuracion.Otros;
import java.applet.Applet;
import java.applet.AudioClip;
import java.net.URL;
import java.util.Hashtable;
import sonido.ThreadSonido;

public class MotorSonido {
    protected static String directorioSonido = Otros.getDirectorioSonido();
    protected static String sonidoPiezaColisionada = "colision.wav";
    protected static String sonidoPiezaRotada = "rotar.wav";
    protected static String sonidoLineaHecha = "linea.wav";
    protected static Hashtable<String, AudioClip> sonidos = new Hashtable();
    protected static boolean sonidosCargados = false;

    private MotorSonido() {
    }

    public static void setDirectorioSonido(String directorioSonido) {
        MotorSonido.directorioSonido = directorioSonido;
    }

    public static String getDirectorioSonido() {
        return directorioSonido;
    }

    public static void setSonidoPiezaColisionada(String sonidoPiezaColisionada) {
        MotorSonido.sonidoPiezaColisionada = sonidoPiezaColisionada;
    }

    public static String getSonidoPiezaColisionada() {
        return sonidoPiezaColisionada;
    }

    public static void setSonidoPiezaRotada(String sonidoPiezaRotada) {
        MotorSonido.sonidoPiezaRotada = sonidoPiezaRotada;
    }

    public static String getSonidoPiezaRotada() {
        return sonidoPiezaRotada;
    }

    public static String getSonidoLineaHecha() {
        return sonidoLineaHecha;
    }

    public static void cargarSonidos() {
        sonidos.put(MotorSonido.getSonidoPiezaColisionada(), MotorSonido.getSonido(MotorSonido.getSonidoPiezaColisionada()));
        sonidos.put(MotorSonido.getSonidoPiezaRotada(), MotorSonido.getSonido(MotorSonido.getSonidoPiezaRotada()));
        sonidos.put(MotorSonido.getSonidoLineaHecha(), MotorSonido.getSonido(MotorSonido.getSonidoLineaHecha()));
        sonidosCargados = true;
    }

    public static AudioClip getSonido(String archivo) {
        AudioClip sonido = null;
        ClassLoader classLoader = MotorSonido.class.getClassLoader();
        URL sonidoURL = classLoader.getResource(MotorSonido.getDirectorioSonido() + archivo);
        if (sonidoURL != null) {
            sonido = Applet.newAudioClip(sonidoURL);
        }
        return sonido;
    }

    public static AudioClip reproducirSonido(String archivo) {
        AudioClip sonido = MotorSonido.getSonido(archivo);
        if (sonido != null) {
            return MotorSonido.reproducirSonido(sonido);
        }
        System.out.println("Imposible cargar el archivo de audio " + archivo);
        return null;
    }

    public static AudioClip reproducirSonido(AudioClip sonido) {
        return MotorSonido.reproducirSonido(sonido, false);
    }

    public static AudioClip reproducirSonido(AudioClip sonido, boolean loop) {
        if (loop) {
            sonido.loop();
        }
        sonido.play();
        return sonido;
    }

    public static void pararSonido(AudioClip sonido) {
        sonido.stop();
    }

    public static AudioClip piezaColisionada() {
        AudioClip sonido;
        if (!sonidosCargados) {
            MotorSonido.cargarSonidos();
        }
        if ((sonido = sonidos.get(MotorSonido.getSonidoPiezaColisionada())) != null) {
            ThreadSonido nuevoHilo = new ThreadSonido(sonido);
            nuevoHilo.start();
        }
        return sonido;
    }

    public static AudioClip piezaRotada() {
        AudioClip sonido;
        if (!sonidosCargados) {
            MotorSonido.cargarSonidos();
        }
        if ((sonido = sonidos.get(MotorSonido.getSonidoPiezaRotada())) != null) {
            ThreadSonido nuevoHilo = new ThreadSonido(sonido);
            nuevoHilo.start();
        }
        return sonido;
    }

    public static AudioClip lineaHecha() {
        AudioClip sonido;
        if (!sonidosCargados) {
            MotorSonido.cargarSonidos();
        }
        if ((sonido = sonidos.get(MotorSonido.getSonidoLineaHecha())) != null) {
            ThreadSonido nuevoHilo = new ThreadSonido(sonido);
            nuevoHilo.start();
        }
        return sonido;
    }
}

