/*
 * Decompiled with CFR 0.152.
 */
package logica;

import configuracion.Otros;
import gui.MotorGrafico;
import java.awt.Graphics;
import javax.swing.JPanel;
import logica.Paleta;
import logica.Tablero;

public class Pieza {
    protected byte ancho = 0;
    protected byte alto = 0;
    protected byte left = 0;
    protected byte top = 0;
    protected int[][] forma = new int[this.alto][this.ancho];
    protected Paleta paleta;
    protected final int VACIO = Otros.getNumeroVacio();

    public Pieza(int[][] forma, Paleta paleta) {
        this(forma, paleta, 0, 0);
    }

    public Pieza(int[][] forma, Paleta paleta, byte left) {
        this(forma, paleta, left, (byte)(forma.length * -1));
    }

    public Pieza(int[][] forma, Paleta paleta, byte left, byte top) {
        this.setForma(forma);
        this.setPaleta(paleta);
        this.setLeft(left);
        this.setTop(top);
    }

    protected void setForma(int[][] forma) {
        this.forma = forma;
        this.setAncho(this.calcularAncho(this.getForma()));
        this.setAlto((byte)this.getForma().length);
        int[][] formaRectangular = new int[this.getAlto()][this.getAncho()];
        for (byte f = 0; f < this.getAlto(); f = (byte)(f + 1)) {
            for (byte c = 0; c < this.getAncho(); c = (byte)(c + 1)) {
                formaRectangular[f][c] = f < this.getForma().length && c < this.getForma()[f].length ? forma[f][c] : 0;
            }
        }
        this.forma = formaRectangular;
    }

    public int[][] getForma() {
        return this.forma;
    }

    protected void setPaleta(Paleta paleta) {
        this.paleta = paleta;
    }

    public Paleta getPaleta() {
        return this.paleta;
    }

    protected void setAncho(byte ancho) {
        this.ancho = ancho;
    }

    public byte getAncho() {
        return this.ancho;
    }

    public byte calcularAncho(int[][] forma) {
        byte ancho = (byte)forma[0].length;
        for (int f = 0; f < forma.length; f = (int)((byte)(f + 1))) {
            if (forma[f].length <= ancho) continue;
            ancho = (byte)forma[f].length;
        }
        return ancho;
    }

    protected void setAlto(byte alto) {
        this.alto = alto;
    }

    public byte getAlto() {
        return this.alto;
    }

    protected void setLeft(byte left) {
        this.left = left;
    }

    public byte getLeft() {
        return this.left;
    }

    protected void setTop(byte top) {
        this.top = top;
    }

    public byte getTop() {
        return this.top;
    }

    public void moverIzquierda(Tablero tablero) {
        this.mover(tablero, (byte)(this.getLeft() - 1), this.getTop());
    }

    public void moverDerecha(Tablero tablero) {
        this.mover(tablero, (byte)(this.getLeft() + 1), this.getTop());
    }

    public void moverAbajo(Tablero tablero) {
        this.mover(tablero, this.getLeft(), (byte)(this.getTop() + 1));
    }

    public void mover(Tablero tablero, byte left, byte top) {
        if (this.cabePieza(tablero, left, top)) {
            this.setLeft(left);
            this.setTop(top);
        }
    }

    protected boolean calcularColision(Tablero tablero) {
        boolean colision = false;
        if (!this.cabePieza(tablero)) {
            colision = true;
        } else if (!this.cabePieza(tablero, this.getLeft(), (byte)(this.getTop() + 1))) {
            colision = true;
        } else if (this.getTop() + this.getAlto() >= tablero.getAlto()) {
            colision = true;
        }
        return colision;
    }

    public void rotarIzquierda(Tablero tablero) {
        int[][] formaRotada = new int[this.getAncho()][this.getAlto()];
        for (byte f = 0; f < this.getAlto(); f = (byte)(f + 1)) {
            for (byte c = 0; c < this.getAncho(); c = (byte)(c + 1)) {
                byte fRotada = (byte)(this.getAncho() - c - 1);
                byte cRotada = f;
                formaRotada[fRotada][cRotada] = this.getForma()[f][c];
            }
        }
        Pieza piezaRotada = new Pieza(formaRotada, this.getPaleta(), this.getLeft(), this.getTop());
        if (this.cabePieza(piezaRotada, tablero)) {
            this.setForma(formaRotada);
        }
    }

    public void rotarDerecha(Tablero tablero) {
        int[][] formaRotada = new int[this.getAncho()][this.getAlto()];
        for (byte f = 0; f < this.getAlto(); f = (byte)(f + 1)) {
            for (byte c = 0; c < this.getAncho(); c = (byte)(c + 1)) {
                byte fRotada = c;
                byte cRotada = (byte)(this.getAlto() - f - 1);
                formaRotada[fRotada][cRotada] = this.getForma()[f][c];
            }
        }
        Pieza piezaRotada = new Pieza(formaRotada, this.getPaleta(), this.getLeft(), this.getTop());
        if (this.cabePieza(piezaRotada, tablero)) {
            this.setForma(formaRotada);
        }
    }

    public boolean cabePieza(Pieza pieza, Tablero tablero) {
        return this.cabePieza(pieza, tablero, this.getLeft(), this.getTop());
    }

    public boolean cabePieza(Tablero tablero) {
        return this.cabePieza(this, tablero, this.getLeft(), this.getTop());
    }

    public boolean cabePieza(Tablero tablero, byte left, byte top) {
        return this.cabePieza(this, tablero, left, top);
    }

    public boolean cabePieza(Pieza pieza, Tablero tablero, byte left, byte top) {
        boolean cabe = true;
        int fPieza = 0;
        byte f = top;
        while (f < top + pieza.getAlto()) {
            int cPieza = 0;
            byte c = left;
            while (c < left + pieza.getAncho()) {
                if (pieza.getForma()[fPieza][cPieza] != pieza.VACIO) {
                    if (f >= 0) {
                        if (f >= tablero.getAlto()) {
                            cabe = false;
                        } else if (c < 0) {
                            cabe = false;
                        } else if (c >= tablero.getAncho()) {
                            cabe = false;
                        } else if (tablero.getMapa()[f][c] != tablero.VACIO) {
                            cabe = false;
                        }
                    }
                    if (!cabe) break;
                }
                c = (byte)(c + 1);
                cPieza = (byte)(cPieza + 1);
            }
            if (!cabe) break;
            f = (byte)(f + 1);
            fPieza = (byte)(fPieza + 1);
        }
        return cabe;
    }

    public void dibujar(JPanel contenedor) {
        Graphics g = contenedor.getGraphics();
        MotorGrafico.dibujarPieza(g, this);
    }
}

