/*
 * Decompiled with CFR 0.152.
 */
package logica;

import configuracion.Menus;
import configuracion.Otros;
import configuracion.PaletaColores;
import configuracion.Piezas;
import configuracion.Teclas;
import java.awt.event.KeyEvent;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;
import logica.Menu;
import logica.Paleta;
import logica.Panel;
import logica.Pieza;
import logica.Sonido;
import logica.Tablero;
import logica.TimerJuego;
import principal.Main;

public class Juego {
    protected int[] teclaArriba = Teclas.getTeclaArriba();
    protected int[] teclaAbajo = Teclas.getTeclaAbajo();
    protected int[] teclaDerecha = Teclas.getTeclaDerecha();
    protected int[] teclaIzquierda = Teclas.getTeclaIzquierda();
    protected int[] teclaRotarDerecha = Teclas.getTeclaRotarDerecha();
    protected int[] teclaRotarIzquierda = Teclas.getTeclaRotarIzquierda();
    protected int[] teclaAceptar = Teclas.getTeclaAceptar();
    Timer timerJuego = null;
    protected JPanel contenedorGrafico;
    protected Sonido motorSonido = new Sonido();
    protected boolean sonidoActivado = Otros.getSonidoActivado();
    protected Panel panel = null;
    protected Menu menuPrincipal = null;
    protected Paleta paleta;
    protected Pieza[] piezasBase;
    protected int velocidad = Otros.getVelocidadInicial();
    protected final int velocidadMinima = Otros.getVelocidadMinima();
    protected final int velocidadMaxima = Otros.getVelocidadMaxima();
    protected final int incrementoVelocidad = Otros.getIncrementoVelocidad();
    protected boolean juegoComenzado = false;
    protected boolean juegoPausado = false;
    protected int nivel;
    protected int puntos;
    protected int lineas;
    protected int lineasNivel;
    protected final int lineasNecesariasNivel = Otros.getLineasNecesariasNivel();
    protected Tablero tablero;
    protected Pieza piezaActual;
    protected Pieza piezaSiguiente;
    protected boolean piezaColisionada;

    public Juego(JPanel contenedor) {
        this(contenedor, null, null);
    }

    public Juego(JPanel contenedor, Paleta paleta) {
        this(contenedor, paleta, null);
    }

    public Juego(JPanel contenedor, Paleta paleta, Pieza[] piezasBase) {
        this.setContenedorGrafico(contenedor);
        if (paleta == null) {
            paleta = PaletaColores.getPaleta();
        }
        this.setPaleta(paleta);
        if (piezasBase == null) {
            piezasBase = Piezas.getPiezas(this.getPaleta());
        }
        this.setPiezasBase(piezasBase);
        byte alto = Otros.getTableroAlto();
        byte ancho = Otros.getTableroAncho();
        this.tablero = new Tablero(ancho, alto, this.getPaleta());
        this.panel = new Panel(this.getPiezasBase(), this.getPaleta(), this.getTablero());
        this.menuPrincipal = Menus.getMenuPrincipal();
        this.menuPrincipal.setPaleta(this.getPaleta());
    }

    public void setContenedorGrafico(JPanel contenedor) {
        this.contenedorGrafico = contenedor;
    }

    public JPanel getContenedorGrafico() {
        return this.contenedorGrafico;
    }

    public void setPaleta(Paleta paleta) {
        this.paleta = paleta;
        if (this.getPanel() != null) {
            this.panel.setPaleta(paleta);
        }
        if (this.getMenuPrincipal() != null) {
            this.menuPrincipal.setPaleta(paleta);
        }
    }

    public Paleta getPaleta() {
        return this.paleta;
    }

    public Panel getPanel() {
        return this.panel;
    }

    public Menu getMenuPrincipal() {
        return this.menuPrincipal;
    }

    public Tablero getTablero() {
        return this.tablero;
    }

    public void setPiezasBase(Pieza[] piezasBase) {
        this.piezasBase = piezasBase;
        if (this.getPanel() != null) {
            this.panel.setPiezasBase(piezasBase);
        }
    }

    protected int numeroPiezasBase() {
        return this.getPiezasBase().length;
    }

    public Pieza[] getPiezasBase() {
        return this.piezasBase;
    }

    public void setSonidoActivado(boolean sonidoActivado) {
        this.sonidoActivado = sonidoActivado;
    }

    public boolean getSonidoActivado() {
        return this.sonidoActivado;
    }

    public void desactivarSonido() {
        this.setSonidoActivado(false);
    }

    public void activarSonido() {
        this.setSonidoActivado(true);
    }

    public void alternarSonido() {
        if (this.getSonidoActivado()) {
            this.desactivarSonido();
        } else {
            this.activarSonido();
        }
    }

    public void definirTeclas(int[] teclaArriba, int[] teclaAbajo, int[] teclaDerecha, int[] teclaIzquierda, int[] teclaRotarDerecha, int[] teclaRotarIzquierda, int[] teclaAceptar) {
        this.teclaArriba = teclaArriba;
        this.teclaAbajo = teclaAbajo;
        this.teclaDerecha = teclaDerecha;
        this.teclaIzquierda = teclaIzquierda;
        this.teclaRotarDerecha = teclaRotarDerecha;
        this.teclaRotarIzquierda = teclaRotarIzquierda;
        this.teclaAceptar = teclaAceptar;
    }

    public void modificarDimensionesTablero(byte ancho, byte alto) {
        this.getTablero().setAncho(ancho);
        this.getTablero().setAlto(alto);
        this.getPanel().setTablero(this.getTablero());
        Main.redimensionarVentana();
    }

    public void setVelocidad(int velocidad) {
        if (velocidad >= this.velocidadMinima && velocidad <= this.velocidadMaxima) {
            this.velocidad = velocidad;
        }
    }

    public int getVelocidad() {
        return this.velocidad;
    }

    protected void subirVelocidad() {
        this.setVelocidad(this.getVelocidad() + this.incrementoVelocidad);
        if (this.juegoComenzado) {
            this.timerJuego.cancel();
            this.timerJuego.purge();
            this.timerJuego = null;
            this.timerJuego = new Timer();
            TimerJuego tarea = new TimerJuego(this);
            this.timerJuego.scheduleAtFixedRate((TimerTask)tarea, 0L, (long)this.getVelocidad());
        }
    }

    public void setNivel(int nivel) {
        this.nivel = nivel;
        this.getPanel().setNivel(nivel);
    }

    public int getNivel() {
        return this.nivel;
    }

    protected void subirNivel() {
        this.setNivel(this.getNivel() + 1);
        this.subirVelocidad();
    }

    protected void setPuntos(int puntos) {
        this.puntos = puntos;
        this.getPanel().setPuntos(this.getPuntos());
    }

    public int getPuntos() {
        return this.puntos;
    }

    protected void sumarPuntos(int puntos) {
        this.setPuntos(this.getPuntos() + puntos);
    }

    protected void setLineas(int lineas) {
        if (lineas >= 0) {
            this.lineas = lineas;
            this.getPanel().setLineas(lineas);
        }
    }

    public int getLineas() {
        return this.lineas;
    }

    protected void setLineasNivel(int lineasNivel) {
        if (lineasNivel >= 0) {
            this.lineasNivel = lineasNivel;
            this.getPanel().setLineasNivel(lineasNivel);
        }
    }

    public int getLineasNivel() {
        return this.lineasNivel;
    }

    protected void sumarLineas(int numeroLineas) {
        if (numeroLineas > 0) {
            this.setLineas(this.getLineas() + numeroLineas);
        }
    }

    protected void sumarLineasNivel(int numeroLineas) {
        if (numeroLineas > 0) {
            this.setLineasNivel(this.getLineasNivel() + numeroLineas);
        }
    }

    public int leerTeclado(KeyEvent evento) {
        return 0;
    }

    public void procesarTecla(int tecla) {
        if (this.teclaEnTeclas(tecla, this.teclaAceptar) && this.getMenuPrincipal() != null && this.getMenuPrincipal().getMostrar()) {
            this.getMenuPrincipal().aceptarOpcionActual();
            this.procesarMenuPrincipal();
        }
        if (this.teclaEnTeclas(tecla, this.teclaArriba) && this.getMenuPrincipal() != null && this.getMenuPrincipal().getMostrar()) {
            this.getMenuPrincipal().subirOpcion();
            if (this.menuPrincipal.getMostrar()) {
                this.representarTodo(this.getContenedorGrafico());
            }
        }
        if (this.teclaEnTeclas(tecla, this.teclaAbajo)) {
            if (this.getJuegoComenzado() && this.piezaActual != null) {
                this.piezaActual.moverAbajo(this.getTablero());
            }
            if (this.getMenuPrincipal() != null && this.getMenuPrincipal().getMostrar()) {
                this.getMenuPrincipal().bajarOpcion();
                if (this.menuPrincipal.getMostrar()) {
                    this.representarTodo(this.getContenedorGrafico());
                }
            }
        }
        if (this.teclaEnTeclas(tecla, this.teclaDerecha) && this.getJuegoComenzado() && this.piezaActual != null) {
            this.piezaActual.moverDerecha(this.getTablero());
        }
        if (this.teclaEnTeclas(tecla, this.teclaIzquierda) && this.getJuegoComenzado() && this.piezaActual != null) {
            this.piezaActual.moverIzquierda(this.getTablero());
        }
        if (this.teclaEnTeclas(tecla, this.teclaRotarDerecha) && this.getJuegoComenzado() && this.piezaActual != null) {
            this.piezaActual.rotarDerecha(this.getTablero());
        }
        if (this.teclaEnTeclas(tecla, this.teclaRotarIzquierda) && this.getJuegoComenzado() && this.piezaActual != null) {
            this.piezaActual.rotarIzquierda(this.getTablero());
        }
    }

    protected void procesarMenuPrincipal() {
        if (this.getMenuPrincipal() != null && this.getMenuPrincipal().getMostrar() && this.getMenuPrincipal().getOpcionAceptada()) {
            String opcionSeleccionada = this.getMenuPrincipal().getOpcionActualValor();
            if (opcionSeleccionada.toUpperCase().equals("INICIAR")) {
                if (!this.getJuegoComenzado()) {
                    this.ocultarMenuPrincipal();
                    this.iniciarJuego();
                } else {
                    this.ocultarMenuPrincipal();
                    this.reiniciarJuego();
                }
            } else if (!opcionSeleccionada.toUpperCase().equals("OPCIONES") && !opcionSeleccionada.toUpperCase().equals("FINALIZAR")) {
                if (opcionSeleccionada.toUpperCase().equals("FINALIZAR_SI")) {
                    if (this.getMenuPrincipal().getOpcionAceptadaSubmenu()) {
                        if (this.getJuegoComenzado()) {
                            this.finalizarJuego();
                        }
                        System.exit(0);
                    }
                } else if (opcionSeleccionada.toUpperCase().equals("FINALIZAR_NO") && this.getMenuPrincipal().getOpcionAceptadaSubmenu()) {
                    this.getMenuPrincipal().cancelarOpcionActual();
                }
            }
        }
    }

    protected boolean teclaEnTeclas(int tecla, int[] teclas) {
        boolean encontrada = false;
        for (int x = 0; x < teclas.length; ++x) {
            if (teclas[x] != tecla) continue;
            encontrada = true;
            break;
        }
        return encontrada;
    }

    public boolean comprobarGameOver() {
        return true;
    }

    public boolean getJuegoComenzado() {
        return this.juegoComenzado;
    }

    public void restaurarValores() {
        this.getTablero().vaciar();
        this.piezaActual = null;
        this.piezaSiguiente = null;
        this.piezaColisionada = false;
        this.setNivel(0);
        this.setPuntos(0);
        this.setLineas(0);
        this.setLineasNivel(0);
    }

    public void iniciarJuego() {
        if (this.getJuegoComenzado()) {
            return;
        }
        this.juegoComenzado = true;
        this.restaurarValores();
        TimerJuego tarea = new TimerJuego(this);
        this.timerJuego = new Timer();
        this.timerJuego.scheduleAtFixedRate((TimerTask)tarea, 0L, (long)this.getVelocidad());
    }

    public void finalizarJuego() {
        if (!this.juegoComenzado) {
            return;
        }
        this.juegoComenzado = false;
        if (this.timerJuego != null) {
            this.timerJuego.cancel();
            this.timerJuego.purge();
            this.timerJuego = null;
        }
    }

    public void pausarJuego() {
        if (this.getJuegoComenzado()) {
            this.juegoPausado = true;
        }
    }

    public void reanudarJuego() {
        this.juegoPausado = false;
    }

    public void reiniciarJuego() {
        this.finalizarJuego();
        this.iniciarJuego();
    }

    protected Pieza obtenerPieza() {
        int indiceAleatorio = new Random().nextInt(this.getPiezasBase().length);
        return this.getPiezasBase()[indiceAleatorio];
    }

    protected void sacarPieza() {
        if (this.piezaSiguiente == null) {
            Pieza piezaAleatoria = this.obtenerPieza();
            int[][] piezaForma = piezaAleatoria.getForma();
            byte piezaAncho = piezaAleatoria.getAncho();
            byte piezaPosicionHorizontal = (byte)(this.getTablero().getAncho() / 2 - piezaAncho / 2);
            this.piezaActual = new Pieza(piezaForma, this.getPaleta(), piezaPosicionHorizontal);
            this.piezaSiguiente = this.obtenerPieza();
        } else {
            int[][] piezaForma = this.piezaSiguiente.getForma();
            byte piezaAncho = this.piezaSiguiente.getAncho();
            byte piezaPosicionHorizontal = (byte)(this.getTablero().getAncho() / 2 - piezaAncho / 2);
            this.piezaActual = new Pieza(piezaForma, this.getPaleta(), piezaPosicionHorizontal);
            this.piezaSiguiente = this.obtenerPieza();
        }
        this.getPanel().insertarPieza(this.piezaSiguiente);
        this.actualizarPanel(this.getContenedorGrafico());
    }

    protected void cicloJuego() {
        if (this.juegoPausado) {
            return;
        }
        if (!this.getJuegoComenzado()) {
            return;
        }
        if (this.piezaColisionada) {
            if (this.piezaActual.calcularColision(this.getTablero())) {
                this.sumarPuntos(Otros.getPuntosPorPiezaPuesta());
                this.piezaColisionada = false;
                this.getTablero().agregarPieza(this.piezaActual);
                this.piezaActual = null;
                this.getTablero().dibujar(this.getContenedorGrafico());
                byte lineasHechas = this.getTablero().procesarLineas();
                if (lineasHechas > 0) {
                    this.sumarLineas(lineasHechas);
                    this.sumarLineasNivel(lineasHechas);
                    this.sumarPuntos(lineasHechas * Otros.getPuntosPorLinea());
                    while (this.getLineasNivel() >= this.lineasNecesariasNivel) {
                        this.setLineasNivel(this.getLineasNivel() - this.lineasNecesariasNivel);
                        this.subirNivel();
                    }
                }
                if (this.getTablero().estaLleno()) {
                    this.reiniciarJuego();
                }
            } else {
                this.piezaColisionada = false;
            }
        }
        if (this.piezaActual == null) {
            this.sacarPieza();
        }
        this.representarTodo(this.getContenedorGrafico());
        if (this.piezaActual.calcularColision(this.getTablero())) {
            this.piezaColisionada = true;
        } else {
            this.piezaActual.moverAbajo(this.getTablero());
        }
    }

    public void mostrarMenuPrincipal() {
        this.menuPrincipal.setMostrar(true);
        this.menuPrincipal.dibujar(this.getContenedorGrafico());
    }

    public void ocultarMenuPrincipal() {
        this.menuPrincipal.setMostrar(false);
    }

    protected void actualizarPanel(JPanel contenedor) {
        this.getPanel().dibujar(contenedor);
    }

    protected void representarTodo(JPanel contenedor) {
        this.getTablero().dibujar(contenedor);
        if (this.piezaActual != null) {
            this.piezaActual.dibujar(contenedor);
        }
        this.actualizarPanel(contenedor);
        if (this.menuPrincipal.getMostrar()) {
            this.menuPrincipal.dibujar(contenedor);
        }
    }
}

