/*
 * Decompiled with CFR 0.152.
 */
package logica;

import java.awt.Graphics;
import logica.Paleta;
import logica.Tablero;

public class Pieza {
    protected byte ancho = 0;
    protected byte alto = 0;
    protected byte left = 0;
    protected byte top = 0;
    protected int[][] forma = new int[this.alto][this.ancho];
    protected Paleta paleta;
    private final int VACIO = 0;

    public Pieza(int[][] forma, Paleta paleta) {
        this.setForma(forma);
        this.setPaleta(paleta);
    }

    protected void setForma(int[][] forma) {
        this.forma = forma;
        this.setAncho((byte)this.getForma()[0].length);
        this.setAlto((byte)this.getForma().length);
    }

    public int[][] getForma() {
        return this.forma;
    }

    protected void setPaleta(Paleta paleta) {
        this.paleta = paleta;
    }

    protected Paleta getPaleta() {
        return this.paleta;
    }

    protected void setAncho(byte ancho) {
        this.ancho = ancho;
    }

    public byte getAncho() {
        return this.ancho;
    }

    protected void setAlto(byte alto) {
        this.alto = alto;
    }

    public byte getAlto() {
        return this.alto;
    }

    protected void setLeft(byte left) {
        this.left = left;
    }

    public byte getLeft() {
        return this.left;
    }

    protected void setTop(byte top) {
        this.top = top;
    }

    public byte getTop() {
        return this.top;
    }

    public void moverIzquierda() {
        this.setLeft((byte)(this.getLeft() - 1));
    }

    public void moverDerecha() {
        this.setLeft((byte)(this.getLeft() + 1));
    }

    public void moverAbajo() {
        this.setTop((byte)(this.getTop() + 1));
    }

    public void mover(byte left, byte top) {
        this.setLeft(left);
        this.setTop(top);
    }

    protected boolean calcularColision(Tablero tablero) {
        boolean colision = false;
        if (!this.cabePieza(tablero)) {
            colision = true;
        } else if (!this.cabePieza(tablero, this.getLeft(), (byte)(this.getTop() + 1))) {
            colision = true;
        } else if (this.getTop() + this.getAlto() >= tablero.getAlto()) {
            colision = true;
        }
        return colision;
    }

    public void rotarIzquierda() {
    }

    public void rotarDerecha() {
    }

    public boolean cabePieza(Tablero tablero) {
        return this.cabePieza(tablero, this.getLeft(), this.getTop());
    }

    public boolean cabePieza(Tablero tablero, byte left, byte top) {
        boolean cabe = true;
        int fPieza = 0;
        byte f = this.getTop();
        while (f < this.getTop() + this.getAlto()) {
            int cPieza = 0;
            byte c = this.getLeft();
            while (c < this.getLeft() + this.getAncho()) {
                if (this.getForma()[fPieza][cPieza] != this.VACIO) {
                    if (f < 0) {
                        cabe = false;
                    }
                    if (f >= tablero.getAlto()) {
                        cabe = false;
                    } else if (c < 0) {
                        cabe = false;
                    } else if (c >= tablero.getAncho()) {
                        cabe = false;
                    } else if (tablero.getMapa()[f][c] != tablero.VACIO) {
                        cabe = false;
                    }
                    if (!cabe) break;
                }
                c = (byte)(c + 1);
                cPieza = (byte)(cPieza + 1);
            }
            if (!cabe) break;
            f = (byte)(f + 1);
            fPieza = (byte)(fPieza + 1);
        }
        return cabe;
    }

    public void dibujar(Graphics contenedor) {
    }
}

