/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.EntersException;
import java.util.Calendar;

public class Data {
    private byte dia;
    private byte mes;
    private short any;

    public Data(byte dia, byte mes, short any) throws EntersException {
        this.setData(dia, mes, any);
    }

    public Data(int dia, int mes, int any) throws EntersException {
        this((byte)dia, (byte)mes, (short)any);
    }

    public Data(Data altraData) throws EntersException {
        this.copiarData(altraData);
    }

    public Data() throws EntersException {
        Calendar calendari = Calendar.getInstance();
        byte dia = (byte)calendari.get(5);
        byte mes = (byte)calendari.get(2);
        short any = (short)calendari.get(1);
        this.setData(dia, mes, any);
    }

    public void setData(byte dia, byte mes, short any) throws EntersException {
        this.setAny(any);
        this.setMes(mes);
        this.setDia(dia);
    }

    public byte getDia() {
        return this.dia;
    }

    public void setDia(byte dia) throws EntersException {
        if (!this.existeixDiaMesAny(dia, this.getMes(), this.getAny())) {
            throw new EntersException("El dia " + dia + " no existeix per al mes (" + this.getMes() + ") i any (" + this.getAny() + ") donats.");
        }
        this.dia = dia;
    }

    public byte getMes() {
        return this.mes;
    }

    public void setMes(byte mes) throws EntersException {
        if (mes < 0 || mes > 11) {
            throw new EntersException("El valor del mes ha de ser entre 0 i 11.");
        }
        this.mes = mes;
    }

    public short getAny() {
        return this.any;
    }

    public void setAny(short any) throws EntersException {
        if (this.mes < 0) {
            throw new EntersException("El valor de l'any no pot ser negatiu.");
        }
        this.any = any;
    }

    protected boolean existeixDiaMesAny(byte dia, byte mes, short any) {
        byte maxim = this.diesMes(dia, mes, any);
        return dia > 0 && dia <= maxim;
    }

    protected byte diesMes(byte dia, byte mes, short any) {
        byte[] dies = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        int maxim = dies[mes];
        if (mes == 1 && this.esBixest(any)) {
            maxim = 29;
        }
        return (byte)maxim;
    }

    protected boolean esBixest(short any) {
        return any % 4 == 0 && any % 100 != 0 || any % 400 == 0;
    }

    public void copiarData(Data altraData) throws EntersException {
        this.setData(altraData.getDia(), altraData.getMes(), altraData.getAny());
    }

    public String dataActual() {
        Calendar calendari = Calendar.getInstance();
        return this.lleigirData(calendari);
    }

    public String diaText(byte dia, byte mes, short any) {
        String[] dies = new String[]{"Diumenge", "Dilluns", "Dimarts", "Dimecres", "Dijous", "Divendres", "Dissabte"};
        Calendar calendari = Calendar.getInstance();
        calendari.set(any, mes, dia);
        return dies[calendari.get(7) - 1];
    }

    public String diaText(byte dia) {
        return this.diaText(dia, this.getMes(), this.getAny());
    }

    public String diaText() {
        Calendar calendari = Calendar.getInstance();
        byte dia = (byte)calendari.get(5);
        byte mes = (byte)calendari.get(2);
        short any = (short)calendari.get(1);
        return this.diaText(dia, mes, any);
    }

    public String mesText(byte mes) {
        String[] mesos = new String[]{"Gener", "Febrer", "Mar\u00e7", "Abril", "Maig", "Juny", "Juliol", "Agost", "Setembre", "Octubre", "Novembre", "Desembre"};
        return mesos[mes];
    }

    public boolean equals(Data altraData) {
        return this.getDia() == altraData.getDia() && this.getMes() == altraData.getMes() && this.getAny() == altraData.getAny();
    }

    public byte compara(Data altraData) {
        if (this.equals(altraData)) {
            return 0;
        }
        if (this.getAny() > altraData.getAny()) {
            return 1;
        }
        if (this.getAny() == altraData.getAny() && this.getMes() > altraData.getMes()) {
            return 1;
        }
        if (this.getAny() == altraData.getAny() && this.getMes() == altraData.getMes() && this.getDia() > this.getDia()) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        return this.getDia() + "-" + this.mesText(this.getMes()) + "-" + this.getAny();
    }

    public String escriure() {
        return this.diaText(this.getDia()) + " " + this.getDia() + " de " + this.mesText(this.getMes()) + " de " + this.getAny();
    }

    public String escriure(byte dia, byte mes, short any) {
        return this.diaText(dia, mes, any) + " " + dia + " de " + this.mesText(mes) + " de " + any;
    }

    public String escriure(Calendar calendari) {
        byte dia = (byte)calendari.get(5);
        byte mes = (byte)calendari.get(2);
        short any = (short)calendari.get(1);
        return this.diaText(dia, mes, any) + " " + dia + " de " + this.mesText(mes) + " de " + any;
    }

    public String anterior() {
        Calendar calendari = Calendar.getInstance();
        calendari.set(this.getAny(), this.getMes(), this.getDia());
        calendari.add(5, -1);
        return this.lleigirData(calendari);
    }

    public String seguent() {
        Calendar calendari = Calendar.getInstance();
        calendari.set(this.getAny(), this.getMes(), this.getDia());
        calendari.add(5, 1);
        return this.lleigirData(calendari);
    }

    public String lleigirData(Calendar calendari) {
        return this.escriure(calendari);
    }

    public String lleigirData(byte dia, byte mes, short any) {
        return this.escriure(dia, mes, any);
    }

    public String horoscop() {
        return this.horoscop(this.getDia(), this.getMes(), this.getAny());
    }

    public String horoscop(byte dia, byte mes, short any) {
        String[] signes = new String[]{"Acuari", "Peixos", "Aries", "Taure", "Geminis", "Cancer", "Leo", "Verge", "Lliura", "Escorpio", "Sagitari", "Capricorn"};
        short diaAny = this.diaDelAny(dia, mes, any);
        short index = (short)(diaAny / 12 - 1);
        return signes[index];
    }

    public short diaDelAny(byte dia, byte mes, short any) {
        short dies = 0;
        for (byte x = 0; x < mes; x = (byte)(x + 1)) {
            dies = (short)(dies + this.diesMes(dia, x, any));
        }
        dies = (short)(dies + dia);
        return dies;
    }
}

