/*
 * Decompiled with CFR 0.152.
 */
package bd_exercici;

import bd_exercici.Llibre;
import bd_exercici.Main;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class Finestra
extends JFrame {
    private JTextField AutorTextBox;
    private JTextField EditorialTextBox;
    private JTextField ISBNTextBox;
    private JButton InsertaButton;
    private JTextField PreuTextBox;
    private JTextField TitolTextBox;
    private JButton botoArxiu;
    private JButton cercaButton;
    private JButton esborraButton;
    private JFileChooser jFileChooser1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JButton modificaButton;

    public Finestra() {
        this.initComponents();
    }

    private void initComponents() {
        this.jFileChooser1 = new JFileChooser();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.ISBNTextBox = new JTextField();
        this.EditorialTextBox = new JTextField();
        this.AutorTextBox = new JTextField();
        this.TitolTextBox = new JTextField();
        this.PreuTextBox = new JTextField();
        this.cercaButton = new JButton();
        this.modificaButton = new JButton();
        this.InsertaButton = new JButton();
        this.esborraButton = new JButton();
        this.botoArxiu = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("Base de Dades Llibres");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Finestra.this.formWindowClosing(evt);
            }
        });
        this.jLabel1.setText("ISBN:");
        this.jLabel2.setText("Editorial:");
        this.jLabel3.setText("Autor:");
        this.jLabel4.setText("T\u00edtol:");
        this.jLabel5.setText("Preu:");
        this.ISBNTextBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                Finestra.this.ISBNTextBoxKeyTyped(evt);
            }
        });
        this.cercaButton.setText("Cerca");
        this.cercaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Finestra.this.cercaButtonActionPerformed(evt);
            }
        });
        this.modificaButton.setText("Modifica");
        this.modificaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Finestra.this.modificaButtonActionPerformed(evt);
            }
        });
        this.InsertaButton.setText("Inserta");
        this.InsertaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Finestra.this.InsertaButtonActionPerformed(evt);
            }
        });
        this.esborraButton.setText("Esborra");
        this.esborraButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Finestra.this.esborraButtonActionPerformed(evt);
            }
        });
        this.botoArxiu.setBackground(new Color(255, 204, 0));
        this.botoArxiu.setText("Arxiu...");
        this.botoArxiu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Finestra.this.botoArxiuActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.TitolTextBox, -1, 270, Short.MAX_VALUE).addComponent(this.AutorTextBox, -1, 270, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.ISBNTextBox, -1, 203, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cercaButton)).addComponent(this.PreuTextBox, -2, 48, -2).addComponent(this.EditorialTextBox, -1, 270, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.modificaButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.InsertaButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.esborraButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 28, Short.MAX_VALUE).addComponent(this.botoArxiu))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.cercaButton).addComponent(this.ISBNTextBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.EditorialTextBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.AutorTextBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.TitolTextBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.PreuTextBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.modificaButton).addComponent(this.InsertaButton).addComponent(this.esborraButton).addComponent(this.botoArxiu)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void botoArxiuActionPerformed(ActionEvent evt) {
        if (this.jFileChooser1.showOpenDialog(this) == 0) {
            String path = this.jFileChooser1.getSelectedFile().getAbsolutePath();
            boolean totBe = false;
            try {
                totBe = Main.BD.importa(path);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                totBe = false;
            }
            if (totBe) {
                JOptionPane.showMessageDialog(this, "Arxiu executat correctamente.");
            } else {
                JOptionPane.showMessageDialog(this, "L'arxiu ha donat error i no s'ha pogut executar.");
            }
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        Main.desconectaBD();
    }

    private void esborraButtonActionPerformed(ActionEvent evt) {
        String ISBN = this.ISBNTextBox.getText().trim();
        if (ISBN.equals("")) {
            JOptionPane.showMessageDialog(this, "No has ficat un ISBN!");
            return;
        }
        Llibre llibre = Main.agafaLlibre(ISBN);
        if (llibre != null) {
            try {
                Main.esborraLlibre(llibre);
                llibre = Main.agafaLlibre(ISBN);
                if (llibre == null) {
                    JOptionPane.showMessageDialog(this, "Llibre esborrat correctament.");
                }
            }
            catch (Exception e) {
                System.out.println("Excepcio: " + e.getMessage());
            }
        } else {
            JOptionPane.showMessageDialog(this, "El llibre no existeix! No es pot esborrar");
        }
    }

    private void InsertaButtonActionPerformed(ActionEvent evt) {
        String ISBN = this.ISBNTextBox.getText().trim();
        if (ISBN.equals("")) {
            JOptionPane.showMessageDialog(this, "No has ficat un ISBN!");
            return;
        }
        Llibre llibre = Main.agafaLlibre(ISBN);
        if (llibre == null) {
            String editorial = this.EditorialTextBox.getText();
            String autor = this.AutorTextBox.getText();
            String titol = this.TitolTextBox.getText();
            float preu = Float.parseFloat(this.PreuTextBox.getText());
            if (!(ISBN.equals("") || editorial.equals("") || autor.equals("") || titol.equals("") || !(preu >= 0.0f))) {
                try {
                    llibre = new Llibre(ISBN, titol, autor, editorial, preu);
                    Main.insereixLlibre(llibre);
                }
                catch (Exception e) {
                    System.out.println("Excepcio: " + e.getMessage());
                }
            } else {
                JOptionPane.showMessageDialog(this, "S'han d'omplir tots els camps i amb valors correctes!");
            }
        } else {
            JOptionPane.showMessageDialog(this, "El llibre ja existeix! Intenta modificar-lo");
        }
    }

    private void modificaButtonActionPerformed(ActionEvent evt) {
        String ISBN = this.ISBNTextBox.getText().trim();
        if (ISBN.equals("")) {
            JOptionPane.showMessageDialog(this, "No has ficat un ISBN!");
            return;
        }
        Llibre llibre = Main.agafaLlibre(ISBN);
        if (llibre != null) {
            String editorial = this.EditorialTextBox.getText().trim();
            String autor = this.AutorTextBox.getText().trim();
            String titol = this.TitolTextBox.getText().trim();
            float preu = Float.parseFloat(this.PreuTextBox.getText().trim());
            if (!(ISBN.equals("") || editorial.equals("") || autor.equals("") || titol.equals("") || !(preu >= 0.0f))) {
                try {
                    Main.modificaLlibre(llibre, ISBN, titol, autor, editorial, preu);
                }
                catch (Exception e) {
                    System.out.println("Excepcio: " + e.getMessage());
                }
            } else {
                JOptionPane.showMessageDialog(this, "S'han d'omplir tots els camps i amb valors correctes!");
            }
        } else {
            JOptionPane.showMessageDialog(this, "No existeix un llibre amb ISBN " + ISBN + ", intenta insertar-lo primer!");
        }
    }

    private void cercaButtonActionPerformed(ActionEvent evt) {
        String ISBN = this.ISBNTextBox.getText().trim();
        if (ISBN.equals("")) {
            JOptionPane.showMessageDialog(this, "No has ficat un ISBN!");
            return;
        }
        Llibre llibre = Main.agafaLlibre(ISBN);
        if (llibre != null) {
            this.carregaDades(ISBN);
        } else {
            JOptionPane.showMessageDialog(this, "No existeix un llibre amb ISBN " + ISBN);
        }
    }

    private void ISBNTextBoxKeyTyped(KeyEvent evt) {
        String ISBN = this.ISBNTextBox.getText().trim() + ("" + evt.getKeyChar()).trim();
        if (ISBN.equals("")) {
            this.buidaDades();
            return;
        }
        Llibre llibre = Main.agafaLlibre(ISBN);
        if (llibre != null) {
            this.carregaDades(llibre);
        }
    }

    public void carregaDades(String ISBN) {
        Llibre llibreCercat = Main.agafaLlibre(ISBN);
        if (llibreCercat != null) {
            this.carregaDades(llibreCercat);
        }
    }

    public void carregaDades(Llibre llibre) {
        if (llibre == null) {
            return;
        }
        String editorial = llibre.getEditorial();
        String autor = llibre.getAutor();
        String titol = llibre.getTitol();
        float preu = llibre.getPreu();
        this.EditorialTextBox.setText(editorial);
        this.AutorTextBox.setText(autor);
        this.TitolTextBox.setText(titol);
        this.PreuTextBox.setText("" + preu);
    }

    public void buidaDades() {
        this.EditorialTextBox.setText("");
        this.AutorTextBox.setText("");
        this.TitolTextBox.setText("");
        this.PreuTextBox.setText("");
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Main.finestra.setVisible(true);
            }
        });
    }
}

