/*
 * Decompiled with CFR 0.152.
 */
package bd_exercici;

import com.mysql.jdbc.Driver;
import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;

public class BD {
    protected String hostname;
    protected int port;
    protected String DBName;
    protected String login;
    protected String password;
    protected String URL;
    protected Connection conexio;
    protected boolean conectat = false;
    protected ResultSet resultats;
    protected tipusBD tipus = tipusBD.MYSQL;

    public BD(String tipus, String hostname, int port, String DBName, String login, String password) throws Exception {
        tipus = tipus.toUpperCase();
        if (tipus.equals("MYSQL")) {
            this.conectaGeneric(hostname, port, DBName, login, password);
        } else {
            this.conectaAccess(DBName, login, password);
        }
    }

    public BD(tipusBD tipus, String hostname, int port, String DBName, String login, String password) throws Exception {
        switch (tipus) {
            case MYSQL: {
                this.conectaGeneric(hostname, port, DBName, login, password);
                break;
            }
            default: {
                this.conectaAccess(DBName, login, password);
            }
        }
    }

    private void conectaGeneric(String hostname, int port, String DBName, String login, String password) throws Exception {
        this.tipus = tipusBD.MYSQL;
        this.setHostname(hostname);
        this.setPort(port);
        this.setDBName(DBName);
        this.setLogin(login);
        this.setPassword(password);
        this.setURL();
        this.conecta();
    }

    private void conectaAccess(String DBName, String login, String password) throws Exception {
        this.tipus = tipusBD.ACCESS;
        this.setHostname(this.hostname);
        this.setPort(this.port);
        this.setDBName(DBName);
        this.setLogin(login);
        this.setPassword(password);
        this.setURL();
        this.conecta();
    }

    public void setAutoComit(boolean autoComit) throws Exception {
        this.conexio.setAutoCommit(autoComit);
    }

    public boolean getAutoComit() throws Exception {
        return this.conexio.getAutoCommit();
    }

    public void commit() throws Exception {
        this.conexio.commit();
    }

    public void rollback() throws Exception {
        this.conexio.rollback();
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public float getPort() {
        return this.port;
    }

    public void setDBName(String DBName) {
        this.DBName = DBName;
    }

    public String getDBName() {
        return this.DBName;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getLogin() {
        return this.login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    protected void setURL() {
        this.URL = this.tipus == tipusBD.MYSQL ? "jdbc:mysql://" + this.getHostname() + ":" + (int)this.getPort() + "/" + this.getDBName() + "?user=" + this.getLogin() + "&password=" + this.getPassword() : "jdbc:odbc:BDllibres";
    }

    public String getURL() {
        return this.URL;
    }

    public void setConectat(boolean conectat) {
        this.conectat = conectat;
    }

    public boolean getConectat() {
        return this.conectat;
    }

    public void setResultats(ResultSet resultats) {
        this.resultats = resultats;
    }

    public ResultSet getResultats() {
        return this.resultats;
    }

    public boolean conecta() throws Exception {
        boolean conectat = false;
        if (!this.getConectat()) {
            if (this.tipus == tipusBD.MYSQL) {
                DriverManager.registerDriver((java.sql.Driver)new Driver());
            } else {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            }
            this.conexio = DriverManager.getConnection(this.getURL());
            if (this.conexio != null) {
                conectat = true;
                this.setConectat(conectat);
            }
        }
        return conectat;
    }

    public boolean desconecta() {
        boolean desconectat = false;
        if (this.getConectat()) {
            try {
                this.conexio.close();
                desconectat = true;
                this.setConectat(!desconectat);
            }
            catch (Exception e) {
                System.out.println("Excepcio: " + e.getMessage());
            }
        }
        return desconectat;
    }

    public ResultSet consulta(String consulta) throws Exception {
        ResultSet resultat = null;
        if (this.getConectat() && consulta.trim() != "") {
            Statement sentencia = this.conexio.createStatement();
            resultat = sentencia.executeQuery(consulta);
            this.setResultats(resultat);
        }
        return resultat;
    }

    public boolean consultaModificacio(String consultaModificacio) throws Exception {
        boolean totBe = false;
        if (this.getConectat() && consultaModificacio.trim() != "") {
            Statement sentencia = this.conexio.createStatement();
            int numeroResultats = sentencia.executeUpdate(consultaModificacio);
            totBe = true;
            sentencia.close();
        }
        return totBe;
    }

    public void mostrarResultat(ResultSet resultat) throws Exception {
        int x;
        if (resultat == null) {
            System.out.println("El resultat es null!!!");
        }
        ResultSetMetaData metaData = resultat.getMetaData();
        for (x = 0; x < metaData.getColumnCount(); ++x) {
            String columna = metaData.getColumnName(x);
            System.out.println(columna + "\t");
        }
        System.out.println("");
        while (resultat.next()) {
            for (x = 0; x < metaData.getColumnCount(); ++x) {
                System.out.println(resultat.getString(x) + "\t");
            }
            System.out.println("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importa(String fitxer) throws Exception {
        int x;
        System.out.println("Accedint a " + fitxer + "...");
        boolean totBe = true;
        boolean autoComitBackup = this.getAutoComit();
        this.setAutoComit(false);
        BufferedReader br = null;
        String[] linies = new String[127];
        int numLinies = 0;
        try {
            String linia;
            System.out.println("--- Llegint arxiu...");
            br = new BufferedReader(new FileReader(fitxer));
            linies[0] = "";
            x = 0;
            while ((linia = br.readLine()) != null) {
                if (linia.trim().equals("") || linia.trim().substring(0, 1).equals("#")) continue;
                if (linia.indexOf(";") != -1) {
                    int n = x;
                    linies[n] = linies[n] + linia.trim().substring(0, linia.indexOf(";") + 1);
                    System.out.println("Linia #" + x + ": " + linies[x]);
                    x = (byte)(x + 1);
                    linies[x] = linia.trim().substring(linia.indexOf(";") + 1);
                    continue;
                }
                int n = x;
                linies[n] = linies[n] + linia;
            }
            numLinies = x;
            System.out.println("--- L'arxiu ha estat llegit.");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println("L'arxiu no es pot llegir.");
            totBe = false;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                    System.out.println("L'arxiu s'ha tancat.");
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                System.out.println("L'arxiu no s'ha pogut tancar.");
                totBe = false;
            }
        }
        if (totBe && linies != null) {
            System.out.println("--- Executant linies...");
            Statement stmt = this.conexio.createStatement();
            for (x = 0; x < numLinies; x = (int)((byte)(x + 1))) {
                if (linies[x].trim().equals("")) continue;
                stmt.addBatch(linies[x]);
            }
            try {
                int[] updateCounts = stmt.executeBatch();
            }
            catch (Exception e) {
                System.out.println("Error a l'executar les linies.");
                System.out.println(e.getMessage());
                totBe = false;
            }
            System.out.println("--- Fi de l'execucio de les linies.");
            if (!totBe) {
                this.rollback();
                System.out.println("Fem rollback.");
            } else {
                this.commit();
                System.out.println("Fem commit.");
            }
        } else {
            totBe = false;
            System.out.println("No es poden executar les linies.");
        }
        this.setAutoComit(autoComitBackup);
        if (totBe) {
            System.out.println("L'operacio ha resultat satisfactoria.");
        } else {
            System.out.println("L'operacio ha resultat erronea.");
        }
        return totBe;
    }

    public static enum tipusBD {
        MYSQL,
        ACCESS;

    }
}

