/*
 * Decompiled with CFR 0.152.
 */
package gui;

import configuracion.Aspecto;
import configuracion.Idiomas;
import configuracion.Otros;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import logica.Menu;
import logica.Paleta;
import logica.Panel;
import logica.Pieza;
import logica.Tablero;
import principal.Main;

public class MotorGrafico {
    protected static int[][] graficoBackup = new int[127][127];
    protected static boolean graficoInicializado = false;
    protected static final int numeroCodificacionPiezas = Otros.getNumeroCodificacionPiezas();
    protected static byte celdaAncho = Aspecto.getCeldaAncho();
    protected static byte celdaAlto = Aspecto.getCeldaAlto();
    protected static final int VACIO = Otros.getNumeroVacio();

    private MotorGrafico() {
    }

    public static void setCeldaAncho(byte celdaAncho) {
        MotorGrafico.celdaAncho = celdaAncho;
    }

    public static byte getCeldaAncho() {
        return celdaAncho;
    }

    public static void setCeldaAlto(byte celdaAlto) {
        MotorGrafico.celdaAlto = celdaAlto;
    }

    public static byte getCeldaAlto() {
        return celdaAlto;
    }

    public static void dibujar(Graphics g, Object objeto) {
        if (objeto instanceof Pieza) {
            MotorGrafico.dibujarPieza(g, (Pieza)objeto);
        } else if (objeto instanceof Tablero) {
            MotorGrafico.dibujarTablero(g, (Tablero)objeto);
        } else if (objeto instanceof Panel) {
            MotorGrafico.dibujarPanel(g, (Panel)objeto);
        }
    }

    public static void dibujarPieza(Graphics g, Pieza pieza) {
        Paleta paleta = pieza.getPaleta();
        byte x = pieza.getLeft();
        byte y = pieza.getTop();
        byte ancho = pieza.getAncho();
        byte alto = pieza.getAlto();
        int[][] matriz = pieza.getForma();
        MotorGrafico.dibujarMatriz(g, paleta, matriz, x, y, ancho, alto, false);
    }

    public static void dibujarTablero(Graphics g, Tablero tablero) {
        if (!graficoInicializado) {
            MotorGrafico.inicializarGraficoBackup();
            graficoInicializado = true;
        }
        Paleta paleta = tablero.getPaleta();
        byte x = 0;
        byte y = 0;
        byte ancho = tablero.getAncho();
        byte alto = tablero.getAlto();
        int[][] matriz = tablero.getMapa();
        MotorGrafico.dibujarMatriz(g, paleta, matriz, x, y, ancho, alto, true);
    }

    public static void dibujarPanel(Graphics g, Panel panel) {
        Paleta paleta = panel.getPaleta();
        byte x = panel.getLeft();
        byte y = panel.getTop();
        byte ancho = panel.getAncho();
        byte alto = panel.getAlto();
        int[][] matriz = panel.getMapa();
        MotorGrafico.dibujarMatriz(g, paleta, matriz, x, y, ancho, alto, true);
        MotorGrafico.dibujarPanelInformacion(g, panel);
    }

    protected static void dibujarPanelInformacion(Graphics g, Panel panel) {
        int nivel = panel.getNivel();
        int puntos = panel.getPuntos();
        int lineas = panel.getLineas();
        int lineasNivel = panel.getLineasNivel();
        int x = panel.getLeft() * MotorGrafico.getCeldaAncho();
        int y = (panel.getTop() + panel.getAlto() + panel.getMargen()) * MotorGrafico.getCeldaAlto() + Aspecto.getEspacioLineasTexto();
        g.clearRect(x, y - Aspecto.getEspacioLineasTexto(), 400, Aspecto.getEspacioLineasTexto() * 5);
        Color colorTexto = panel.getPaleta().getColor(panel.getColorTexto());
        Font fuenteTexto = new Font("SansSerif", 0, Aspecto.getDimensionTexto());
        g.setColor(colorTexto);
        g.setFont(fuenteTexto);
        MotorGrafico.dibujarTexto(g, Idiomas.nivel[Main.getIdiomaActual()] + ": " + nivel, x, y, Aspecto.getEspacioLineasTexto());
        MotorGrafico.dibujarTexto(g, Idiomas.puntuacion[Main.getIdiomaActual()] + ": " + puntos, x, y += Aspecto.getEspacioLineasTexto(), Aspecto.getEspacioLineasTexto());
        MotorGrafico.dibujarTexto(g, Idiomas.lineasTotales[Main.getIdiomaActual()] + ": " + lineas, x, y += Aspecto.getEspacioLineasTexto(), Aspecto.getEspacioLineasTexto());
        MotorGrafico.dibujarTexto(g, Idiomas.lineasNivel[Main.getIdiomaActual()] + ": " + lineasNivel, x, y += Aspecto.getEspacioLineasTexto(), Aspecto.getEspacioLineasTexto());
        y += Aspecto.getEspacioLineasTexto();
    }

    public static void dibujarMenu(Graphics g, Menu menu) {
        String[] opciones = menu.getOpciones();
        Color colorTexto = menu.getPaleta().getColor(menu.getColorTexto());
        Color colorTextoFijo = menu.getPaleta().getColor(menu.getColorTextoFijo());
        Color colorTextoFondo = menu.getPaleta().getColor(menu.getColorTextoFondo());
        Color colorTextoSeleccionado = menu.getPaleta().getColor(menu.getColorTextoSeleccionado());
        Color colorTextoFondoSeleccionado = menu.getPaleta().getColor(menu.getColorTextoFondoSeleccionado());
        Color colorTextoAlternativo = menu.getPaleta().getColor(menu.getColorTextoAlternativo());
        Color colorTextoFondoAlternativo = menu.getPaleta().getColor(menu.getColorTextoFondoAlternativo());
        Font fuenteTexto = new Font("SansSerif", 0, Aspecto.getDimensionTexto());
        g.setFont(fuenteTexto);
        g.setColor(colorTextoFijo);
        MotorGrafico.dibujarTexto(g, menu.getTextoFijo(), menu.getTextoFijoLeft(), menu.getTextoFijoTop(), Aspecto.getEspacioLineasTexto());
        int[][] logo = menu.getLogo();
        MotorGrafico.dibujarMatriz(g, menu.getPaleta(), logo, menu.getLeftLogo(), menu.getTopLogo(), (byte)logo[0].length, (byte)logo.length, false);
        int top = menu.getTop();
        int left = menu.getLeft();
        for (int x = 0; x < opciones.length; ++x) {
            if (x == menu.getOpcionActualIndice()) {
                int[][] dibujo = menu.getDibujoActual();
                if (dibujo != null) {
                    MotorGrafico.dibujarMatriz(g, menu.getPaleta(), dibujo, menu.getLeftDibujoActual(), menu.getTopDibujoActual(), (byte)dibujo[0].length, (byte)dibujo.length, false);
                }
                g.setColor(colorTextoSeleccionado);
            } else {
                g.setColor(colorTexto);
            }
            MotorGrafico.dibujarTexto(g, opciones[x], left, top, Aspecto.getEspacioLineasTexto());
            top += Aspecto.getEspacioLineasTexto();
        }
        if (menu.getTextoAlternativoActual() != null && menu.getTextoAlternativoActual().trim() != "") {
            g.setColor(colorTextoAlternativo);
            left = menu.getLeftTextoAlternativoActual();
            top = menu.getTopTextoAlternativoActual();
            MotorGrafico.dibujarTexto(g, menu.getTextoAlternativoActual(), left, top, Aspecto.getEspacioLineasTexto());
        }
    }

    public static void dibujarTexto(Graphics g, String texto, int left, int top, int espacioEntreLineas, Color colorTexto) {
        g.setColor(colorTexto);
        MotorGrafico.dibujarTexto(g, texto, left, top, espacioEntreLineas);
    }

    public static void dibujarTexto(Graphics g, String texto, int left, int top, int espacioEntreLineas) {
        int topActual = top;
        while (texto.trim().length() > 0) {
            String textoParcial = texto.indexOf("\n") != -1 ? texto.substring(0, texto.indexOf("\n")) : texto;
            texto = texto.indexOf("\n") != -1 ? texto.substring(texto.indexOf("\n") + 1) : "";
            g.drawString(textoParcial, left, topActual);
            topActual += espacioEntreLineas;
        }
    }

    public static void dibujarMatriz(Graphics g, Paleta paleta, int[][] matriz, byte left, byte top, byte ancho, byte alto, boolean dibujarVacios) {
        byte y = top;
        for (byte f = 0; f < alto; f = (byte)(f + 1)) {
            byte x = left;
            for (byte c = 0; c < ancho; c = (byte)(c + 1)) {
                int indiceColor = matriz[f][c];
                if (indiceColor == VACIO && !dibujarVacios) {
                    x = (byte)(x + 1);
                    continue;
                }
                MotorGrafico.dibujarCasilla(g, paleta, indiceColor, x, y);
                x = (byte)(x + 1);
            }
            y = (byte)(y + 1);
        }
    }

    protected static void dibujarCasilla(Graphics g, Paleta paleta, int indiceColor, byte x, byte y) {
        if (x < 0 || y < 0) {
            return;
        }
        if (indiceColor < 0) {
            indiceColor /= numeroCodificacionPiezas;
        }
        MotorGrafico.actualizarGraficoBackup(indiceColor, x, y);
        Color color = paleta.getColor(indiceColor);
        g.setColor(color);
        int xReal = x * MotorGrafico.getCeldaAncho();
        int yReal = y * MotorGrafico.getCeldaAlto();
        g.fillRect(xReal, yReal, MotorGrafico.getCeldaAncho(), MotorGrafico.getCeldaAlto());
    }

    protected static void actualizarGraficoBackup(int indiceColor, byte x, byte y) {
        if (graficoBackup[x][y] != indiceColor) {
            MotorGrafico.graficoBackup[x][y] = indiceColor;
        }
    }

    protected static void inicializarGraficoBackup() {
        for (int f = 0; f < graficoBackup.length; f = (int)((byte)(f + 1))) {
            for (int c = 0; c < graficoBackup[0].length; c = (int)((byte)(c + 1))) {
                MotorGrafico.graficoBackup[f][c] = -1;
            }
        }
    }
}

