/*
 * Decompiled with CFR 0.152.
 */
package logica;

import configuracion.Otros;
import gui.MotorGrafico;
import java.awt.Graphics;
import java.util.Hashtable;
import logica.Paleta;
import principal.Main;

public class Menu {
    protected String[][] opciones;
    protected String[] valoresRetorno;
    protected Hashtable<Integer, Menu> submenus = new Hashtable();
    protected String textoFijo = "";
    protected int textoFijoLeft = 0;
    protected int textoFijoTop = 0;
    protected int[][] logo = new int[127][127];
    protected int[][][] dibujos = new int[127][127][127];
    protected String[][] textosAlternativos = new String[127][127];
    protected Paleta paleta;
    protected int opcionActual = 0;
    protected boolean opcionAceptada = false;
    protected boolean mostrar = false;
    protected final int colorTextoFijo = Otros.getNumeroColorMenuTextoFijo();
    protected final int colorTexto = Otros.getNumeroColorMenuTexto();
    protected final int colorTextoFondo = Otros.getNumeroColorMenuTextoFondo();
    protected final int colorTextoSeleccionado = Otros.getNumeroColorMenuTextoSeleccionado();
    protected final int colorTextoFondoSeleccionado = Otros.getNumeroColorMenuTextoFondoSeleccionado();
    protected final int colorTextoAlternativo = Otros.getNumeroColorMenuTextoAlternativo();
    protected final int colorTextoFondoAlternativo = Otros.getNumeroColorMenuTextoFondoAlternativo();
    protected int left = 0;
    protected int top = 0;
    protected byte leftLogo = 0;
    protected byte topLogo = 0;
    protected byte[] leftDibujos = new byte[127];
    protected byte[] topDibujos = new byte[127];
    protected int[][] leftTextosAlternativos = new int[127][127];
    protected int[][] topTextosAlternativos = new int[127][127];

    public Menu(Paleta paleta) {
        this.setPaleta(paleta);
    }

    public Menu(String[][] opciones, String[] valoresRetorno, Paleta paleta) {
        this(opciones, valoresRetorno, paleta, 0, 0);
    }

    public Menu(String[][] opciones, String[] valoresRetorno, Paleta paleta, int left, int top) {
        this(paleta);
        this.setOpciones(opciones);
        this.setValoresRetorno(valoresRetorno);
        this.setLeft(left);
        this.setTop(top);
    }

    public int getColorTexto() {
        return this.colorTexto;
    }

    public int getColorTextoFijo() {
        return this.colorTextoFijo;
    }

    public int getColorTextoFondo() {
        return this.colorTextoFondo;
    }

    public int getColorTextoSeleccionado() {
        return this.colorTextoSeleccionado;
    }

    public int getColorTextoFondoSeleccionado() {
        return this.colorTextoFondoSeleccionado;
    }

    public int getColorTextoAlternativo() {
        return this.colorTextoAlternativo;
    }

    public int getColorTextoFondoAlternativo() {
        return this.colorTextoFondoAlternativo;
    }

    public void setTextoFijo(String textoFijo, int textoFijoLeft, int textoFijoTop) {
        if (textoFijo != null) {
            this.textoFijo = textoFijo;
            this.setTextoFijoLeft(textoFijoLeft);
            this.setTextoFijoTop(textoFijoTop);
        }
    }

    public String getTextoFijo() {
        return this.textoFijo;
    }

    public void setTextoFijoLeft(int textoFijoLeft) {
        this.textoFijoLeft = textoFijoLeft;
    }

    public int getTextoFijoLeft() {
        return this.textoFijoLeft;
    }

    public void setTextoFijoTop(int textoFijoTop) {
        this.textoFijoTop = textoFijoTop;
    }

    public int getTextoFijoTop() {
        return this.textoFijoTop;
    }

    public void setTextosAlternativos(String[][] textosAlternativos) {
        this.textosAlternativos = textosAlternativos;
    }

    public String[][] getTextosAlternativos() {
        return this.textosAlternativos;
    }

    public void setTextoAlternativo(String[] textoAlternativo, int indice, int[] leftTextoAlternativo, int[] topTextoAlternativo) {
        if (indice < 0 || indice >= this.getTextosAlternativos().length) {
            return;
        }
        this.textosAlternativos[indice] = textoAlternativo;
        this.setLeftTextoAlternativo(leftTextoAlternativo, indice);
        this.setTopTextoAlternativo(topTextoAlternativo, indice);
    }

    public String getTextoAlternativo(int indice) {
        return this.getTextoAlternativo(indice, Main.getIdiomaActual());
    }

    public String getTextoAlternativo(int indice, int idioma) {
        if (indice < 0 || indice >= this.getTextosAlternativos().length) {
            return null;
        }
        if (this.getTextosAlternativos() == null) {
            return null;
        }
        return this.getTextosAlternativos()[indice][idioma];
    }

    public String getTextoAlternativoActual() {
        return this.getTextoAlternativo(this.getOpcionActualIndice());
    }

    public void setLogo(int[][] logo, byte leftLogo, byte topLogo) {
        this.logo = logo;
        this.setLeftLogo(leftLogo);
        this.setTopLogo(topLogo);
    }

    public int[][] getLogo() {
        return this.logo;
    }

    public void setLeftLogo(byte leftLogo) {
        this.leftLogo = leftLogo;
    }

    public byte getLeftLogo() {
        return this.leftLogo;
    }

    public void setTopLogo(byte topLogo) {
        this.topLogo = topLogo;
    }

    public byte getTopLogo() {
        return this.topLogo;
    }

    public void setDibujos(int[][][] dibujos, byte[] leftDibujos, byte[] topDibujos) {
        this.dibujos = dibujos;
        this.setLeftDibujos(leftDibujos);
        this.setTopDibujos(topDibujos);
    }

    public int[][][] getDibujos() {
        return this.dibujos;
    }

    public void setDibujo(int[][] dibujo, byte leftDibujo, byte topDibujo, int indice) {
        if (indice < 0 || indice >= this.numeroOpciones()) {
            return;
        }
        this.dibujos[indice] = dibujo;
        this.setLeftDibujo(leftDibujo, indice);
        this.setTopDibujo(topDibujo, indice);
    }

    public int[][] getDibujo(int indice) {
        if (indice < 0 || indice >= this.getDibujos().length) {
            return null;
        }
        if (this.getDibujos() == null) {
            return null;
        }
        return this.getDibujos()[indice];
    }

    public int[][] getDibujoActual() {
        if (this.obtenerSubmenu(this.opcionActual) != null && this.opcionAceptada) {
            return this.obtenerSubmenu(this.opcionActual).getDibujoActual();
        }
        return this.getDibujo(this.getOpcionActualIndice());
    }

    public void setOpciones(String[][] opciones) {
        this.opciones = opciones;
    }

    public String[] getOpciones() {
        return this.getOpciones(Main.getIdiomaActual());
    }

    public String[] getOpciones(int idioma) {
        String[] opciones = new String[this.numeroOpciones()];
        for (int x = 0; x < this.numeroOpciones(); ++x) {
            opciones[x] = this.opciones[x][idioma];
        }
        return opciones;
    }

    public void setValoresRetorno(String[] valoresRetorno) {
        this.valoresRetorno = valoresRetorno;
    }

    public String[] getValoresRetorno() {
        return this.valoresRetorno;
    }

    public void setPaleta(Paleta paleta) {
        this.paleta = paleta;
    }

    public Paleta getPaleta() {
        return this.paleta;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getLeft() {
        return this.left;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public int getTop() {
        return this.top;
    }

    public void setLeftDibujos(byte[] leftDibujos) {
        this.leftDibujos = leftDibujos;
    }

    public byte[] getLeftDibujos() {
        return this.leftDibujos;
    }

    public void setTopDibujos(byte[] topDibujos) {
        this.topDibujos = topDibujos;
    }

    public byte[] getTopDibujos() {
        return this.topDibujos;
    }

    public void setLeftDibujo(byte leftDibujo, int indice) {
        if (indice < 0 || indice >= this.getLeftDibujos().length) {
            return;
        }
        if (this.getLeftDibujos() == null) {
            return;
        }
        this.getLeftDibujos()[indice] = leftDibujo;
    }

    public byte getLeftDibujo(int indice) {
        if (indice < 0 || indice >= this.getLeftDibujos().length) {
            return -1;
        }
        if (this.getLeftDibujos() == null) {
            return -1;
        }
        return this.getLeftDibujos()[indice];
    }

    public void setTopDibujo(byte topDibujo, int indice) {
        if (indice < 0 || indice >= this.getTopDibujos().length) {
            return;
        }
        if (this.getTopDibujos() == null) {
            return;
        }
        this.getTopDibujos()[indice] = topDibujo;
    }

    public byte getTopDibujo(int indice) {
        if (indice < 0 || indice >= this.getTopDibujos().length) {
            return -1;
        }
        if (this.getTopDibujos() == null) {
            return -1;
        }
        return this.getTopDibujos()[indice];
    }

    public byte getLeftDibujoActual() {
        return this.getLeftDibujo(this.getOpcionActualIndice());
    }

    public byte getTopDibujoActual() {
        return this.getTopDibujo(this.getOpcionActualIndice());
    }

    public void setLeftTextosAlternativos(int[][] leftTextosAlternativos) {
        this.leftTextosAlternativos = leftTextosAlternativos;
    }

    public int[][] getLeftTextosAlternativos() {
        return this.leftTextosAlternativos;
    }

    public void setTopTextosAlternativos(int[][] topTextosAlternativos) {
        this.topTextosAlternativos = topTextosAlternativos;
    }

    public int[][] getTopTextosAlternativos() {
        return this.topTextosAlternativos;
    }

    public void setLeftTextoAlternativo(int[] leftTextoAlternativo, int indice) {
        if (indice < 0 || indice >= this.getLeftTextosAlternativos().length) {
            return;
        }
        if (this.getLeftTextosAlternativos() == null) {
            return;
        }
        this.getLeftTextosAlternativos()[indice] = leftTextoAlternativo;
    }

    public int[] getLeftTextoAlternativo(int indice) {
        if (indice < 0 || indice >= this.getLeftTextosAlternativos().length) {
            return null;
        }
        if (this.getLeftTextosAlternativos() == null) {
            return null;
        }
        return this.getLeftTextosAlternativos()[indice];
    }

    public void setTopTextoAlternativo(int[] topTextoAlternativo, int indice) {
        if (indice < 0 || indice >= this.getTopTextosAlternativos().length) {
            return;
        }
        if (this.getTopTextosAlternativos() == null) {
            return;
        }
        this.getTopTextosAlternativos()[indice] = topTextoAlternativo;
    }

    public int[] getTopTextoAlternativo(int indice) {
        if (indice < 0 || indice >= this.getTopTextosAlternativos().length) {
            return null;
        }
        if (this.getTopTextosAlternativos() == null) {
            return null;
        }
        return this.getTopTextosAlternativos()[indice];
    }

    public int getLeftTextoAlternativoActual() {
        return this.getLeftTextoAlternativo(this.getOpcionActualIndice())[Main.getIdiomaActual()];
    }

    public int getTopTextoAlternativoActual() {
        return this.getTopTextoAlternativo(this.getOpcionActualIndice())[Main.getIdiomaActual()];
    }

    public void setMostrar(boolean mostrar) {
        this.mostrar = mostrar;
    }

    public boolean getMostrar() {
        return this.mostrar;
    }

    public void setOpcionAceptada(boolean opcionAceptada) {
        this.opcionAceptada = opcionAceptada;
    }

    public boolean getOpcionAceptada() {
        return this.opcionAceptada;
    }

    public boolean getOpcionAceptadaSubmenu() {
        if (this.obtenerSubmenu(this.opcionActual) != null && this.opcionAceptada) {
            return this.obtenerSubmenu(this.opcionActual).getOpcionAceptada();
        }
        return false;
    }

    public boolean getOpcionAceptadaSubmenuRecursiva() {
        if (this.obtenerSubmenu(this.opcionActual) != null && this.opcionAceptada) {
            return this.obtenerSubmenu(this.opcionActual).getOpcionAceptadaSubmenuRecursiva();
        }
        return this.getOpcionAceptada();
    }

    public void setOpcionActual(String valorDevuelto) {
        int indice = this.indiceValor(valorDevuelto);
        this.setOpcionActual(indice);
    }

    public void setOpcionActual(int opcion) {
        if (opcion < 0) {
            opcion = this.numeroOpciones() - 1;
        } else if (opcion >= this.numeroOpciones()) {
            opcion = 0;
        }
        this.opcionActual = opcion;
        this.opcionAceptada = false;
    }

    public int getOpcionActualIndiceSinRecursividad() {
        return this.opcionActual;
    }

    public int getOpcionActualIndice() {
        if (this.obtenerSubmenu(this.opcionActual) != null && this.opcionAceptada) {
            return this.obtenerSubmenu(this.opcionActual).getOpcionActualIndice();
        }
        return this.opcionActual;
    }

    public String getOpcionActualTexto() {
        return this.getOpcionActualTexto(Main.getIdiomaActual());
    }

    public String getOpcionActualTexto(int idioma) {
        if (this.obtenerSubmenu(this.opcionActual) != null && this.opcionAceptada) {
            return this.obtenerSubmenu(this.opcionActual).getOpcionActualTexto();
        }
        return this.opciones[this.getOpcionActualIndice()][idioma];
    }

    public String getOpcionActualValor() {
        if (this.obtenerSubmenu(this.opcionActual) != null && this.opcionAceptada) {
            return this.obtenerSubmenu(this.opcionActual).getOpcionActualValor();
        }
        return this.valoresRetorno[this.getOpcionActualIndice()];
    }

    public void agregarOpcion(String[] opcion, String valorRetorno) {
        this.agregarOpcion(opcion, valorRetorno, this.numeroOpciones());
    }

    public void agregarOpcion(String[] opcion, String valorRetorno, int indice) {
        int x;
        if (indice < 0 || indice > this.numeroOpciones()) {
            return;
        }
        String[][] opcionesModificado = new String[this.numeroOpciones() + 1][this.opciones[0].length];
        String[] valoresRetornoModificado = new String[this.numeroOpciones() + 1];
        for (x = 0; x < indice; ++x) {
            opcionesModificado[x] = this.opciones[x];
            valoresRetornoModificado[x] = this.valoresRetorno[x];
        }
        opcionesModificado[indice] = opcion;
        valoresRetornoModificado[indice] = valorRetorno;
        for (x = indice; x < this.numeroOpciones(); ++x) {
            opcionesModificado[x + 1] = this.opciones[x];
            valoresRetornoModificado[x + 1] = this.valoresRetorno[x];
        }
        this.setOpciones(opcionesModificado);
        this.setValoresRetorno(valoresRetornoModificado);
    }

    public void eliminarOpcion(int indice) {
        if (indice < 0 || indice >= this.numeroOpciones()) {
            return;
        }
        String[][] opcionesModificado = new String[this.numeroOpciones() - 1][this.opciones[0].length];
        String[] valoresRetornoModificado = new String[this.numeroOpciones() - 1];
        int y = 0;
        for (int x = 0; x < this.numeroOpciones(); ++x) {
            if (x == indice) continue;
            opcionesModificado[y] = this.opciones[x];
            valoresRetornoModificado[y] = this.valoresRetorno[x];
            ++y;
        }
        this.setOpciones(opcionesModificado);
        this.setValoresRetorno(valoresRetornoModificado);
    }

    public void agregarSubmenu(Menu menu, int indice) {
        if (indice < 0 || indice > this.numeroOpciones()) {
            return;
        }
        this.submenus.put(indice, menu);
    }

    public void eliminarSubmenu(int indice) {
        if (indice < 0 || indice >= this.numeroOpciones()) {
            return;
        }
        this.submenus.remove(indice);
    }

    public int indiceValor(String valorDevuelto) {
        int indice = -1;
        for (int x = 0; x < this.valoresRetorno.length; ++x) {
            String valor = this.valoresRetorno[x];
            if (!valorDevuelto.toUpperCase().equals(valor.toUpperCase())) continue;
            indice = x;
            break;
        }
        return indice;
    }

    public Menu obtenerSubmenu(String valorDevuelto) {
        int indice = this.indiceValor(valorDevuelto);
        return this.submenus.get(indice);
    }

    public Menu obtenerSubmenu(int indice) {
        if (indice < 0 || indice >= this.numeroOpciones()) {
            return null;
        }
        return this.submenus.get(indice);
    }

    public void bajarOpcion() {
        if (this.obtenerSubmenu(this.opcionActual) != null && this.opcionAceptada) {
            this.obtenerSubmenu(this.opcionActual).bajarOpcion();
            return;
        }
        this.setOpcionActual(this.opcionActual + 1);
        this.opcionAceptada = false;
    }

    public void subirOpcion() {
        if (this.obtenerSubmenu(this.opcionActual) != null && this.opcionAceptada) {
            this.obtenerSubmenu(this.opcionActual).subirOpcion();
            return;
        }
        this.setOpcionActual(this.opcionActual - 1);
        this.opcionAceptada = false;
    }

    public void aceptarOpcionActual() {
        if (this.obtenerSubmenu(this.opcionActual) != null && this.opcionAceptada) {
            this.obtenerSubmenu(this.opcionActual).aceptarOpcionActual();
            return;
        }
        this.opcionAceptada = true;
        if (this.obtenerSubmenu(this.opcionActual) != null) {
            this.obtenerSubmenu(this.opcionActual).setMostrar(true);
            this.obtenerSubmenu(this.opcionActual).setOpcionActual(0);
        }
    }

    public void cancelarOpcionActual() {
        if (this.obtenerSubmenu(this.opcionActual) != null && this.opcionAceptada) {
            this.obtenerSubmenu(this.opcionActual).cancelarOpcionActual();
        }
        this.setOpcionAceptada(false);
    }

    public int numeroOpciones() {
        return this.opciones.length;
    }

    public void dibujar(Graphics contenedor) {
        if (this.obtenerSubmenu(this.opcionActual) != null && this.opcionAceptada) {
            this.obtenerSubmenu(this.opcionActual).dibujar(contenedor);
            return;
        }
        if (!this.getMostrar()) {
            return;
        }
        MotorGrafico.dibujarMenu(contenedor, this);
    }
}

