/*
 * Decompiled with CFR 0.152.
 */
package logica;

import configuracion.Otros;
import gui.MotorGrafico;
import java.awt.Graphics;
import logica.Paleta;
import logica.Pieza;
import logica.Tablero;

public class Panel {
    protected Pieza[] piezasBase;
    protected Tablero tablero;
    protected byte left;
    protected byte top;
    protected byte ancho;
    protected byte alto;
    protected Paleta paleta;
    protected int[][] mapa;
    protected Pieza piezaInsertada;
    protected final int colorTexto = Otros.getNumeroColorPanelTexto();
    protected final int color = Otros.getNumeroColorPanel();
    protected final int VACIO = Otros.getNumeroVacio();
    protected final byte margen = 1;
    protected int nivel = 0;
    protected int puntos = 0;
    protected int lineas = 0;
    protected int lineasNivel = 0;

    public Panel(Pieza[] piezasBase, Paleta paleta, Tablero tablero) {
        this.setPiezasBase(piezasBase);
        this.setPaleta(paleta);
        this.setTablero(tablero);
    }

    public int getColorTexto() {
        return this.colorTexto;
    }

    public byte getMargen() {
        return this.margen;
    }

    public void setPaleta(Paleta paleta) {
        this.paleta = paleta;
    }

    public Paleta getPaleta() {
        return this.paleta;
    }

    public void setPiezasBase(Pieza[] piezasBase) {
        this.piezasBase = piezasBase;
        byte[] anchoAltoMayores = this.buscarAnchoAltoMayores(piezasBase);
        this.setAncho(anchoAltoMayores[0]);
        this.setAlto(anchoAltoMayores[1]);
        this.mapa = new int[this.getAlto()][this.getAncho()];
    }

    public Pieza[] getPiezasBase() {
        return this.piezasBase;
    }

    public void setTablero(Tablero tablero) {
        this.tablero = tablero;
        this.setLeft(this.getTablero().getAncho());
        this.setTop((byte)0);
    }

    public Tablero getTablero() {
        return this.tablero;
    }

    public void setLeft(byte left) {
        this.left = (byte)(left + this.margen);
    }

    public byte getLeft() {
        return this.left;
    }

    public void setTop(byte top) {
        this.top = (byte)(top + this.margen);
    }

    public byte getTop() {
        return this.top;
    }

    public void setAncho(byte ancho) {
        this.ancho = (byte)(ancho + this.margen * 2);
    }

    public byte getAncho() {
        return this.ancho;
    }

    public void setAlto(byte alto) {
        this.alto = (byte)(alto + this.margen * 2);
    }

    public byte getAlto() {
        return this.alto;
    }

    public int[][] getMapa() {
        return this.mapa;
    }

    public void insertarPieza(Pieza pieza) {
        this.setPiezaInsertada(pieza);
    }

    public void setPiezaInsertada(Pieza pieza) {
        this.piezaInsertada = pieza;
        if (pieza.getAncho() > this.getAncho()) {
            this.setAncho(pieza.getAncho());
        }
        if (pieza.getAlto() > this.getAlto()) {
            this.setAlto(pieza.getAlto());
        }
        this.insertarPiezaEnMapa(pieza);
    }

    public Pieza getPiezaInsertada() {
        return this.piezaInsertada;
    }

    public void setNivel(int nivel) {
        this.nivel = nivel;
    }

    public int getNivel() {
        return this.nivel;
    }

    public void setPuntos(int puntos) {
        this.puntos = puntos;
    }

    public int getPuntos() {
        return this.puntos;
    }

    public void setLineas(int lineas) {
        if (lineas >= 0) {
            this.lineas = lineas;
        }
    }

    public int getLineas() {
        return this.lineas;
    }

    public void setLineasNivel(int lineasNivel) {
        if (lineasNivel >= 0) {
            this.lineasNivel = lineasNivel;
        }
    }

    public int getLineasNivel() {
        return this.lineasNivel;
    }

    protected void insertarPiezaEnMapa(Pieza pieza) {
        int[][] forma = pieza.getForma();
        this.vaciarMapa();
        byte leftPieza = this.calcularLeftPieza(pieza);
        byte topPieza = this.calcularTopPieza(pieza);
        byte fPieza = 0;
        for (byte f = topPieza; f < this.getAlto(); f = (byte)(f + 1)) {
            byte cPieza = 0;
            for (byte c = leftPieza; c < this.getAncho(); c = (byte)(c + 1)) {
                if (fPieza < pieza.getAlto() && cPieza < pieza.getAncho() && forma[fPieza][cPieza] != this.VACIO) {
                    this.getMapa()[f][c] = forma[fPieza][cPieza];
                }
                cPieza = (byte)(cPieza + 1);
            }
            fPieza = (byte)(fPieza + 1);
        }
    }

    protected byte calcularLeftPieza(Pieza pieza) {
        byte left = (byte)((this.getAncho() - pieza.getAncho()) / 2);
        byte margenDerecho = (byte)Math.abs(left + pieza.getAncho() - this.getAncho());
        while (left < margenDerecho && margenDerecho > this.margen) {
            left = (byte)(left + this.margen);
        }
        return left;
    }

    protected byte calcularTopPieza(Pieza pieza) {
        byte top = (byte)((this.getAlto() - pieza.getAlto()) / 2);
        byte margenInferior = (byte)Math.abs(top + pieza.getAlto() - this.getAlto());
        while (top < margenInferior && margenInferior > this.margen) {
            top = (byte)(top + this.margen);
        }
        return top;
    }

    protected void vaciarMapa() {
        for (byte f = 0; f < this.getAlto(); f = (byte)(f + 1)) {
            for (byte c = 0; c < this.getAncho(); c = (byte)(c + 1)) {
                this.getMapa()[f][c] = this.color;
            }
        }
    }

    public void vaciar() {
        this.vaciarMapa();
    }

    public byte[] buscarAnchoAltoMayores(Pieza[] piezasBase) {
        byte[] anchoAltoMayores = new byte[]{piezasBase[0].getAncho(), piezasBase[0].getAlto()};
        for (int x = 0; x < piezasBase.length; ++x) {
            if (piezasBase[x].getAncho() > anchoAltoMayores[0]) {
                anchoAltoMayores[0] = piezasBase[x].getAncho();
            }
            if (piezasBase[x].getAlto() <= anchoAltoMayores[1]) continue;
            anchoAltoMayores[1] = piezasBase[x].getAlto();
        }
        return anchoAltoMayores;
    }

    public void dibujar(Graphics contenedor) {
        MotorGrafico.dibujarPanel(contenedor, this);
    }
}

