/*
 * Decompiled with CFR 0.152.
 */
package primera_part;

import java.util.Date;
import primera_part.Producte;

public class Bicicleta
extends Producte {
    protected String marcaQuadre = "";
    protected int tipusBicicleta;
    protected byte numVelocitats = 1;

    public Bicicleta(float preu, String codi, String marcaQuadre) throws Exception {
        super(preu, codi);
        this.setMarcaQuadre(marcaQuadre);
    }

    public Bicicleta(float preu, String codi, String marcaQuadre, int tipusBicicleta) throws Exception {
        this(preu, codi, marcaQuadre);
        this.setTipusBicicleta(tipusBicicleta);
    }

    public Bicicleta(float preu, String codi, String descripcio, String marcaQuadre, int tipusBicicleta) throws Exception {
        this(preu, codi, marcaQuadre, tipusBicicleta);
        this.setDescripcio(descripcio);
    }

    public Bicicleta(float preu, String codi, String descripcio, Date dataCaducitat, String marcaQuadre, int tipusBicicleta) throws Exception {
        this(preu, codi, descripcio, marcaQuadre, tipusBicicleta);
        this.setDataCaducitat(dataCaducitat);
    }

    public void setMarcaQuadre(String marcaQuadre) throws Exception {
        if (marcaQuadre == null) {
            throw new Exception("La marca del quadre no pot ser nul");
        }
        this.marcaQuadre = marcaQuadre;
    }

    public String getMarcaQuadre() {
        this.marcaQuadre = this.marcaQuadre;
        return this.marcaQuadre;
    }

    public void setTipusBicicleta(int tipusBicicleta) throws Exception {
        if (!this.tipusValid(tipusBicicleta)) {
            throw new Exception("El tipus no es valid");
        }
        this.tipusBicicleta = tipusBicicleta;
    }

    public int getTipusBicicleta() {
        return this.tipusBicicleta;
    }

    public boolean tipusValid(int tipusBicicleta) {
        boolean valid = false;
        if (tipusBicicleta >= 0 && tipusBicicleta < tipus.values().length) {
            valid = true;
        }
        return valid;
    }

    public void setVelocitats(byte numVelocitats) throws Exception {
        if (numVelocitats < 1) {
            throw new Exception("El numero de velocitats ha de ser 1 o superior.");
        }
        this.numVelocitats = numVelocitats;
    }

    public byte getVelocitats() {
        return this.numVelocitats;
    }

    @Override
    public String toString() {
        String cadena = " [Quadre: " + this.getMarcaQuadre() + "] [Tipus: " + this.getTipusBicicleta() + "] [Velocitats: " + this.getVelocitats() + "]";
        return super.toString() + " " + cadena;
    }

    protected static enum tipus {
        MUNTANYA,
        CARRETERA;

    }
}

