/*
 * Decompiled with CFR 0.152.
 */
package primera_part;

import java.util.Date;

public class Producte {
    protected float preu;
    protected String codi;
    protected String descripcio = "";
    protected Date dataCaducitat = null;

    public Producte(float preu, String codi) throws Exception {
        this.setPreu(preu);
        this.setCodi(codi);
    }

    public Producte(float preu, String codi, String descripcio) throws Exception {
        this(preu, codi);
        this.setDescripcio(descripcio);
    }

    public Producte(float preu, String codi, String descripcio, Date dataCaducitat) throws Exception {
        this(preu, codi, descripcio);
        this.setDataCaducitat(dataCaducitat);
    }

    public void setPreu(float preu) throws Exception {
        if (!(preu >= 0.0f)) {
            throw new Exception("El preu ha de ser 0 (gratis) o superior");
        }
        this.preu = preu;
    }

    public float getPreu() {
        return this.preu;
    }

    public void setCodi(String codi) throws Exception {
        if (codi == null) {
            throw new Exception("El codi no pot ser nul");
        }
        this.codi = codi;
    }

    public String getCodi() {
        return this.codi;
    }

    public void setDescripcio(String descripcio) throws Exception {
        if (descripcio == null) {
            throw new Exception("La descripcio no pot ser nul");
        }
        this.descripcio = descripcio;
    }

    public String getDescripcio() {
        return this.descripcio;
    }

    public void setDataCaducitat(Date dataCaducitat) {
        this.dataCaducitat = dataCaducitat;
    }

    public Date getDataCaducitat() {
        return this.dataCaducitat;
    }

    public String toString() {
        String cadena = "[" + this.getCodi() + "] " + this.getDescripcio() + " (" + this.getPreu() + ")";
        cadena = this.getDataCaducitat() != null ? cadena + " {" + this.getDataCaducitat() + "}" : cadena + " {No caduca}";
        return cadena;
    }
}

