package llibres;

/* [ESBORRAR] PROXIM DIA: buscar elements dels vectors en els sets per que no
                          siguin strings buits (utilitzar trim()). */

public class llibre
{
    private String ISBN;
    private String titol;
    private String autors[];
    private String editorial;
    private int quantitat;
    private float preu;
    private String imatgePortada;
    private String imatgeContraportada;
    private String sinopsi;
    private String categories[];
    
    public llibre()
    {
        this.setISBN("-1");
        this.setTitol("Sense titol");
        this.setAutors(new String[1]);
        this.getAutors()[0] = "Autor";
        this.setEditorial("Editorial");
        this.setQuantitat(100);
        this.setPreu(20);
        this.setImatgePortada(this.getISBN() + "_portada.jpg");
        this.setImatgeContraportada(this.getISBN() + "_contraportada.jpg");
        this.setSinopsi("Sinopsi");
        this.setCategories(new String[1]);
        this.getCategories()[0] = "Sense categoria";
    }

    public llibre(String ISBN, String titol, String editorial, int quantitat,
                  float preu, String sinopsi, String autors[],
                  String categories[])
    {
        this();
        this.setISBN(ISBN);
        this.setTitol(titol);
        this.setEditorial(editorial);
        this.setQuantitat(quantitat);
        this.setPreu(preu);
        this.setSinopsi(sinopsi);
        this.setAutors(autors);
        this.setCategories(categories);
    }

    public String getISBN()
    {
        return ISBN;
    }

    public void setISBN(String ISBN)
    {
        if (trim(ISBN) == "") { System.out.println("Error: valor buit"); return; }
        this.ISBN = ISBN;
    }

    public String getTitol()
    {
        return titol;
    }

    public void setTitol(String titol)
    {
        if (trim(titol) == "") { System.out.println("Error: valor buit"); return; }
        this.titol = titol;
    }

    public String[] getAutors()
    {
        return autors;
    }

    public void setAutors(String[] autors)
    {
        if (autors == null) { System.out.println("Error: punter null"); return; }
        //if (stringsBuides(autors)) { System.out.println("Error: un o mes valors del vector estan buits"); return; }
        this.autors = autors;
    }

    public String getEditorial()
    {
        return editorial;
    }

    public void setEditorial(String editorial)
    {
        if (trim(editorial) == "") { System.out.println("Error: valor buit"); return; }
        this.editorial = editorial;
    }

    public int getQuantitat()
    {
        return quantitat;
    }

    public void setQuantitat(int quantitat)
    {
        if (quantitat < 0) { System.out.println("Error: valor negatiu"); return; }
        this.quantitat = quantitat;
    }

    public float getPreu()
    {
        return preu;
    }

    public void setPreu(float preu)
    {
        if (preu < 0) { System.out.println("Error: valor negatiu"); return; }
        this.preu = preu;
    }

    public String getImatgePortada()
    {
        return imatgePortada;
    }

    public void setImatgePortada(String imatgePortada)
    {
        if (trim(imatgePortada) == "") { System.out.println("Error: valor buit"); return; }
        this.imatgePortada = imatgePortada;
    }

    public String getImatgeContraportada()
    {
        return imatgeContraportada;
    }

    public void setImatgeContraportada(String imatgeContraportada)
    {
        if (trim(imatgeContraportada) == "") { System.out.println("Error: valor buit"); return; }
        this.imatgeContraportada = imatgeContraportada;
    }

    public String getSinopsi()
    {
        return sinopsi;
    }

    public void setSinopsi(String sinopsi)
    {
        if (trim(sinopsi) == "") { System.out.println("Error: valor buit"); return; }
        this.sinopsi = sinopsi;
    }

    public String[] getCategories()
    {
        return categories;
    }

    public void setCategories(String[] categories)
    {
        if (categories == null) { System.out.println("Error: punter null"); return; }
        //if (stringsBuides(categories)) { System.out.println("Error: un o mes valors del vector estan buits"); return; }
        this.categories = categories;
    }
    
    public void mostraDades()
    {
        System.out.println(
                            "ISBN: " + this.getISBN() +
                            ", Titol: " + this.getTitol() +
                            ", Autors: " + this.vectorAText(this.getAutors()) +
                            ", Editorial: " + this.getEditorial() +
                            ", Quantitat: " + this.getQuantitat() +
                            //", Preu: " + (((int) (getPreu()*100)) / 100) +
                            ", Preu: " + this.redondeix(this.getPreu(), 2) +
                            ", Sinopsi: " + this.getSinopsi() +
                            ", Categories: " + this.vectorAText(this.getCategories())
                           );
        return;
    }

    private float redondeix(float numero, int decimals)
    {
        numero = (int) (numero * Math.pow((double) 10, (double) decimals));
        numero = (float) (numero / Math.pow((double) 10, (double) decimals));
        return numero;
    }
    
    private String vectorAText(String vector[])
    {
        String text = "";
        for (int x = 0; x < vector.length; x++) { text += vector[x] + ", "; }
        text = text.substring(0, text.lastIndexOf(", "));
        return text;
    }
    
    public boolean comparaLlibre(llibre llibre2)
    {
        return (this.ISBN == llibre2.ISBN);
    }
    
    private String trim(String cadena)
    {
        if (cadena == null) { return cadena; }
        while (cadena.charAt(0) == ' ') { cadena = cadena.substring(1); }
        while (cadena.charAt(cadena.length()-1) == ' ') { cadena = cadena.substring(0, cadena.length()-2); }
        return cadena;
    }
    
    private boolean stringsBuides(String vector[])
    {
        boolean buits = false;
        
        for (int x = 0; x < vector.length; x++)
        {
            //if (vector[x] != null && vector[x].trim() == "") { buits = true; break; }
            if (trim(vector[x]) == "") { buits = true; break; }
        }
            
        return buits;
    }
}
