/** Exemple de connexi a la base de dades Llibres de MySQL.
 *  
 *  s la mateixa base de dades que en ACCESS, exportada a MySQL.
 *
 */
 

//package bd.MySQL;

import java.sql.*;

public class MySQL1
{
    
    public static void main(String[] args) 
    {                 
        Connection connexio = null;
        Statement sentencia = null;
        
        try 
        {                       
            /* Carrega els drivers de MySQL */ 
            //Class.forName("com.mysql.jdbc.Driver").newInstance();
            DriverManager.registerDriver(new com.mysql.jdbc.Driver());
            System.out.println("Drivers carregats!!");
            
            /* Connecta amb la bd */
            String servidor = "127.0.0.1";
            /* String port = "3306"; <-- port per defecte */
            String bd = "BDLlibres";
            String usuari = "root";
            String password = "";            
            String url = "jdbc:mysql://" + servidor + "/" + bd; 
            /* Si canvia el port per defecte: 
                String url = "jdbc:mysql://" + servidor +":" +  port + "/" + bd; 
             */
            //getConnection("jdbc:mysql://localhost/test?user=monty&password=greatsqldb");
            connexio = DriverManager.getConnection(url, usuari, password); 
            System.out.println("Connectat a la BD !!");            
            
            /* Crea una sentncia per poder treballar amb la bd */
            sentencia=connexio.createStatement();
            System.out.println("Sentncia creada !!");
            
            /* Consulta tots els atributs de la taula consultes */
  
            System.out.println("\n");
            
        }                
        catch (SQLException e) 
        {
            System.out.println("Error SQL: " + e.getMessage());    
            System.out.println("SQLState: " + e.getSQLState()); 
            System.out.println("VendorError: " + e.getErrorCode());             
        }   
        catch (Exception e) 
        {
            System.out.println("Error SQL: " + e.getMessage());                      
        }   
        
        finally
        {
            try
            {
                /* Tanca la sentncia */
                if (sentencia!=null)
                {
                    sentencia.close();
                    System.out.println("Sentncia tancada !!");
                }
            
                /* Tanca la connexi */ 
                if (connexio!=null)
                {
                    connexio.close();            
                    System.out.println("Connexi tancada !!");            
                }            
            }
            catch(SQLException e)
            {}
        }

    }        
}
