package TresEnters;

public class Elipse extends Figura
{
    private float radiA, radiB;
    
    public Elipse(float radiA, float radiB) throws EntersException
    {
        this.setRadiA(radiA);
        this.setRadiB(radiB);
    }
    
    public void setRadiA(float radiA) throws EntersException
    {
        if (radiA <= 0) { throw new EntersException("El valor del radi no pot ser negatiu o zero!"); }
        else { this.radiA = radiA; }
        return;
    }

    public void setRadiB(float radiB) throws EntersException
    {
        if (radiB <= 0) { throw new EntersException("El valor del radi no pot ser negatiu o zero!"); }
        else { this.radiB = radiB; }
        return;
    }

    public float getRadiA()
    {
        return this.radiA;
    }

    public float getRadiB()
    {
        return this.radiB;
    }

    
    public float calcularArea()
    {
        return (float) Math.PI * this.getRadiA() * this.getRadiB();
    }
    
    public float calcularPerimetre()
    {
        float A = (this.getRadiA() + this.getRadiB()) / 2;
        float B = (float) Math.sqrt(
                                    (
                                        Math.pow(this.getRadiA(), 2) +
                                        Math.pow(this.getRadiB(), 2)
                                    ) / 2
                                   );
        float perimetre = (float) Math.PI * (A + B);
        return perimetre;
    }
}
