package TresEnters;

public class TresEnters extends DosEnters
{
    protected int z;
    
    public TresEnters(int x, int y, int z) throws EntersException
    {
        this.setXYZ(x, y, z);
    }

    public void setZ(int z) throws EntersException { this.setXYZ(this.x, this.y, z); }
    
    public void setXZ(int x, int z) throws EntersException { this.setXYZ(x, this.y, z); }
    
    public void setYZ(int y, int z) throws EntersException { this.setXYZ(this.x, y, z); }
    
    public void setXYZ(int x, int y, int z) throws EntersException
    {
        if (x < 0) { throw new EntersException("El valor de X no pot ser negatiu!"); }
        else { this.x = x; }
        if (y < 0) { throw new EntersException("El valor de Y no pot ser negatiu!"); }
        else { this.y = y; }
        if (z < 0) { throw new EntersException("El valor de Z no pot ser negatiu!"); }
        else { this.z = z; }
    }
        
    public int getZ() { return this.z; }
    
    public boolean isParellZ() { return (this.z % 2 == 0); }
    
    public boolean equals(Object obj)
    {
        if (obj instanceof TresEnters)
        {
            TresEnters objB = (TresEnters) obj;
            return (
                        this.getX() == objB.getX() &&
                        this.getY() == objB.getY() &&
                        this.getZ() == objB.getZ()
                    );
        }
        else { return false; }
    }
    
    public String toString()
    {
        return "Els meus valor son: x=" + getX() + ", y=" + this.getY() + ", z=" + this.getZ();
    }

    public int sumar() { return getX() + getY() + getZ(); }
    
    public int restar() { return getX()-getY()-getZ(); }
    
    public int multiplicar() { return getX()*getY()*getZ(); }
    
    public int dividir()
    {
        try { return getX() / getY() / getZ(); }
        catch (ArithmeticException e) { System.out.println(e.getMessage()); return 0; }
    }
    
    public int modul()
    {
        try { return getX() % getY() % getZ(); }
        catch (ArithmeticException e) { System.out.println(e.getMessage()); return 0; }
    }

}
