package net;
public abstract class Server
{
    private int id;
    private String nom;
    
    public Server(int id, String nom) throws MevaExcepcio
    {
        this.setId(id);
        this.setNom(nom);
    }
    
    public int getId()
    {
        return this.id;
    }
    
    public String getNom()
    {
        return this.nom;
    }
    
    public void setId(int id)
    {
        this.id = id;
    }
    
    public void setNom(String nom) throws MevaExcepcio
    {
        if (nom == null || nom.trim() == "") { throw new MevaExcepcio("El nom ha de contenir alguna cosa"); }
        this.nom = nom;
    }
    
    public String toString()
    {
        return "[" + this.getId() + "] " + this.getNom();
    }
    
    public boolean equals(Object ob)
    {
        boolean iguals = false;
        if (ob instanceof Server)
        {
            Server ob2 = (Server) ob;
            //Comprova el id i el nom, pero a lo millor amb el id ja seria prou:
            //if (ob2.getId() == this.getId() && ob2.getNom() == this.getNom())
            if (ob2.getId() == this.getId())
            {
                iguals = true;
            }
        }
        
        return iguals;
    }
    
    public abstract String getResponse(String matriu[]) throws NetException;
}
