package ex2;

import java.util.*;
import net.*;

public class Repositori
{
    private Hashtable<Integer, Server> Servidors = new Hashtable<Integer, Server>();
    private Vector<Server> ServidorsVector = new Vector<Server>();
    
    public Repositori()
    {
        
    }

    public Repositori(Server servidor) throws MevaExcepcio
    {
        this.afegirServidor(servidor);
    }
    
    public Repositori(Repositori repositori) throws MevaExcepcio
    {
        this.afegirRepositori(repositori);
    }
    
    public void afegirServidor(Server servidor) throws MevaExcepcio
    {
        if (servidor == null) { throw new MevaExcepcio("El servidor apunta a null!"); }
        else if (this.enRepositori(servidor)) { throw new MevaExcepcio("El servidor ja existeix en el repositori!"); }
        else //No fa falta el else.
        {
            //Si es parell, s'emmagatzema en la hash table:
            if (servidor.getId() % 2 == 0)
            {
                this.Servidors.put(servidor.getId(), servidor);
            }
            //...pero si no, en el vector:
            else
            {
                this.ServidorsVector.addElement(servidor);
            }
        }
    }
    
    public void afegirRepositori(Repositori repositori) throws MevaExcepcio //Es podria fer amb clone?
    {
        Server servidor;
        for (int id : repositori.Servidors.keySet())
        {
            if (!this.enRepositori(id))
            {
                servidor = repositori.obtenirServidor(id);
                this.afegirServidor(servidor);
            }
        }
    }
    
    public Server obtenirServidor(int id)
    {
        Server servidor = null;
        
        if (id % 2 == 0) { servidor = this.Servidors.get(id); }
        else
        {
            for (int x = 0; x < this.ServidorsVector.size() && servidor == null; x++)
            {
                if (id == this.ServidorsVector.get(x).getId()) { servidor = this.ServidorsVector.get(x); }
            }
        }
        
        return servidor;
    }
    
    public boolean enRepositori(int id)
    {
        boolean trobat = false;

        //Si es parell, el busca en la hash table:
        if (id % 2 == 0)
        {
            trobat = this.Servidors.containsKey(id);
        }
        //...i si no, en el vector:
        else
        {
            //Reconstrueix una replica i busca un igual que ell:
            //Server replica = new Server();
            //replica.setId(id);
            //replica.setNom("");
            for (int x = 0; x < this.ServidorsVector.size() && !trobat; x++)
            {
                if (id == this.ServidorsVector.get(x).getId()) { trobat = true; }
            }
        }
        
        return trobat;
    }
    
    public boolean enRepositori(Server servidor)
    {
        return enRepositori(servidor.getId());
    }

    public void posar(Server servidor) throws MevaExcepcio
    {
        this.afegirServidor(servidor);
    }

    public Server obtenir(int id)
    {
        return obtenirServidor(id);
    }
    
    public Server treure(int id)
    {
        Server servidor = null;
        if (enRepositori(id))
        {
            servidor = obtenir(id);
            
            //Si es par, el treu de la hash table:
            if (id % 2 == 0)
            {
                this.Servidors.remove(id);
            }
            //...pero si es senar, del vector:
            else
            {
                for (int x = 0; x < this.ServidorsVector.size(); x++)
                {
                    if (this.ServidorsVector.get(x).getId() == id)
                    {
                        this.ServidorsVector.remove(x);
                    }
                }
            }
        }
        return servidor;
    }
    
    public int hiEs(int id)
    {
        boolean existeix = enRepositori(id);
        if (existeix)
        {
            //Si exiseix i es par, ha d'estar en la taula hash:
            if (id % 2 == 0) { return 2; }
            //..pero si no, en el vector:
            else { return 1; }
        }
        return 0; //return existeix;
    }
   
    public String toString()
    {
        String text = "";
        Server servidor;
        for (int id : this.Servidors.keySet())
        {
            servidor = this.obtenirServidor(id);
            text += servidor.toString() + "\n";
        }
        for (int x = 0; x < this.ServidorsVector.size(); x++)
        {
            text += this.ServidorsVector.get(x).toString() + "\n";
        }
        return text;
    }
    
    
}
