package TresEnters;
public class Triangle extends Figura
{
    private float a, b, c;
    
    public Triangle (float a, float b, float c) throws EntersException
    {
        this.setABC(a, b, c);
    }
        
    public float getA() { return this.a; }
    
    public float getB() { return this.b; }
    
    public float getC() { return this.c; }
   
    public void setA(float a) throws EntersException { this.setABC(a, getB(), getC()); }
    
    public void setB(float b) throws EntersException { this.setABC(getA(), b, getC()); }
    
    public void setC(float c) throws EntersException { this.setABC(getA(), getB(), c); }
    
    public void setABC(float a, float b, float c) throws EntersException
    {
        if (a <= 0) { throw new EntersException("El valor de A no pot ser negatiu o zero!"); }
        else { this.a = a; }
        if (b <= 0) { throw new EntersException("El valor de B no pot ser negatiu o zero!"); }
        else { this.b = b; }
        if (c <= 0) { throw new EntersException("El valor de C no pot ser negatiu o zero!"); }
        else { this.c = c; }
        if (!this.triangleValid(a, b, c)) { throw new EntersException("El triangle es impossible!"); }
    }

    public boolean triangleValid(float a, float b, float c)
    {
        //Aqui es tindria que calcular si el triangle es possible:
        boolean valid = true;
        
        return valid;
    }
    
    public float calcularArea()
    {
        float semiperimetre = (this.getA() + this.getB() + this.getC()) / 2;
        float area = (float)
                     Math.sqrt( 
                                semiperimetre *
                                (semiperimetre - this.getA()) *
                                (semiperimetre - this.getB()) *
                                (semiperimetre - this.getC())
                               );
        return area;
    }
    
    public float calcularPerimetre()
    {
        return this.getA() + this.getB() + this.getC();
    }
    
}
