package dosenters;

public class DosEnters
{
    protected int x, y;
    
    public DosEnters() throws EntersException
    {
        this(1, 2);
    }
    
    public DosEnters(int x) throws EntersException
    {
        this(x, 0);
    }
    
    public DosEnters(int x, int y) throws EntersException
    {
        this.setXY(x, y);
    }
    
    public int sumar() { return getX() + getY(); }
    
    public int restar() { return getX()-getY(); }
    
    public int multiplicar() { return getX()*getY(); }
    
    public int dividir()
    {
        try { return getX() / getY(); }
        catch (ArithmeticException e) { System.out.println(e.getMessage()); return 0; }
    }
    
    public int modul()
    {
        try { return getX() % getY(); }
        catch (ArithmeticException e) { System.out.println(e.getMessage()); return 0; }
    }
    
    public boolean iguals(DosEnters altre) { return (this.getX() == altre.getX() && this.getY() == altre.getY()); }
    
    public String esciure() { return "\nx = " + getX() + ", y = " + getY(); }
    
    public void setX(int x) throws EntersException { this.setXY(x, this.y); }

    public void setY(int y) throws EntersException { this.setXY(this.x, y); }
    
    public void setXY(int x, int y) throws EntersException
    {
        if (x < 0) { throw new EntersException("El valor de X no pot ser negatiu!"); }
        else { this.x = x; }
        if (y < 0) { throw new EntersException("El valor de Y no pot ser negatiu!"); }
        else { this.y = y; }
    }
    
    public int getX() { return x; }
    
    public int getY() { return y; }
}