package finalstrimestre;

import java.util.*;

public class Cataleg
{
    private Hashtable<String, Llibre> ColeccioLlibres = new Hashtable<String, Llibre>();
    
    public Cataleg()
    {
        
    }
    
    public Cataleg(Llibre llibre) throws MevaExcepcio
    {
        this.afegirLlibre(llibre);
    }
    
    public Cataleg(Cataleg coleccio) throws MevaExcepcio
    {
        this.afegirColeccio(coleccio);
    }
    
    public void afegirLlibre(Llibre llibre) throws MevaExcepcio
    {
        if (llibre == null) { throw new MevaExcepcio("El llibre apunta a null!"); }
        else if (this.enCataleg(llibre)) { throw new MevaExcepcio("El llibre ja existeix en la colleccio!"); }
        else //No fa falta el else.
        {
            this.ColeccioLlibres.put(llibre.getISBN(), llibre);
        }
    }

    public void afegirColeccio(Cataleg coleccio) throws MevaExcepcio //Es podria fer amb clone?
    {
        Llibre llibre;
        for (String ISBN : coleccio.ColeccioLlibres.keySet())
        {
            if (!this.enCataleg(ISBN))
            {
                llibre = coleccio.obtenirLlibre(ISBN);
                this.afegirLlibre(llibre);
            }
        }
    }
    
    public Llibre obtenirLlibre(String ISBN)
    {
        //Llibre llibre = null;
        
        return this.ColeccioLlibres.get(ISBN);
        //llibre = this.ColeccioLlibres.get(ISBN);
        
        //return llibre;
    }
    
    public boolean enCataleg(String ISBN)
    {
        boolean trobat = false;
        
        trobat = this.ColeccioLlibres.containsKey(ISBN); //this.ColeccioLlibres.containsValue(ISBN);
        
        return trobat;
    }
    
    public boolean enCataleg(Llibre llibre)
    {
        return enCataleg(llibre.getISBN());
    }
    
    public void mostraCataleg()
    {
        Llibre llibre;
        for (String ISBN : this.ColeccioLlibres.keySet())
        {
            llibre = this.obtenirLlibre(ISBN);
            System.out.println("[" + llibre.getISBN() + "] " + llibre.getTitol());
        }
    }
}
