package finalstrimestre;

public class Link
{
    private String text;
    private String URL;
    private boolean absolut = true; //Informacio addicional per saber si la ruta es absoluta o relativa.
    
    private Link() //No vull que es pugui instancia sense parametres.
    {
    }
    
    public Link(String text, String URL) throws MevaExcepcio
    {
        this.setText(text);
        this.setURL(URL);
    }

    public Link(String text, String URL, boolean absolut) throws MevaExcepcio
    {
        this.setText(text);
        this.setURL(URL);
        this.setAbsolut(absolut);
    }
    
    public void setText(String text) throws MevaExcepcio
    {
        if (text == null || text.trim() == "") { throw new MevaExcepcio("El text ha de contenir alguna cosa!"); }
        this.text = text;
    }
    
    public void setURL(String URL) throws MevaExcepcio
    {
        if (URL == null || URL.trim() == "") { throw new MevaExcepcio("L'URL ha de contenir alguna cosa!"); }
        this.URL = URL;
    }

    public void setAbsolut(boolean absolut)
    {
        this.absolut = absolut;
    }
    
    public String getText()
    {
        return this.text;
    }
    
    public String getURL()
    {
        return this.URL;
    }

    public boolean getAbsolut()
    {
        return this.absolut;
    }
    
    public String toString()
    {
        return "[" + this.getText() + "] => " + this.getURL();
    }
    
    public boolean equals(Object o)
    {
        if (o instanceof Link) { return (this.getURL() == ((Link)o).getURL()); } //No tindrem en conta si es absolut o relatiu.
        return false;
    }
}