package carretcompra;

public class ElementCarretCompra<ELEMENT extends Producte>
{
    private ELEMENT element;
    private int quantitat;
    
    public ElementCarretCompra(ELEMENT element) throws ExceptionECC
    {
        this.insertarElement(element, 1);
    }

    public ElementCarretCompra(ELEMENT element, int quantitat) throws ExceptionECC
    {
        this.insertarElement(element, quantitat);
    }

    private void insertarElement(ELEMENT element, int quantitat) throws ExceptionECC
    {
        this.setElement(element);
        this.setQuantitat(quantitat);
    }
    
    private void setElement(ELEMENT element) throws ExceptionECC
    {
        if (element != null)
        {
            this.element = element;
        }
        else { throw new ExceptionECC("L'element no pot ser null!"); }
    }
    
    public void setQuantitat(int quantitat) throws ExceptionECC
    {
        if (quantitat > 0)
        {
            this.quantitat = quantitat;
        }
        else { throw new ExceptionECC("La quantitat no pot ser igual o inferior a zero!"); }
    }

    public ELEMENT getElement()
    {
        return this.element;
    }
    
    public int getQuantitat()
    {
        return this.quantitat;
    }

    public float getPreu()
    {
        return this.getElement().getPreu();
    }

    public float getPreuTotal()
    {
        return this.getPreu() * this.getQuantitat();
    }
    
    public String getReferencia()
    {
        return this.getElement().getReferencia();
    }
    
    public void incrementaQuantitat() throws ExceptionECC
    {
        this.setQuantitat(this.getQuantitat() + 1);
    }
    
    public void decrementaQuantitat() throws ExceptionECC
    {
        this.setQuantitat(this.getQuantitat() - 1);
    }
   
    public void incrementaQuantitat(int increment) throws ExceptionECC
    {
        while (increment-- > 0)
        {
            this.incrementaQuantitat();
        }
    }
    
    public void decrementaQuantitat(int decrement) throws ExceptionECC
    {
        while (decrement-- > 0)
        {
            this.decrementaQuantitat();
        }
    }
 
    public String toString()
    {
        return "[" + this.getReferencia() + "] => " +
                this.getQuantitat() +
                " (" +
                    this.getPreu() + " x " + this.getQuantitat() + " = " +
                    this.getPreuTotal() +
                ")";
    }
    
    
}