/** 
* 
* @author Joan Alba Maldonado
*/ 


//NOTA: acordarse de poner un submenu para konfirmar si salir o no. Y el de opciones tambien.

package configuracion;

import javax.activation.MailcapCommandMap;
import javax.swing.MenuSelectionManager;
import logica.Menu;

public class Menus
{
    //Menu principal (si se modifica, debera modificarse procesarMenuPrincipal() del objeto Juego):
    private static final String[][] menuPrincipalOpciones = {
                                                               configuracion.Idiomas.iniciarJuego,
                                                               configuracion.Idiomas.opciones,
                                                               configuracion.Idiomas.finalizarJuego
                                                            };
    private static final String[] menuPrincipalValoresDevueltos = {
                                                                    "INICIAR",
                                                                    "OPCIONES",
                                                                    "FINALIZAR"
                                                                  };
    
    private static final int menuPrincipalLeft = 100;
    private static final int menuPrincipalTop = 212;
    private static Menu menuPrincipal = new Menu(menuPrincipalOpciones, menuPrincipalValoresDevueltos, configuracion.PaletaColores.getPaleta(), Menus.menuPrincipalLeft, Menus.menuPrincipalTop);

    private static final String[] textoAlternativoIniciar = { "Comena el joc", "Comienza el juego", "Starts the game" };
    private static final int[] textoAlternativoIniciarLeft = { 84, 85, 89 };
    private static final int[] textoAlternativoIniciarTop = { 185, 185, 185 };

    private static final String[] textoAlternativoOpciones = { "Modificar opcions", "Modificar opciones", "Change options" };
    private static final int[] textoAlternativoOpcionesLeft = { 82, 86, 92 };
    private static final int[] textoAlternativoOpcionesTop = { 185, 185, 185 };

    private static final String[] textoAlternativoFinalizar = { "Surt del joc", "Sale del juego", "Exit game" };
    private static final int[] textoAlternativoFinalizarLeft = { 95, 95, 105 };
    private static final int[] textoAlternativoFinalizarTop = { 185, 185, 185 };
   
    //Submenu del menu principal, para confirmar salir del juego (si se modifica, debera modificarse procesarMenuPrincipal() del objeto Juego):
    private static final String[][] menuPrincipalConfirmarSalirOpciones = {
                                                                            configuracion.Idiomas.confirmarSalir,
                                                                            configuracion.Idiomas.rechazarSalir
                                                                          };
    
    private static final String[] menuPrincipalConfirmarSalirValoresDevueltos = {
                                                                                    "FINALIZAR_SI",
                                                                                    "FINALIZAR_NO"
                                                                                };
    
    private static final int menuPrincipalConfirmarSalirLeft = Menus.menuPrincipalLeft;
    private static final int menuPrincipalConfirmarSalirTop = Menus.menuPrincipalTop;
    private static Menu menuPrincipalConfirmarSalir = new Menu(menuPrincipalConfirmarSalirOpciones, menuPrincipalConfirmarSalirValoresDevueltos, configuracion.PaletaColores.getPaleta(), Menus.menuPrincipalConfirmarSalirLeft, Menus.menuPrincipalConfirmarSalirTop);
    
    private static final String[] textoAlternativoFinalizarSi = { "Confirma sortir", "Confirmar salir", "Confirm exit" };
    private static final int[] textoAlternativoFinalizarSiLeft = { 84, 85, 89 };
    private static final int[] textoAlternativoFinalizarSiTop = { 185, 185, 185 };

    private static final String[] textoAlternativoFinalizarNo = { "Torna al menu", "Volver al menu", "Return to menu" };
    private static final int[] textoAlternativoFinalizarNoLeft = { 82, 86, 92 };
    private static final int[] textoAlternativoFinalizarNoTop = { 185, 185, 185 };
    
    //Texto fijo del menu:
    private static final String textoFijo = "TetrisDAI - http://tetrisdai.sourceforge.net\n                Joan Alba Maldonado";
    private static final int textoFijoLeft = 10;
    private static final int textoFijoTop = 405;
    
    //Logo del menu:
    private static final int[][] logo = {
                                            { 9, 9, 9, 0, 10, 10, 0 },
                                            { 0, 9, 0, 0, 10, 0, 10 },
                                            { 0, 9, 0, 0, 10, 0, 10 },
                                            { 0, 9, 0, 0, 10, 0, 10 },
                                            { 0, 9, 0, 0, 10, 10, 0 }
                                        };
    private static final byte leftLogo = 3;
    private static final byte topLogo = 1;
    
    //Dibujos de las opciones principales:
    private static final int[][][] dibujos = {
                                                {
                                                    { 9, 10, 8, 8, 8, 8, 8, 10, 9 },
                                                    { 10, 0, 0, 0, 0, 0, 0, 0, 10 },
                                                    { 8, 0, 0, 0, 0, 0, 0, 0, 8 },
                                                    { 8, 0, 0, 0, 0, 0, 0, 0, 8 },
                                                    { 8, 0, 0, 0, 0, 0, 0, 0, 8 },
                                                    { 8, 0, 0, 0, 0, 0, 0, 0, 8 },
                                                    { 8, 0, 0, 0, 0, 0, 0, 0, 8 },
                                                    { 8, 0, 0, 0, 0, 0, 0, 0, 8 },
                                                    { 10, 0, 0, 0, 0, 0, 0, 0, 10 },
                                                    { 9, 10, 8, 8, 8, 8, 8, 10, 9 }
                                                },
                                                {
                                                    { 10, 11, 9, 9, 9, 9, 9, 11, 10 },
                                                    { 11, 0, 0, 0, 0, 0, 0, 0, 11 },
                                                    { 9, 0, 0, 0, 0, 0, 0, 0, 9 },
                                                    { 9, 0, 0, 0, 0, 0, 0, 0, 9 },
                                                    { 9, 0, 0, 0, 0, 0, 0, 0, 9 },
                                                    { 9, 0, 0, 0, 0, 0, 0, 0, 9 },
                                                    { 9, 0, 0, 0, 0, 0, 0, 0, 9 },
                                                    { 9, 0, 0, 0, 0, 0, 0, 0, 9 },
                                                    { 11, 0, 0, 0, 0, 0, 0, 0, 11 },
                                                    { 10, 11, 9, 9, 9, 9, 9, 11, 10 }
                                                },
                                                {
                                                    { 12, 13, 11, 11, 11, 11, 11, 13, 12 },
                                                    { 13, 0, 0, 0, 0, 0, 0, 0, 13 },
                                                    { 11, 0, 0, 0, 0, 0, 0, 0, 11 },
                                                    { 11, 0, 0, 0, 0, 0, 0, 0, 11 },
                                                    { 11, 0, 0, 0, 0, 0, 0, 0, 11 },
                                                    { 11, 0, 0, 0, 0, 0, 0, 0, 11 },
                                                    { 11, 0, 0, 0, 0, 0, 0, 0, 11 },
                                                    { 11, 0, 0, 0, 0, 0, 0, 0, 11 },
                                                    { 13, 0, 0, 0, 0, 0, 0, 0, 13 },
                                                    { 12, 13, 11, 11, 11, 11, 11, 13, 12 }
                                                },
                                           };
    private static final byte[] leftDibujos = { 2, 2, 2 };
    private static final byte[] topDibujos = { 7, 7, 7 };
    
    private static final int[][][] dibujosConfirmarSalir = {
                                                            {
                                                                { 3, 2, 1, 1, 1, 1, 1, 4, 5 },
                                                                { 2, 0, 0, 0, 0, 0, 0, 0, 4 },
                                                                { 1, 0, 0, 0, 0, 0, 0, 0, 1 },
                                                                { 1, 0, 0, 0, 0, 0, 0, 0, 1 },
                                                                { 1, 0, 0, 0, 0, 0, 0, 0, 1 },
                                                                { 1, 0, 0, 0, 0, 0, 0, 0, 1 },
                                                                { 4, 0, 0, 0, 0, 0, 0, 0, 2 },
                                                                { 5, 4, 1, 1, 1, 1, 1, 2, 3 }
                                                            },
                                                            {
                                                                { 5, 4, 1, 1, 1, 1, 1, 2, 3 },
                                                                { 4, 0, 0, 0, 0, 0, 0, 0, 2 },
                                                                { 1, 0, 0, 0, 0, 0, 0, 0, 1 },
                                                                { 1, 0, 0, 0, 0, 0, 0, 0, 1 },
                                                                { 1, 0, 0, 0, 0, 0, 0, 0, 1 },
                                                                { 1, 0, 0, 0, 0, 0, 0, 0, 1 },
                                                                { 2, 0, 0, 0, 0, 0, 0, 0, 4 },
                                                                { 3, 2, 1, 1, 1, 1, 1, 4, 5 }
                                                            }
                                                           };
    private static final byte[] leftDibujosConfirmarSalir = { 2, 2 };
    private static final byte[] topDibujosConfirmarSalir = { 7, 7 };
    
    private Menus()
    {
    }
    
    static public Menu getMenuPrincipal()
    {
        //Pone el texto alternativo al menu principal:
        Menus.menuPrincipal.setTextoAlternativo(Menus.textoAlternativoIniciar, 0, Menus.textoAlternativoIniciarLeft, Menus.textoAlternativoIniciarTop);
        Menus.menuPrincipal.setTextoAlternativo(Menus.textoAlternativoOpciones, 1, Menus.textoAlternativoOpcionesLeft, Menus.textoAlternativoOpcionesTop);
        Menus.menuPrincipal.setTextoAlternativo(Menus.textoAlternativoFinalizar, 2, Menus.textoAlternativoFinalizarLeft, Menus.textoAlternativoFinalizarTop);
        
        //Pone el texto alternativo al submenu de confirmar salir:
        Menus.menuPrincipalConfirmarSalir.setTextoAlternativo(Menus.textoAlternativoFinalizarSi, 0, Menus.textoAlternativoFinalizarSiLeft, Menus.textoAlternativoFinalizarSiTop);
        Menus.menuPrincipalConfirmarSalir.setTextoAlternativo(Menus.textoAlternativoFinalizarNo, 1, Menus.textoAlternativoFinalizarNoLeft, Menus.textoAlternativoFinalizarNoTop);
        
        //Se agrega el submenu de confirmar salir al menu principal:
        Menus.menuPrincipal.agregarSubmenu(menuPrincipalConfirmarSalir, 2);
        
        //Se agrega el texto permamente (en los submenus tambien):
        Menus.menuPrincipal.setTextoFijo(Menus.textoFijo, Menus.textoFijoLeft, Menus.textoFijoTop);
        Menus.menuPrincipal.obtenerSubmenu(2).setTextoFijo(Menus.textoFijo, Menus.textoFijoLeft, Menus.textoFijoTop);
        
        //Se agrega el logo (en los submenus tambien):
        Menus.menuPrincipal.setLogo(Menus.logo, Menus.leftLogo, Menus.topLogo);
        Menus.menuPrincipal.obtenerSubmenu(2).setLogo(Menus.logo, Menus.leftLogo, Menus.topLogo);
        
        //Se agregan los dibujos (en los submenus tambien):
        Menus.menuPrincipal.setDibujos(Menus.dibujos, Menus.leftDibujos, Menus.topDibujos);
        Menus.menuPrincipal.obtenerSubmenu(2).setDibujos(Menus.dibujosConfirmarSalir, Menus.leftDibujosConfirmarSalir, Menus.topDibujosConfirmarSalir);
        
        return Menus.menuPrincipal;
    }
}
