/** 
* 
* @author Joan Alba Maldonado
*/ 

package logica;

/* Classe: Juego
 *
 * Propietats:
 *      protected int[] teclaArriba  <-- (son vectors per poder definir mes d'una tecla)
 *      protected int[] teclaAbajo
 *      protected int[] teclaDerecha
 *      protected int[] teclaIzquierda
 *      protected int[] teclaRotarDerecha
 *      protected int[] teclaRotarIzquierda
 *      protected int[] teclaAceptar
 *      Timer timerJuego
 *      protected JPanel contenedorGrafico
 *      protected Sonido motorSonido
 *      protected boolean sonidoActivado
 *      protected Panel panel
 *      protected Menu menuPrincipal
 *      protected Paleta paleta <-- poder cambiar paleta con setPaleta por si se kieren kambiar los kolores desde fuera.
 *      protected Pieza[] piezasBase
 *      protected int velocidad
 *      final protected int velocidadMinima
 *      final protected int velocidadMaxima
 *      final protected int incrementoVelocidad
 *      protected boolean juegoComenzado
 *      protected boolean juegoPausado
 *      protected int nivel
 *      protected int puntos
 *      protected int lineas
 *      protected Tablero tablero
 *      protected Pieza piezaActual
 *      protected Pieza piezaSiguiente
 *      protected boolean piezaColisionada
 *
 * Metodes:
 *      __constructor(JPanel contenedor)
 *      __constructor(JPanel contenedor, Paleta paleta)
 *      __constructor(JPanel contenedor, Paleta paleta, Pieza[] piezasBase)
 *      public void setContenedorGrafico(JPanel contenedor)
 *      public JPanel getContenedorGrafico()
 *      protected Sonido motorSonido
 *      public void setPaleta(Paleta paleta)
 *      public Paleta getPaleta()
 *      public Panel getPanel()
 *      public Panel getMenuPrincipal()
 *      public Tablero getTablero()
 *      public void setPiezasBase(Pieza[] piezasBase)
 *      public Pieza[] getPiezasBase()
 *      protected int numeroPiezasBase()
 *      public void definirTeclas(int[] teclaArriba, int[] teclaAbajo, int[] teclaDerecha, int[] teclaIzquierda, int[] teclaRotarDerecha, int[] teclaRotarIzquierda, int[] teclaAceptar)
 *      public void modificarDimensionesTablero(byte ancho, byte alto)
 *      public void setVelocidad(int velocidad)
 *      public int getVelocidad()
 *      protected void subirVelocidad()
 *      public void setNivel(int nivel)
 *      public int getNivel()
 *      protected void subirNivel()
 *      protected void setPuntos(int puntos)
 *      public int getPuntos()
 *      protected void sumarPuntos(int puntos)
 *      protected void setLineas(int lineas)
 *      public int getLineas()
 *      protected void setLineasNivel(int lineasNivel)
 *      public int getLineasNivel()
 *      protected void sumarLineas(int numeroLineas)
 *      protected void sumarLineasNivel(int numeroLineas)
 *      public int leerTeclado(KeyEvent evento)
 *      public void procesarTecla(int tecla)
 *      protected boolean teclaEnTeclas(int tecla, int teclas[])
 *      public boolean comprobarGameOver()
 *      public boolean getJuegoComenzado()
 *      public void restaurarValores()
 *      public void iniciarJuego()
 *      public void finalizarJuego()
 *      public void pausarJuego()
 *      public void reanudarJuego()
 *      public void reiniciarJuego()
 *      protected Pieza obtenerPieza()
 *      protected void sacarPieza()
 *      protected void cicloJuego()
 *      public void mostrarMenuPrincipal()
 *      public void ocultarMenuPrincipal()
 *      protected void actualizarPanel(JPanel contenedor);
 *      protected void representarTodo(JPanel contenedor)
 */

//Falta: en totes les classes, impedir ficar valors no possibles en els sets (valors negatius, etc).

//Preguntar si se puede en una clase abstracta poner constructores abstractos o al menos no abstractos.

//FALTA: en todos, pensar si poner un destructor (para piezas iria bien, a lo mejor).

//FALTA: poder hacer velocidadMinima, velocidadMaxima e incrementoVelocidad modificable desde fuera (necesitaran metodos get y set y no ser final). lo mismo para las konstantes  konstante de puntuacion segun linea(s).

//ACORDASE de utilizar el objeto de sonido en los sitios rekeridos.

//PROBLEMA: parace ser ke al hacer cancel() y purge() del timer no va (no se para el timer), hay que ponerlo a null i volver a instanciarlo. alguna solucion???

//FALTA: en constantes (i agregarlas al objeto Juego) varias konstantes de puntuacion segun el numero de lineas ke se hagan (teniendo en kuenta k las piezas son editables i es posible hacer mas de 4 lineas), o bien una para saber kuantos puntos vale una linea (ia ke las piezas son editables i no se puede asegurar ke el maximo de lineas hechas sean 4).

//SUGERENCIA: kiza un limitador de tiempo para no poder llamar a procesarTecla() muchas veces seguidas en un tiempo determinado.

//POSIBILIDAD: un nuevo objeto llamado Menu kon el menu del juego, i ponerlo komp propiedad en el objeto Juego. O una superklase padre llamada Menu i un MenuPrincipal herandola, i komo propiedad en el objeto Juego ponerla. Asi tambien se puede hacer un objeto MenuGameOver, etc. (opcion Reintentar, Salir)

//PENSAR: poner toString sobreescrito, que represente el juego con la pieza actual y todo, en modo texto klaro xd

//FALTA: si se esta jugando y se aprieta ESCAPE (definir tekla para salir/mostrar menu), pausar el juego i sakar el menu kon la opcion kontinuar (o uno nuevo kon la opcion de kontinuar o de volver al menu principal).

//FALTA: una opcion de guardar partida i otra de salvar partida. kiza la de salvar podria ser iniciarJuego(datos), i ke esta llamara a iniciarJuego() i luego a cargarDatos(datos), donde datos pueden ser ma de un parametro o un archivo o lo k sea (pensarlo).

//FALTA: ranking kon mejores puntuaciones, offline (i si fuera online, kiza en una web o algo los mejores).

import configuracion.*; //Utiliza el archivo de configuracion del juego.

import principal.Main;

import java.awt.Color;

import java.awt.Graphics; //import java.awt.Graphics;
import java.awt.event.*;

import java.util.Timer;
//import java.util.TimerTask;
//import javax.swing.Timer;
//import java.awt.event.ActionListener;

import java.util.Random;

//import java.awt.image.BufferedImage;

public class Juego
{
    protected int[] teclaArriba = configuracion.Teclas.getTeclaArriba(); //Tecla(s) para ir arriba (en Tetris no se puede, pero por si hubiera algun menu).
    protected int[] teclaAbajo = configuracion.Teclas.getTeclaAbajo(); //Tecla(s) para ir abajo.
    protected int[] teclaDerecha = configuracion.Teclas.getTeclaDerecha(); //Tecla(s) para ir a la derecha.
    protected int[] teclaIzquierda = configuracion.Teclas.getTeclaIzquierda(); //Tecla(s) para ir a la izquierda.
    protected int[] teclaRotarDerecha = configuracion.Teclas.getTeclaRotarDerecha(); //Tecla(s) para rotar a la derecha.
    protected int[] teclaRotarIzquierda = configuracion.Teclas.getTeclaRotarIzquierda(); //Tecla(s) para rotar a la derecha.
    protected int[] teclaAceptar = configuracion.Teclas.getTeclaAceptar(); //Tecla(s) para aceptar.

    Timer timerJuego = null; //Timer que llama a cicloJuego() (equivalente a setInterval de otros lenguajes).
    
    protected Graphics contenedorGrafico; //Contenedor grafico donde se representara todo el juego.
    
    protected Sonido motorSonido = new Sonido(); //Manejador de sonido.
    
    protected boolean sonidoActivado = configuracion.Otros.getSonidoActivado(); //Define si se reproducen sonidos o no.
    
    protected Panel panel = null; //Panel donde va la puntuacion, ficha siguiente, etc.
    
    protected Menu menuPrincipal = null; //Menu principal del juego.
    
    protected Paleta paleta; //<- no instanciar?? //Paleta que utiliza el juego.
    
    protected Pieza[] piezasBase; //Vector con las piezas base.
            
    protected int velocidad = configuracion.Otros.getVelocidadInicial(); //Retraso entre ciclos, en milisegundos (numero menor = mas rapido).
    final protected int velocidadMinima = configuracion.Otros.getVelocidadMinima(); //Velocidad minima posible (numero menor = mas rapido).
    final protected int velocidadMaxima = configuracion.Otros.getVelocidadMaxima(); //Velocidad maxima posible (numero menor = mas rapido).
    final protected int incrementoVelocidad = configuracion.Otros.getIncrementoVelocidad(); //Incremento de la velocidad cuando esta sube (si es negativo, la velocidad sube).
    
    protected boolean juegoComenzado = false; //Define si el juego ha comenzado o no.
    protected boolean juegoPausado = false; //Define si el juego esta en pausa o no.

    protected int nivel; //Numero de nivel.
    
    protected int puntos; //Puntuacion.
    
    protected int lineas; //Lineas hechas.
    protected int lineasNivel; //Lineas hechas en el nivel actual.
    final protected int lineasNecesariasNivel = configuracion.Otros.getLineasNecesariasNivel(); //Lineas necesarias para pasar de nivel.
    
    protected Tablero tablero; //Tablero del juego.
    
    protected Pieza piezaActual; //Ficha actual que controla el jugador.
    protected Pieza piezaSiguiente; //Ficha que va a venir luego.
    
    protected boolean piezaColisionada; //Define si la pieza ha colisionado en el ciclo anterior.
    
    //Constructor que recibe el contenedor del juego:
    public Juego(Graphics contenedor)
    {
        this(contenedor, null, null);
    }
    
    //Constructor que recibe el contenedor y la paleta del juego:
    public Juego(Graphics contenedor, Paleta paleta)
    {
        this(contenedor, paleta, null); //Pondra como piezas base las definidas en la configuracion.
    }
    
    //Constructor que recibe el contenedor, la paleta y las piezas base del juego:
    public Juego(Graphics contenedor, Paleta paleta, Pieza[] piezasBase)
    {
        this.setContenedorGrafico(contenedor);
        //Si no se ha enviado una paleta, pone la definida en la configuracion:
        if (paleta == null)
        {
            paleta = configuracion.PaletaColores.getPaleta();
        }
        this.setPaleta(paleta);
        //Si no se ha enviado piezas base, pone las definidas en la configuracion:
        if (piezasBase == null)
        {
            piezasBase = configuracion.Piezas.getPiezas(this.getPaleta());
        }
        this.setPiezasBase(piezasBase);
        
        //Crea el tablero con el alto y ancho definidos en la configuracion:
        byte alto = configuracion.Otros.getTableroAlto();
        byte ancho = configuracion.Otros.getTableroAncho();
        this.tablero = new Tablero(ancho, alto, this.getPaleta());
        
        //Instancia el panel:
        this.panel = new Panel(this.getPiezasBase(), this.getPaleta(), this.getTablero());
        
        //Instancia el menu principal:
        this.menuPrincipal = configuracion.Menus.getMenuPrincipal();
        this.menuPrincipal.setPaleta(this.getPaleta());
    }
    
    public void setContenedorGrafico(Graphics contenedor)
    {
        this.contenedorGrafico = contenedor;
    }
    
    public Graphics getContenedorGrafico()
    {
        return this.contenedorGrafico;
    }
    
    public void setPaleta(Paleta paleta)
    {
        this.paleta = paleta;
        if (this.getPanel() != null)
        {
            this.panel.setPaleta(paleta);
        }
        if (this.getMenuPrincipal() != null)
        {
            this.menuPrincipal.setPaleta(paleta);
        }
    }
    
    public Paleta getPaleta()
    {
        return this.paleta;
    }
    
    public Panel getPanel()
    {
        return this.panel;
    }

    public Menu getMenuPrincipal()
    {
        return this.menuPrincipal;
    }
    
    public Tablero getTablero()
    {
        return this.tablero;
    }
    
    public void setPiezasBase(Pieza[] piezasBase)
    {
        this.piezasBase = piezasBase;
        if (this.getPanel() != null)
        {
            this.panel.setPiezasBase(piezasBase);
        }
    }
    
    protected int numeroPiezasBase()
    {
        return this.getPiezasBase().length;
    }
    
    public Pieza[] getPiezasBase()
    {
        return this.piezasBase;
    }

    public void setSonidoActivado(boolean sonidoActivado)
    {
        this.sonidoActivado = sonidoActivado;
    }
    
    public boolean getSonidoActivado()
    {
        return this.sonidoActivado;
    }
    
    //Desactiva el sonido:
    public void desactivarSonido()
    {
        this.setSonidoActivado(false);
    }
    
    //Activa el sonido:
    public void activarSonido()
    {
        this.setSonidoActivado(true);
    }
    
    //Alterna el sonido (lo activa o desactiva):
    public void alternarSonido()
    {
        if (this.getSonidoActivado())
        {
            this.desactivarSonido();
        }
        else { this.activarSonido(); }
    }
    
    //Define las teclas de funcionamiento:
    public void definirTeclas(int[] teclaArriba, int[] teclaAbajo, int[] teclaDerecha, int[] teclaIzquierda, int[] teclaRotarDerecha, int[] teclaRotarIzquierda, int[] teclaAceptar)
    {
        this.teclaArriba = teclaArriba;
        this.teclaAbajo = teclaAbajo;
        this.teclaDerecha = teclaDerecha;
        this.teclaIzquierda = teclaIzquierda;
        this.teclaRotarDerecha = teclaRotarDerecha;
        this.teclaRotarIzquierda = teclaRotarIzquierda;
        this.teclaAceptar = teclaAceptar;
    }
    
    //Modifica la dimension del tablero:
    public void modificarDimensionesTablero(byte ancho, byte alto)
    {
        this.getTablero().setAncho(ancho);
        this.getTablero().setAlto(alto);
        
        //Actualiza visualmente el tablero:
        //this.getContenedorGrafico().setWidth = ;
        
        this.getPanel().setTablero(this.getTablero());
        
        //Vuelve a dimensionar la ventana principal del juego:
        Main.redimensionarVentana(); //Quiza se deba comentar esto si se utiliza un Applet.
    }
    
    public void setVelocidad(int velocidad)
    {
        if (velocidad >= this.velocidadMinima && velocidad <= this.velocidadMaxima)
        {
            this.velocidad = velocidad;
        }
        //Si la velocidad enviada supera la maxima, podria ponerse a la maxima.
        //Si la velocidad enviada es menor que la minima, podria ponerse la minima.
    }
 
    public int getVelocidad()
    {
        return this.velocidad;
    }
    
    protected void subirVelocidad()
    {
        this.setVelocidad(this.getVelocidad() + this.incrementoVelocidad);
        //Si el juego ha comenzado, inicia el ciclo con la nueva velocidad:
        if (this.juegoComenzado)
        {
            this.timerJuego.cancel();
            this.timerJuego.purge();
            this.timerJuego = null; //Si no pongo esto, peta al llamr a scheduleAtFixedRate() abajo (?).
            this.timerJuego = new Timer();
            TimerJuego tarea = new TimerJuego(this);
            this.timerJuego.scheduleAtFixedRate(tarea, 0, this.getVelocidad());
        }
    }
    
    public void setNivel(int nivel)
    {
        this.nivel = nivel;
        this.getPanel().setNivel(nivel);
    }
    
    public int getNivel()
    {
        return this.nivel;
    }
    
    protected void subirNivel()
    {
        this.setNivel(this.getNivel() + 1);
        //Sube la velocidad tambien (podria hacerse que solo lo hiciera cada X niveles, o en los pares):
        this.subirVelocidad();
    }
    
    protected void setPuntos(int puntos)
    {
        //Permitiremos numeros negativos por si se quisiera hacer un juego con magias o penalizaciones que restaran puntos:
        this.puntos = puntos;
        this.getPanel().setPuntos(this.getPuntos());
    }
    
    public int getPuntos()
    {
        return this.puntos;
    }
    
    protected void sumarPuntos(int puntos)
    {
        this.setPuntos(this.getPuntos() + puntos);
    }
    
    protected void setLineas(int lineas)
    {
        if (lineas >= 0)
        {
            this.lineas = lineas;
            this.getPanel().setLineas(lineas);
        }
    }
    
    public int getLineas()
    {
        return this.lineas;
    }

    protected void setLineasNivel(int lineasNivel)
    {
        if (lineasNivel >= 0)
        {
            this.lineasNivel = lineasNivel;
            this.getPanel().setLineasNivel(lineasNivel);
        }
    }
    
    public int getLineasNivel()
    {
        return this.lineasNivel;
    }
    
    protected void sumarLineas(int numeroLineas)
    {
        //Se permiten mas de 5 porque pueden haber piezas personalizadas:
        if (numeroLineas > 0)
        {
            this.setLineas(this.getLineas() + numeroLineas);
        }
    }

    protected void sumarLineasNivel(int numeroLineas)
    {
        //Se permiten mas de 5 porque pueden haber piezas personalizadas:
        if (numeroLineas > 0)
        {
            this.setLineasNivel(this.getLineasNivel() + numeroLineas);
        }
    }
    
    //Retorna la tecla que se ha apretado (si se ha apretado alguna):
    public int leerTeclado(KeyEvent evento)
    {
        //PENSAR: si retornar null si no se pulsa nada o como hacerlo.
        return 0; //CAMBIAR!!!
    }
 
    //Realiza una accion dependiendo de una tecla dada:
    public void procesarTecla(int tecla)
    {
        //Nota: Dejar entrar aunke el juego haya terminado, por si keremos movernos en algun menu futuro.
        //Nota: No pongo else para permitir que una tecla pueda hacer mas de una funcion.

                //System.out.println("Kodigo de la tekla: " + tecla);
        
        if (this.teclaEnTeclas(tecla, this.teclaAceptar))
        {
            //System.out.println("ACEPTARRRRRRRRRRRRRRRRRRRR");
            //Si el menu principal existe y esta activo:
            if (this.getMenuPrincipal() != null)
            {
                if (this.getMenuPrincipal().getMostrar())
                {
                    //System.out.println("SE HA ACEPTAO NEEEEEEEEEEEEENGK");
                    this.getMenuPrincipal().aceptarOpcionActual();
                    this.procesarMenuPrincipal();
                }
            }
        }
        if (this.teclaEnTeclas(tecla, this.teclaArriba))
        {
            //Si el menu principal existe y esta activo:
            if (this.getMenuPrincipal() != null)
            {
                if (this.getMenuPrincipal().getMostrar())
                {
                    //Sube una opcion del menu:
                    this.getMenuPrincipal().subirOpcion();
                    //Representa el menu, si se debe hacer (y todo lo demas, para que se repinte todo bien):
                    if (this.menuPrincipal.getMostrar()) { this.representarTodo(this.getContenedorGrafico()); } //this.menuPrincipal.dibujar(this.getContenedorGrafico()); }
                }
            }
        }
        if (this.teclaEnTeclas(tecla, this.teclaAbajo))
        {
            if (this.getJuegoComenzado())
            {
                if (this.piezaActual != null) { this.piezaActual.moverAbajo(this.getTablero()); }
            }
            //Si el menu principal existe y esta activo:
            if (this.getMenuPrincipal() != null)
            {
                if (this.getMenuPrincipal().getMostrar())
                {
                    //Sube una opcion del menu:
                    this.getMenuPrincipal().bajarOpcion();
                    //Representa el menu, si se debe hacer (y todo lo demas, para que se repinte todo bien):
                    if (this.menuPrincipal.getMostrar()) { this.representarTodo(this.getContenedorGrafico()); } //this.menuPrincipal.dibujar(this.getContenedorGrafico()); }
                }
            }
        }
        if (this.teclaEnTeclas(tecla, this.teclaDerecha))
        {
            if (this.getJuegoComenzado())
            {
                if (this.piezaActual != null) { this.piezaActual.moverDerecha(this.getTablero()); }
            }
        }
        if (this.teclaEnTeclas(tecla, this.teclaIzquierda))
        {
            if (this.getJuegoComenzado())
            {
                if (this.piezaActual != null) { this.piezaActual.moverIzquierda(this.getTablero()); }
            }
        }
        if (this.teclaEnTeclas(tecla, this.teclaRotarDerecha))
        {
            if (this.getJuegoComenzado())
            {
                if (this.piezaActual != null) { this.piezaActual.rotarDerecha(this.getTablero()); }
            }
        }
        if (this.teclaEnTeclas(tecla, this.teclaRotarIzquierda))
        {
            if (this.getJuegoComenzado())
            {
                if (this.piezaActual != null) { this.piezaActual.rotarIzquierda(this.getTablero()); }
            }
        }
        //else { if (this.getJuegoComenzado()) { if (this.piezaActual != null) { this.piezaActual.moverIzquierda(this.getTablero()); } } }
    }

    
    //Procesa la opcion seleccionada del menu principal:
    protected void procesarMenuPrincipal()
    {
        //Si el menu esta existe, esta activo y la opcion ha sido seleccionada: 
        if (this.getMenuPrincipal() != null)
        {
            if (this.getMenuPrincipal().getMostrar() && this.getMenuPrincipal().getOpcionAceptada())
            {
                String opcionSeleccionada = this.getMenuPrincipal().getOpcionActualValor();
                
                //Si se ha escogido iniciar el juego:
                if (opcionSeleccionada.toUpperCase().equals("INICIAR"))
                {
                    //Si no se ha comenzado, comienza el juego:
                    if (!this.getJuegoComenzado()) { this.ocultarMenuPrincipal(); this.iniciarJuego(); }
                    //...si no, lo reinicia:
                    else { this.ocultarMenuPrincipal(); this.reiniciarJuego(); }
                }
                //...o si se escogido opciones:
                else if (opcionSeleccionada.toUpperCase().equals("OPCIONES"))
                {
                    //No hace nada, ya se encargara el menu de entrar en el submenu.
                }
                //...o si se ha escogido salir:
                else if (opcionSeleccionada.toUpperCase().equals("FINALIZAR"))
                {
                    //No hace nada, ya se encargara el menu de entrar en el submenu.
                }
                //...o si se ha escogido confirmar salir:
                else if (opcionSeleccionada.toUpperCase().equals("FINALIZAR_SI"))
                {
                    //System.out.println("DENTRO DE FINALIZAR_SI");
                    //Si se ha aceptado la opcion, procede:
                    if (this.getMenuPrincipal().getOpcionAceptadaSubmenu())
                    {
                        //System.out.println("Se ha escogido finalizar");
                        //Si no ha acabado el juego, lo acaba (en realidad es una tonteria):
                        if (this.getJuegoComenzado()) { this.finalizarJuego(); }
                        //Sale del programa:
                        System.exit(0);
                    }
                }
                //...o si se ha escogido no salir (volver al menu principal):
                else if (opcionSeleccionada.toUpperCase().equals("FINALIZAR_NO"))
                {
                    //System.out.println("DENTRO DE FINALIZAR_NO");
                    //Si se ha aceptado la opcion, procede:
                    if (this.getMenuPrincipal().getOpcionAceptadaSubmenu())
                    {
                        //System.out.println("Se ha escogido volver");
                        //Oculta el submenu:
                        //this.getMenuPrincipal().obtenerSubmenu(this.getMenuPrincipal().getOpcionActualIndice()).setMostrar(true);
                        
                        
                        //Sale del submenu:
                        this.getMenuPrincipal().cancelarOpcionActual();
                    }
                }
                //System.out.println("LA OPCION AKTUAL ES: " + opcionSeleccionada);
            }
        }
    }
    
    
    //Devuelve si una tecla esta en el vector de teclas enviado o no:
    protected boolean teclaEnTeclas(int tecla, int teclas[])
    {
        boolean encontrada = false;
        for (int x = 0; x < teclas.length; x++)
        {
            if (teclas[x] == tecla)
            {
                encontrada = true;
                break;
            }
        }
        return encontrada;
    }
    
    //Comprueba si se ha perdido el juego o no:
    public boolean comprobarGameOver() //ACORDARSE: del GameOver que esta en gui.
    {
        //Si se ha perdido, finalizar juego y acordarse del GameOver.
        return true; //CAMBIAR!!!
    }
 
    //Devuelve si el juego ha comenzado o no:
    public boolean getJuegoComenzado()
    {
        return this.juegoComenzado;
    }
    
    //Restaura el valor de las propiedades del objeto:
    public void restaurarValores()
    {
        //Vacia el tablero, por si acaso:
        this.getTablero().vaciar();
        
        //"Resetea" las pieza actual y siguiente, por si acaso:
        this.piezaActual = null;
        this.piezaSiguiente = null;
        
        //Define que ninguna pieza ha colisionado en ningun ciclo anterior:
        this.piezaColisionada = false;

        //Pone el nivel al primero:
        this.setNivel(0);
        
        //Vuelve la puntuacion a cero:
        this.setPuntos(0);
        
        //Pone el numero de lineas hechas a cero:
        this.setLineas(0);
        
        //Pone el numero de lineas hechas en el nivel a cero:
        this.setLineasNivel(0);
    }
    
    //Inicia el juego:
    public void iniciarJuego()
    {
        //Si el juego ya ha comenzado, sale de la funcion:
        if (this.getJuegoComenzado()) { return; }

        //Define como que ya ha comenzado el juego:
        this.juegoComenzado = true;

        //Restaura el valor de las propiedades:
        this.restaurarValores();
        
        //Representa el tablero antes de que comience el ciclo (para que visualmente no haya un retraso inicial):
        //this.tablero.dibujar(this.getContenedorGrafico());
                
        //Comienza los ciclos:
        TimerJuego tarea = new TimerJuego(this);
        this.timerJuego = new Timer();
        this.timerJuego.scheduleAtFixedRate(tarea, 0, this.getVelocidad());
    }
    
    //Finaliza el juego:
    public void finalizarJuego()
    {
        //Si el juego no habia comenzado, sale de la funcion:
        if (!this.juegoComenzado) { return; }
        
        //Define como que no ha comenzado el juego:
        this.juegoComenzado = false;
        
        //Acaba los ciclos, si existe el timer (deberia existir xD):
        if (this.timerJuego != null)
        {
            this.timerJuego.cancel();
            this.timerJuego.purge();
            this.timerJuego = null;
        }
    }
    
    //Pausa el juego:
    public void pausarJuego()
    {
        if (this.getJuegoComenzado())
        {
            this.juegoPausado = true;
        }
    }
    
    //Reanuda el juego (quita la pausa):
    public void reanudarJuego()
    {
        this.juegoPausado = false;
    }
    
    //Reinicia el juego:
    public void reiniciarJuego()
    {
        this.finalizarJuego();
        this.iniciarJuego();
    }
  
    //Retorna una pieza aleatoria de entre las piezas base posibles:
    protected Pieza obtenerPieza()
    {
        int indiceAleatorio = new Random().nextInt(this.getPiezasBase().length);
        return this.getPiezasBase()[indiceAleatorio];
    }
    
    //Introduce una pieza en el juego (la que el usuario va a controlar):
    protected void sacarPieza()
    {
        //Si es la primera, la saca aleatoriamente y define una siguiente:
        if (this.piezaSiguiente == null)
        {
            Pieza piezaAleatoria = this.obtenerPieza();
        
            int[][] piezaForma = piezaAleatoria.getForma();
            byte piezaAncho = piezaAleatoria.getAncho();
            byte piezaPosicionHorizontal = (byte) (this.getTablero().getAncho() / 2 - piezaAncho / 2);
        
            this.piezaActual = new Pieza(piezaForma, this.getPaleta(), piezaPosicionHorizontal);
            
            this.piezaSiguiente = this.obtenerPieza();
        }
        //...pero si no, saca la que habia en siguiente y escoge otra siguiente:
        else
        {
            int[][] piezaForma = piezaSiguiente.getForma();
            byte piezaAncho = piezaSiguiente.getAncho();
            byte piezaPosicionHorizontal = (byte) (this.getTablero().getAncho() / 2 - piezaAncho / 2);
            
            this.piezaActual = new Pieza(piezaForma, this.getPaleta(), piezaPosicionHorizontal);
            
            //this.piezaActual = this.piezaSiguiente;
            this.piezaSiguiente = this.obtenerPieza();
        }
    
        //Inserta la pieza siguiente en el panel y lo representa:
        this.getPanel().insertarPieza(this.piezaSiguiente);
        this.actualizarPanel(this.getContenedorGrafico());
    }
    
    //Hace el ciclo del juego (contiene toda la logica):
    protected void cicloJuego()
    {
        //System.out.println("cicloJuego() ejecutado");
        
        //Si el juego esta en pausa, no hace el ciclo:
        if (this.juegoPausado) { return; }
        //...o si el juego no ha comenzado, no hace el ciclo:
        if (!this.getJuegoComenzado()) { return; }
        else //else innecesario.
        {
            //Si la pieza colisiono la anterior vez:
            if (this.piezaColisionada)
            {
                //Si continua habiendo colision en la nueva posicion, se agrega al tablero:
                if (piezaActual.calcularColision(this.getTablero()))
                {
                    this.sumarPuntos(configuracion.Otros.getPuntosPorPiezaPuesta());
                    
                    //System.out.println("LA PIEZA CONTINUA COLISIONANDO");
                    this.piezaColisionada = false;
                
                    this.getTablero().agregarPieza(piezaActual);
                
                    this.piezaActual = null;
                
                    //Representa el tablero:
                    this.getTablero().dibujar(this.getContenedorGrafico());
                    
                    //Calcula si se ha hecho linea:
                    int lineasHechas = this.getTablero().procesarLineas();
                    if (lineasHechas > 0)
                    {
                        this.sumarLineas(lineasHechas);
                        this.sumarLineasNivel(lineasHechas);
                        this.sumarPuntos(lineasHechas * configuracion.Otros.getPuntosPorLinea());
                        //Pasar los niveles que sean necesarios, segun las lineas hechas en el nivel actual:
                        while (this.getLineasNivel() >= this.lineasNecesariasNivel)
                        {
                            this.setLineasNivel(this.getLineasNivel() - this.lineasNecesariasNivel);
                            this.subirNivel();
                        }
                    }
                    
                    //Calcula si se ha perdido:
                    if (this.getTablero().estaLleno())
                    {
                        //FALTA: Notificar del fin del juego!!!
                        
                        this.reiniciarJuego(); //PRUEBA!!!
                    }
                }
                //...pero si ya no colisiona, se deja otra oportunidad la siguiente vez (para que tampoco se solidifique a la primera):
                else
                {
                    this.piezaColisionada = false;
                } 
                //else { System.out.println("LA PIEZA HA DEJADO DE COLISIONAR"); }
            }
            
            //Si no hay pieza actual, saca una:
            if (this.piezaActual == null) { this.sacarPieza(); }
            
            //FALTA: continuar haciendo ciclo.
            
            //PRUEBA:
            //if (this.piezaActual == null) { this.sacarPieza(); }
            
            //Representa todo:
            //this.representarTodo(this.getContenedorGrafico()); //BORRAR ESTA LINEA!!!
            //Representa la ficha:
            //this.piezaActual = this.obtenerPieza();
            
            //if (1==1)return;
            //POR QUE APARECE LA FICHA EN LA POSICION 1 EN LUGAR DE EN LA 0 SI SE MUEVE ABAJO DESPUES DE REPRESENTARLA???????????????

            //Representa la pieza y el tablero:
            //this.getTablero().dibujar(this.getContenedorGrafico()); //Para que borre donde la pieza haya estado antes.
            //if (this.piezaActual != null) { this.piezaActual.dibujar(this.getContenedorGrafico()); }
            //this.actualizarPanel(this.getContenedorGrafico());
            //if (this.menuPrincipal.getMostrar()) { this.menuPrincipal.dibujar(this.getContenedorGrafico()); } //Se muestra el menu principal si asi se debe hacer.
            this.representarTodo(this.getContenedorGrafico());

            //Si la pieza ha colisionado, lo indica para el proximo ciclo:
            if (piezaActual.calcularColision(this.getTablero()))
            {
                this.piezaColisionada = true;
                //System.out.println("LA PIEZA HA COLISIONAO");
            }
            //...pero si no:
            else
            {
                //Hace caer la pieza:
                piezaActual.moverAbajo(this.getTablero());
            }
        }
    }

    //Muestra el menu principal:
    public void mostrarMenuPrincipal()
    {
        //Nota: Dejare mostrar el meni principal aun con el juego comenzado.
        this.menuPrincipal.setMostrar(true);
        this.menuPrincipal.dibujar(this.getContenedorGrafico());
    }
    
    //Oculta el menu principal:
    public void ocultarMenuPrincipal()
    {
        //Nota: Dejare mostrar el meni principal aun con el juego comenzado.
        this.menuPrincipal.setMostrar(false);
    }
    
    //Actualiza el panel con la puntuacion, la pieza siguiente, etc:
    protected void actualizarPanel(Graphics contenedor)
    {
        //PENSAR: si hacer un objeto solo para el Panel y si ponerlo en GUI o en logica o en ambos una clase diferente o donde.
        
        //Usar el metodo dibujar de piezaSiguiente!!!
        
        //System.out.println("Llamada a actualizarPanel()...");
        
        this.getPanel().dibujar(contenedor);
    }
    
    //Dibuja el juego (tablero, pieza y panel):
    protected void representarTodo(Graphics contenedor)
    {
        //BufferedImage imagenBuffer = new BufferedImage(Main.ventanaPrincipal.getPanelJuego().getWidth(), Main.ventanaPrincipal.getPanelJuego().getHeight(), BufferedImage.TYPE_4BYTE_ABGR_PRE);
        
        //Dibuja el tablero:
        this.getTablero().dibujar(contenedor);
        //this.getTablero().dibujar2(imagenBuffer);
        
        //Dibuja la pieza:
        if (this.piezaActual != null) { this.piezaActual.dibujar(contenedor); }
        //this.piezaActual.dibujar2(imagenBuffer);
        
        //Actualiza el panel:
        this.actualizarPanel(contenedor);
        //this.actualizarPanel2(imagenBuffer);

        //Si el menu principal debe mostrarse, se muestra:
        if (this.menuPrincipal.getMostrar()) { this.menuPrincipal.dibujar(contenedor); }
    }
}
