/** 
* 
* @author Joan Alba Maldonado
*/ 


//NOTA: acordarse de poner un submenu para konfirmar si salir o no. Y el de opciones tambien.

package configuracion;

import javax.activation.MailcapCommandMap;
import logica.Menu;

public class Menus
{
    //Menu principal (si se modifica, debera modificarse procesarMenuPrincipal() del objeto Juego):
    private static final String[][] menuPrincipalOpciones = {
                                                               configuracion.Idiomas.iniciarJuego,
                                                               configuracion.Idiomas.opciones,
                                                               configuracion.Idiomas.finalizarJuego
                                                            };
    private static final String[] menuPrincipalValoresDevueltos = {
                                                                    "INICIAR",
                                                                    "OPCIONES",
                                                                    "FINALIZAR"
                                                                  };
    
    private static Menu menuPrincipal = new Menu(menuPrincipalOpciones, menuPrincipalValoresDevueltos, configuracion.PaletaColores.getPaleta(), 100, 200);

    private static final String[] textoAlternativoIniciar = { "Comena el joc", "Comienza el juego", "Starts the game" };
    private static final int[] textoAlternativoIniciarLeft = { 84, 85, 89 };
    private static final int[] textoAlternativoIniciarTop = { 160, 160, 160 };

    private static final String[] textoAlternativoOpciones = { "Modificar opcions", "Modificar opciones", "Change options" };
    private static final int[] textoAlternativoOpcionesLeft = { 82, 86, 92 };
    private static final int[] textoAlternativoOpcionesTop = { 160, 160, 160 };

    private static final String[] textoAlternativoFinalizar = { "Surt del joc", "Sale del juego", "Exit game" };
    private static final int[] textoAlternativoFinalizarLeft = { 95, 95, 105 };
    private static final int[] textoAlternativoFinalizarTop = { 160, 160, 160 };
   
    //Submenu del menu principal, para confirmar salir del juego (si se modifica, debera modificarse procesarMenuPrincipal() del objeto Juego):
    private static final String[][] menuPrincipalConfirmarSalirOpciones = {
                                                                            configuracion.Idiomas.confirmarSalir,
                                                                            configuracion.Idiomas.rechazarSalir
                                                                          };
    
    private static final String[] menuPrincipalConfirmarSalirValoresDevueltos = {
                                                                                    "FINALIZAR_SI",
                                                                                    "FINALIZAR_NO"
                                                                                };
    
    private static Menu menuPrincipalConfirmarSalir = new Menu(menuPrincipalConfirmarSalirOpciones, menuPrincipalConfirmarSalirValoresDevueltos, configuracion.PaletaColores.getPaleta(), 100, 200);
    
    private static final String[] textoAlternativoFinalizarSi = { "Confirma sortir", "Confirmar salir", "Confirm exit" };
    private static final int[] textoAlternativoFinalizarSiLeft = { 84, 85, 89 };
    private static final int[] textoAlternativoFinalizarSiTop = { 160, 160, 160 };

    private static final String[] textoAlternativoFinalizarNo = { "Torna al menu", "Volver al menu", "Return to menu" };
    private static final int[] textoAlternativoFinalizarNoLeft = { 82, 86, 92 };
    private static final int[] textoAlternativoFinalizarNoTop = { 160, 160, 160 };
    
    private Menus()
    {
    }
    
    static public Menu getMenuPrincipal()
    {
        //Pone el texto alternativo al menu principal:
        Menus.menuPrincipal.setTextoAlternativo(Menus.textoAlternativoIniciar, 0, Menus.textoAlternativoIniciarLeft, Menus.textoAlternativoIniciarTop);
        Menus.menuPrincipal.setTextoAlternativo(Menus.textoAlternativoOpciones, 1, Menus.textoAlternativoOpcionesLeft, Menus.textoAlternativoOpcionesTop);
        Menus.menuPrincipal.setTextoAlternativo(Menus.textoAlternativoFinalizar, 2, Menus.textoAlternativoFinalizarLeft, Menus.textoAlternativoFinalizarTop);
        
        //Pone el texto alternativo al submenu de confirmar salir:
        Menus.menuPrincipalConfirmarSalir.setTextoAlternativo(Menus.textoAlternativoFinalizarSi, 0, Menus.textoAlternativoFinalizarSiLeft, Menus.textoAlternativoFinalizarSiTop);
        Menus.menuPrincipalConfirmarSalir.setTextoAlternativo(Menus.textoAlternativoFinalizarNo, 1, Menus.textoAlternativoFinalizarNoLeft, Menus.textoAlternativoFinalizarNoTop);
        
        //Se agrega el submenu de confirmar salir al menu principal:
        Menus.menuPrincipal.agregarSubmenu(menuPrincipalConfirmarSalir, 2);
        
        return Menus.menuPrincipal;
    }
}
