/** 
* 
* @author Joan Alba Maldonado
*/ 

package logica;

//El constructor es un metode???

/* Classe: Pieza
 *
 * Propietats:
 *      protected byte ancho
 *      protected byte alto
 *      protected byte left
 *      protected byte top
 *      protected int[][] forma  <--(matriu de numeros, cada numero un color).
 *      protected Paleta paleta
 *      protected final int VACIO;
 *
 * Metodes:
 *      __constructor(int[][] forma, Paleta paleta)
 *      __constructor(int[][] forma, Paleta paleta, byte left)
 *      __constructor(int[][] forma, Paleta paleta, byte left, byte top)
 *      protected void setForma(int[][] forma)
 *      public int[][] getForma()
 *      protected void setPaleta(Paleta paleta)
 *      public Paleta getPaleta()
 *      protected void setAncho(byte ancho)
 *      public byte getAncho()
 *      public byte calcularAncho(int[][] forma)
 *      protected void setAlto(byte alto)
 *      public byte getAlto()
 *      protected void setLeft(byte left)
 *      public byte getLeft()
 *      protected void setTop(byte top)
 *      public byte getTop()
 *      public void moverIzquierda()
 *      public void moverDerecha()
 *      public void moverAbajo()
 *      public void mover(byte left, byte top)
 *      protected boolean calcularColision(Tablero tablero)
 *      public void rotarIzquierda()
 *      public void rotarDerecha()
 *      public void cabePieza(Tablero tablero)
 *      public void dibujar(Graphics contenedor)
 */

//Falta: en totes les classes, impedir ficar valors no possibles en els sets (valors negatius, etc).

//ACORDARSE: se han kambiado Graphics por JPanel (falta kambiar arriba en komentarios)

//import java.awt.Color;
import javax.swing.JPanel;
import java.awt.Graphics;

import gui.MotorGrafico;
//import principal.Main;//PRUEBA!!!

public class Pieza
{
    protected byte ancho = 0; //Ancho de la pieza.
    protected byte alto = 0; //Alto de la pieza.

    protected byte left = 0; //Posicion horizontal de la pieza (en el tablero).
    protected byte top = 0; //Posicion vertical de la pieza (en el tablero).
    
    protected int[][] forma = new int[alto][ancho]; //<- no instanciar?? //Forma de la pieza (numero = color).
    
    protected Paleta paleta; //<- no instanciar?? //Paleta que utiliza la pieza.
    //ficar un atribut Tablero per a no pasar-lo sempre als metodes de moure, calcularColision, etc.?

    protected final int VACIO = configuracion.Otros.getNumeroVacio(); //Numero que nos marca un vacio (no hay pieza).
    
    //Constructor que recibe la forma y la paleta de la pieza:
    public Pieza(int[][] forma, Paleta paleta)
    {
        this(forma, paleta, (byte) 0, (byte) 0); //Posiciona la pieza en el punto (0, 0).
    }

    //Constructor que recibe la forma, la paleta de la pieza y la posicion horizontal de la pieza:
    public Pieza(int[][] forma, Paleta paleta, byte left)
    {
        this(forma, paleta, left, (byte) (forma.length * -1)); //Posiciona la pieza en el punto (left, topNegativo).
    }
    
    //Constructor que recibe la forma, la paleta y la posicion de la pieza:
    public Pieza(int[][] forma, Paleta paleta, byte left, byte top)
    {
        this.setForma(forma);
        this.setPaleta(paleta);
        this.setLeft(left);
        this.setTop(top);
    }
    
    protected void setForma(int[][] forma)
    {
        this.forma = forma;
        this.setAncho((byte) this.calcularAncho(this.getForma())); //this.setAncho((byte) this.getForma()[0].length);
        this.setAlto((byte) this.getForma().length);
        
        //Rellena con ceros la forma, por si no era rectangular:
        int[][] formaRectangular = new int[this.getAlto()][this.getAncho()];
        for (byte f = 0; f < this.getAlto(); f++)
        {
            for (byte c = 0; c < this.getAncho(); c++)
            {
                if (f < this.getForma().length && c < this.getForma()[f].length)
                {
                    formaRectangular[f][c] = forma[f][c];
                }
                else { formaRectangular[f][c] = 0; }
            }
        }
        this.forma = formaRectangular;
    }
    
    public int[][] getForma()
    {
        return this.forma;
    }

    protected void setPaleta(Paleta paleta)
    {
        this.paleta = paleta;
    }
    
    public Paleta getPaleta()
    {
        return this.paleta;
    }
    
    protected void setAncho(byte ancho)
    {
        this.ancho = ancho;
    }
    
    public byte getAncho()
    {
        return this.ancho;
    }
    
    //Calcula el ancho maximo de una pieza dada:
    public byte calcularAncho(int[][] forma)
    {
        byte ancho = (byte) forma[0].length;
        
        for (byte f = 0; f < forma.length; f++)
        {
            if (forma[f].length > ancho) { ancho = (byte) forma[f].length; }
        }
        
        return ancho;
    }
    
    protected void setAlto(byte alto)
    {
        this.alto = alto;
    }
    
    public byte getAlto()
    {
        return this.alto;
    }

    protected void setLeft(byte left)
    {
        this.left = left;
    }
    
    public byte getLeft()
    {
        return this.left;
    }
    
    protected void setTop(byte top)
    {
        this.top = top;
    }
    
    public byte getTop()
    {
        return this.top;
    }
    
    //Mueve a la izquierda la pieza (decrementa su left):
    public void moverIzquierda(Tablero tablero)
    {
        this.mover(tablero, (byte) (this.getLeft() - 1), this.getTop());
    }
    
    //Mueve a la derecha la pieza (incrementa su left):
    public void moverDerecha(Tablero tablero)
    {
        this.mover(tablero, (byte) (this.getLeft() + 1), this.getTop());
    }

    //Mueve abajo la pieza (incrementa su top):
    public void moverAbajo(Tablero tablero)
    {
        this.mover(tablero, this.getLeft(), (byte) (this.getTop() + 1));
    }
    
    //Mueve la pieza a una posicion del mapa pasada por parametro:
    public void mover(Tablero tablero, byte left, byte top)
    {
        //Si la pieza cabe en la posicion enviada, se inserta:
        if (this.cabePieza(tablero, left, top))
        {
            this.setLeft(left);
            this.setTop(top);
        }
    }
    
    //Calcula si la pieza ha colisionado:
    protected boolean calcularColision(Tablero tablero)
    {
        boolean colision = false;
        
        //Si la pieza ya no esta en una posicion correcta, hay colision:
        if (!this.cabePieza(tablero)) { colision = true; }
        //...o si la pieza al bajar estuviera en una posicion incorrecta, tambien hay colision:
        else if (!this.cabePieza(tablero, this.getLeft(), (byte) (this.getTop() + 1))) { colision = true; } //<-- y si se mueve a un lado antes de que baje??? bueno, el cicloJuego() ya permite mover una vez antes de solidificarse (y vuelve a comprobar la colision, por si se ha movido).
        //...o si ha llegado al fondo (suelo), tambien hay colision:
        else if (this.getTop() + this.getAlto() >= tablero.getAlto()) { colision = true; }
        
        return colision;
    }

    //Rota la pieza a la izquierda:
    public void rotarIzquierda(Tablero tablero)
    {
        //ACORDARSE: de comprobar con cabePieza() y si no, ir probando a desplazarla hacia las cuatro direcciones posibles.
    }
    
    //Rota a la derecha la pieza:
    public void rotarDerecha(Tablero tablero)
    {
        //ACORDARSE: de comprobar con cabePieza() y si no, ir probando a desplazarla hacia las cuatro direcciones posibles.
    }

    //Calcula si la pieza esta en una posicion correcta en su posicion actual:
    public boolean cabePieza(Tablero tablero)
    {
        return this.cabePieza(tablero, this.getLeft(), this.getTop());
    }

    //Calcula si la pieza estaria posicionada correctamente en una posicion dada:
    public boolean cabePieza(Tablero tablero, byte left, byte top)
    {
        boolean cabe = true;
        
        byte fPieza = 0, cPieza;
        
        for (byte f = top; f < top + this.getAlto(); f++, fPieza++)
        {
            cPieza = 0;
            for (byte c = left; c < left + this.getAncho(); c++, cPieza++)
            {
                //Solo tiene en cuenta si en la pieza no hay un cero (cero = vacio):
                if (this.getForma()[fPieza][cPieza] != this.VACIO)
                {
                    //Si la pieza esta demasiado arriba, no cabe:
                    if (f < 0) { /*cabe = false;*/ } //Dejo el if sin nada, para que en el ultimo else if al entrar se asegure de que f >= 0 (no sea f < 0).
                    //...o si la pieza esta demasiado abajo, no cabe:
                    else if (f >= tablero.getAlto()) { cabe = false; }
                    //...o si la pieza esta demasiado a la izquierda, no cabe:
                    else if (c < 0) { cabe = false; }
                    //...o si la pieza esta demasiado a la derecha, no cabe:
                    else if (c >= tablero.getAncho()) { cabe = false; }
                    //...o si la pieza se pone encima de las ya puestas, no cabe:
                    else if (tablero.getMapa()[f][c] != tablero.VACIO) //else if (f > 0 && c > 0 && tablero.getMapa()[f][c] != tablero.VACIO)
                    {
                        cabe = false;
                    }
                    if (!cabe) { break; }
                }
            }
            if (!cabe) { break; }
        }

        return cabe;
    }
    
    //Dibuja la pieza:
    public void dibujar(JPanel contenedor)
    {
        //PRUEBAS:
        //Main.ventanaPrincipal.paint(contenedor); 
        //Main.ventanaPrincipal.repaint(); 
        //Main.ventanaPrincipal.paint(Main.ventanaPrincipal.getGraphics()); 
        
        //System.out.println("kkkkkkkkkkkk");
        Graphics g = contenedor.getGraphics();
        //g.setColor(java.awt.Color.GREEN);
        //g.fillRect(1, 1, 200, 200);
        //contenedor.repaint();
        //contenedor.paint(g);
        //contenedor.update(g);
        MotorGrafico.dibujarPieza(g, this);
        
        //this.paint(contenedor);
        
        //contenedor.setColor(java.awt.Color.BLUE);
        //contenedor.drawRect(20, 20, 2000, 2000);
    }

    /*
    public void paint(Graphics contenedor)
    {
        contenedor.setColor(java.awt.Color.GREEN);
        contenedor.fillRect(1, 1, 200, 200);
    }
    */
}