/** 
* 
* @author Joan Alba Maldonado
*/ 

package gui;

import java.awt.Graphics;
import java.awt.Color;

import logica.*;

//import gui.TetrisForm; //BORRAR!!!

//ACORDARSE de kitar todos los imports de Graphics en los demas sitios!!!

//IMPORTANTE: hacer un sistema ke guarda la pieza anterior dibujada (un objeto pieza mejor, para saber su left i top), i tambien el mapa anterior. Y al repintar, solo kambiar lo necesario.

//SUGERENCIA: ke lo de dibujar celdas tenga un parametro para definir si pintar o no las celdas vacias (en configuracion estan definidos los vacios). Asi las piezas no pintarian negro.

public class MotorGrafico
{
    //static public int[][] mapaJuego; //BORRAR!!!
    //static public int[][] mapaPanel; //BORRAR!!!
    
    //Grafico que guarda lo que hay en pantalla:
    static protected int[][] graficoBackup = new int[Byte.MAX_VALUE][Byte.MAX_VALUE]; //Se pone lo maximo que puede ocupar un dato de tipo byte, para que nunca se quede corto.
    
    static protected boolean graficoInicializado = false; //Define si el grafico de backup ha sido inicializado (si el tablero ha sido dibujado alguna vez).
    
    static protected final int numeroCodificacionPiezas = configuracion.Otros.getNumeroCodificacionPiezas();
    
    static protected byte celdaAncho = configuracion.Aspecto.getCeldaAncho();
    static protected byte celdaAlto = configuracion.Aspecto.getCeldaAlto();
    
    static protected final int VACIO = configuracion.Otros.getNumeroVacio(); //Numero que nos marca un vacio.
    
    private MotorGrafico()
    {
    }

    static public void setCeldaAncho(byte celdaAncho)
    {
        MotorGrafico.celdaAncho = celdaAncho;
    }
    
    static public byte getCeldaAncho()
    {
        return MotorGrafico.celdaAncho;
    }

    static public void setCeldaAlto(byte celdaAlto)
    {
        MotorGrafico.celdaAlto = celdaAlto;
    }
    
    static public byte getCeldaAlto()
    {
        return MotorGrafico.celdaAlto;
    }
    
    //Dibuja un tablero, una pieza o el panel:
    static public void dibujar(Graphics g, Object objeto)
    {
        //if (objeto == null) { return; }
        if (objeto instanceof Pieza) { dibujarPieza(g, (Pieza) objeto); }
        else if (objeto instanceof Tablero) { dibujarTablero(g, (Tablero) objeto); }
        else if (objeto instanceof Panel) { dibujarPanel(g, (Panel) objeto); }
    }

    //Dibuja una pieza:
    static public void dibujarPieza(Graphics g, Pieza pieza)
    {
        Paleta paleta = pieza.getPaleta();
        byte x = pieza.getLeft();
        byte y = pieza.getTop();
        byte ancho = pieza.getAncho();
        byte alto = pieza.getAlto();
        int[][] matriz = pieza.getForma();
        
        MotorGrafico.dibujarMatriz(g, paleta, matriz, x, y, ancho, alto, false);
    }
    
    //Dibuja un tablero:
    static public void dibujarTablero(Graphics g, Tablero tablero)
    {
        //Si el tablero no ha sido dibujado antes, pone todo el grafico backup a -1 (para asegurarse de que se pinte):
        if (!MotorGrafico.graficoInicializado) { inicializarGraficoBackup(); MotorGrafico.graficoInicializado = true; }
        
        Paleta paleta = tablero.getPaleta();
        byte x = 0;
        byte y = 0;
        byte ancho = tablero.getAncho();
        byte alto = tablero.getAlto();
        int[][] matriz = tablero.getMapa();

        MotorGrafico.dibujarMatriz(g, paleta, matriz, x, y, ancho, alto, true);
    }
    
    //Dibuja un panel:
    static public void dibujarPanel(Graphics g, Panel panel)
    {
        Paleta paleta = panel.getPaleta();
        byte x = panel.getLeft();
        byte y = panel.getTop();
        byte ancho = panel.getAncho();
        byte alto = panel.getAlto();
        int[][] matriz = panel.getMapa();
        
        MotorGrafico.dibujarMatriz(g, paleta, matriz, x, y, ancho, alto, true);
        
        //Muestra tambien la informacion del panel:
        dibujarPanelInformacion(g, panel);
    }
    
    //Dibuja la informacion del panel:
    static protected void dibujarPanelInformacion(Graphics g, Panel panel)
    {
        int nivel = panel.getNivel();
        int puntos = panel.getPuntos();
        int lineas = panel.getLineas();
        int lineasNivel = panel.getLineasNivel();
        
        int x = panel.getLeft() * MotorGrafico.getCeldaAncho();
        int y = (panel.getTop() + panel.getAlto() + panel.getMargen()) * MotorGrafico.getCeldaAlto();
 
        //Borra el texto anterior, por si quedaba en pantalla:
        g.clearRect(x, y - MotorGrafico.getCeldaAlto(), 400, 400);
        
        //Pone el texto:
        Color colorTexto = panel.getPaleta().getColor(panel.getColorTexto());
        g.setColor(colorTexto);
        g.drawString("Nivel: " + nivel, x, y); y += MotorGrafico.getCeldaAlto();
        g.drawString("Puntos: " + puntos, x, y); y += MotorGrafico.getCeldaAlto();
        g.drawString("Lineas totales: " + lineas, x, y); y += MotorGrafico.getCeldaAlto(); 
        g.drawString("Lineas nivel: " + lineasNivel, x, y); y += MotorGrafico.getCeldaAlto();
    }
    
    //Dibuja una matriz en una posicion inicial dada:
    static public void dibujarMatriz(Graphics g, Paleta paleta, int[][] matriz, byte left, byte top, byte ancho, byte alto, boolean dibujarVacios)
    {
        int indiceColor;
        byte x, y = top;
        for (byte f = 0; f < alto; f++)
        {
            x = left;
            for (byte c = 0; c < ancho; c++)
            {
                indiceColor = matriz[f][c];

                //Si es un vacio y se ha enviado no dibujarlos, pasa de loop:
                if (indiceColor == MotorGrafico.VACIO && !dibujarVacios) { x++; continue; }

                //System.out.print(indiceColor);//BORRAR!!!
                MotorGrafico.dibujarCasilla(g, paleta, indiceColor, x, y);
                x++;
                
                //MotorGrafico.mapaJuego[x][y] = indiceColor; //BORRAR!!!
            }
            y++;
            //System.out.println("");
        }
        //System.out.println("");System.out.println("");System.out.println("");System.out.println("");
    }
    
    //Dibuja una casilla en una posicion dada:
    static protected void dibujarCasilla(Graphics g, Paleta paleta, int indiceColor, byte x, byte y)
    {
        //Si se ha enviado la x o la y negativas, sale de la funcion:
        if (x < 0 || y < 0) { return; }
        
        //Decodifica el color, si hace falta:
        if (indiceColor < 0) { indiceColor /= MotorGrafico.numeroCodificacionPiezas; }
        
        //Si la casilla que se va a pintar es igual a la que ya hay, no la pinta:
        //if (MotorGrafico.graficoBackup[x][y] == indiceColor) { return; } //<-- parece ser ke no va porke el metodo paint lo borra todo y deja el background!!!
        //else { MotorGrafico.actualizarGraficoBackup(indiceColor, x, y); } //Actualiza el grafico backup, para la proxima vez.
        MotorGrafico.actualizarGraficoBackup(indiceColor, x, y);

        //Pone el color que corresponde:
        Color color = paleta.getColor(indiceColor);
        g.setColor(color);
        //System.out.print(indiceColor + " ");
        //Coge el alto y ancho de la casilla definidos en la configuracion:
        int xReal = x * MotorGrafico.getCeldaAncho();
        int yReal = y * MotorGrafico.getCeldaAlto();
        g.fillRect(xReal, yReal, MotorGrafico.getCeldaAncho(), MotorGrafico.getCeldaAlto());
    }
    
    //Actualiza el grafico backup:
    static protected void actualizarGraficoBackup(int indiceColor, byte x, byte y)
    {
        //Si la casilla es diferente a la que habia antes, la guarda:
        if (MotorGrafico.graficoBackup[x][y] != indiceColor)
        {
            MotorGrafico.graficoBackup[x][y] = indiceColor;
        }
    }
    
    //Inicializa ("vacia") el grafico backup:
    static protected void inicializarGraficoBackup()
    {
        for (byte f = 0; f < MotorGrafico.graficoBackup.length; f++)
        {
            for (byte c = 0; c < MotorGrafico.graficoBackup[0].length; c++)
            {
                MotorGrafico.graficoBackup[f][c] = -1;
            }
        }
    }
}
