package logica;

/* Classe: Tablero
 *
 * Propietats:
 *      protected byte ancho
 *      protected byte alto
 *      protected int[][] mapa
 *      protected Paleta paleta
 *      public final int VACIO;
 *      private final int numeroCodificacionPiezas
 *
 * Metodes:
 *      __constructor(byte ancho, byte alto, Paleta paleta)
 *      protected void setAncho(byte ancho)
 *      public byte getAncho()
 *      protected void setAlto(byte alto)
 *      public byte getAlto() 
 *      public void vaciar()
 *      protected void setPaleta(Paleta paleta)
 *      protected Paleta getPaleta()
 *      public boolean estaLLeno()
 *      public byte procesarLineas()
 *      protected boolean hayLinea(byte fila)
 *      protected boolean lineaVacia(byte fila)
 *      protected void borrarLinea(byte fila)
 *      protected void bajarPiezas()
 *      protected void copiarFila(byte fOrigen, byte fDestino)
 *      public void agregarPieza(Pieza pieza, byte left, byte top) //<- pensar si fa falta la y (top)
 *      public void agregarPieza(Pieza pieza)
 *      public boolean cabePieza(Pieza pieza, byte left, byte top)
 *      public boolean cabePieza(Pieza pieza)
 *      public int[][] getMapa()
 *      public void dibujar(Graphics contenedor)
 */

//Falta: en totes les classes, impedir ficar valors no possibles en els sets (valors negatius, etc).

//import java.awt.Color;
import java.awt.Graphics;

public class Tablero
{
    protected byte ancho; //Ancho del tablero (mapa).
    protected byte alto; //Alto del tablero (mapa).
    
    protected int[][] mapa; //Mapa del tablero.
    
    protected Paleta paleta; //<- no instanciar?? //Paleta que utiliza la pieza.
    
    public final int VACIO = 0; //Numero que nos marca un vacio (no hay pieza).
    
    private final int numeroCodificacionPiezas = -1; //Numero por el que se multiplica cada numero que compone una pieza para insertar el resultado de la operacion en el tablero como piezas ya puestas.
    
    //Constructor que recibe el ancho, alto y la paleta del tablero:
    public Tablero(byte ancho, byte alto, Paleta paleta)
    {
        this.vaciar();
        this.setAncho(ancho);
        this.setAlto(alto);
        this.setPaleta(paleta);
    }

    public byte getAncho()
    {
        //this.mapa = new int[this.getAlto()][this.getAncho()];
        return this.ancho;
    }
    
    protected void setAncho(byte ancho)
    {
        //this.mapa = new int[this.getAlto()][this.getAncho()];
        this.ancho = ancho;
    }
    
    public byte getAlto()
    {
        return this.alto;
    }
    
    protected void setAlto(byte alto)
    {
        this.alto = alto;
    }
    
    //Vacia todo el tablero:
    public void vaciar()
    {
        //Borra todas las lineas del mapa:
        for (byte f = 0; f < this.getAlto(); f++)
        {
            this.borrarLinea(f);
        }
    }

    protected void setPaleta(Paleta paleta)
    {
        this.paleta = paleta;
    }

    protected Paleta getPaleta()
    {
        return this.paleta;
    }
    
    //Devuelve si el tablero esta lleno o no:
    public boolean estaLleno()
    {
        //Si hay alguna celda ocupada en la ultima fila, se asume lleno:
        boolean lleno = false;
        for (byte c = 0; c < this.getAncho(); c++)
        {
            if (this.getMapa()[0][c] != this.VACIO) { lleno = true; }
        }
        return lleno;
    }
    
    //Calcula si hay lineas y las procesa si es asi (retorna las lineas hechas):
    public byte procesarLineas()
    {
        byte numeroLineas = 0;
        
        //Busca las lineas y si hay, las borra:
        for (byte f = 0; f < this.getAlto(); f++)
        {
            if (this.hayLinea(f))
            {
                numeroLineas++;
                this.borrarLinea(f);
            }
        }
        
        //Si han habido lineas, hace caer las piezas:
        if (numeroLineas > 0) { this.bajarPiezas(); }
        
        return numeroLineas;
    }
    
    //Devuelve si hay linea o no en una fila determinada:
    protected boolean hayLinea(byte fila)
    {
        boolean hayLinea = true;
        for (byte c = 0; c < this.getAncho(); c++)
        {
            if (this.getMapa()[fila][c] == this.VACIO) { hayLinea = false; break; }
        }
        return hayLinea;
    }
    
    //Borra una linea del tablero:
    protected void borrarLinea(byte fila)
    {
        for (byte c = 0; c < this.getAncho(); c++)
        {
            this.getMapa()[fila][c] = this.VACIO;
            //this.mapa[fila][c] = this.VACIO;
        }
    }
    
    //Devuelve si una linea esta vacia o no:
    protected boolean lineaVacia(byte fila)
    {
        boolean vacia = true;
        for (byte c = 0; c < this.getAncho(); c++)
        {
            if (this.getMapa()[fila][c] != this.VACIO) { vacia = false; break; }
        }
        return vacia;
    }
    
    //Hace bajar las piezas por gravedad:
    protected void bajarPiezas()
    {
        for (byte f = 1; f < this.getAlto(); f++) //Comienza por la segunda linea (la primera no tiene superiores).
        {
            //Si la linea esta vacia:
            if (this.lineaVacia(f))
            {
                //Recorre las lineas superiores (hasta llegar a la primera):
                for (byte fSuperior = (byte)(f - 1); fSuperior >= 0; fSuperior--)
                {
                    //Si la linea superior esta vacia, sale del bucle (porque las siguientes ya habran caido anteriormente):
                    if (this.lineaVacia(fSuperior)) { break; }
                    //...pero si no, pasa el contenido de la linea superior a la de abajo:
                    else { this.copiarFila(fSuperior, (byte) (fSuperior + 1)); } //else innecesario.
                }
            }
        }
    }
    
    //Copia el contenido de una fila en otra:
    protected void copiarFila(byte fOrigen, byte fDestino)
    {
        for (byte c = 0; c < this.getAncho(); c++)
        {
            this.getMapa()[fDestino][c] = this.getMapa()[fOrigen][c];
            //this.mapa[fDestino][c] = this.getMapa()[fOrigen][c];
        }
    }
    
    //Agrega una pieza al tablero en la posicion dada:
    public void agregarPieza(Pieza pieza, byte left, byte top) //<- pensar si fa falta la y (top)
    {
        //Si la pieza cabe, la agrega:
        if (this.cabePieza(pieza, left, top))
        {
            byte fPieza = 0, cPieza;
            for (byte f = top; f < top + pieza.getAlto(); f++, fPieza++)
            {
                cPieza = 0;
                for (byte c = left; c < left + pieza.getAncho(); c++, cPieza++)
                {
                    //Agrega la pieza codificandola (para saber que esta puesta):
                    this.getMapa()[f][c] = pieza.getForma()[fPieza][cPieza] * this.numeroCodificacionPiezas;
                    //this.mapa[f][c] = pieza.getForma()[fPieza][cPieza] * this.numeroCodificacionPiezas;
                }
            }
        }
    }

    //Agrega una pieza al tablero (usando el left y top de la pieza):
    public void agregarPieza(Pieza pieza)
    {
        this.agregarPieza(pieza, pieza.getLeft(), pieza.getTop());
    }
    
    //Retorna si una pieza cabe en el tablero en una posicion dada:
    public boolean cabePieza(Pieza pieza, byte left, byte top)
    {
        return pieza.cabePieza(this, left, top);
    }
    
    //Retorna si una pieza cabe en el tablero (usando el left y top de la pieza):
    public boolean cabePieza(Pieza pieza)
    {
        return this.cabePieza(pieza, pieza.getLeft(), pieza.getTop());
    }
    
    public int[][] getMapa()
    {
        return this.mapa;
    }
    
    //Dibuja el tablero:
    public void dibujar(Graphics contenedor)
    {
        //TENER EN CUENTA que hay que descodificar las piezas puestas dividiendo por el numero de codificacion!!!
    }
}