/** 
* 
* @author Joan Alba Maldonado
*/ 

package gui;

import java.awt.Graphics;
import java.awt.Color;

import logica.*;

//import gui.TetrisForm; //BORRAR!!!

//ACORDARSE de kitar todos los imports de Graphics en los demas sitios!!!

//IMPORTANTE: hacer un sistema ke guarda la pieza anterior dibujada (un objeto pieza mejor, para saber su left i top), i tambien el mapa anterior. Y al repintar, solo kambiar lo necesario.

public class MotorGrafico
{
    //static public int[][] mapaJuego; //BORRAR!!!
    //static public int[][] mapaPanel; //BORRAR!!!
    
    //Grafico que guarda lo que hay en pantalla:
    static protected int[][] graficoBackup = new int[Byte.MAX_VALUE][Byte.MAX_VALUE]; //Se pone lo maximo que puede ocupar un dato de tipo byte, para que nunca se quede corto.
    
    static protected boolean graficoInicializado = false; //Define si el grafico de backup ha sido inicializado (si el tablero ha sido dibujado alguna vez).
    
    static protected final int numeroCodificacionPiezas = configuracion.Otros.getNumeroCodificacionPiezas();
    
    private MotorGrafico()
    {
    }
    
    //Dibuja un tablero, una pieza o el panel:
    static public void dibujar(Graphics g, Object objeto)
    {
        //if (objeto == null) { return; }
        if (objeto instanceof Pieza) { dibujarPieza(g, (Pieza) objeto); }
        else if (objeto instanceof Tablero) { dibujarTablero(g, (Tablero) objeto); }
        else if (objeto instanceof Juego) { dibujarPanel(g, (Juego) objeto); }
    }

    //Dibuja una pieza:
    static public void dibujarPieza(Graphics g, Pieza pieza)
    {
        Paleta paleta = pieza.getPaleta();
        byte x = pieza.getLeft();
        byte y = pieza.getTop();
        byte ancho = pieza.getAncho();
        byte alto = pieza.getAlto();
        int[][] matriz = pieza.getForma();
        
        MotorGrafico.dibujarMatriz(g, paleta, matriz, x, y, ancho, alto);
    }
    
    //Dibuja un tablero:
    static public void dibujarTablero(Graphics g, Tablero tablero)
    {
        //Si el tablero no ha sido dibujado antes, pone todo el grafico backup a -1 (para asegurarse de que se pinte):
        if (!MotorGrafico.graficoInicializado) { inicializarGraficoBackup(); MotorGrafico.graficoInicializado = true; }
        
        Paleta paleta = tablero.getPaleta();
        byte x = 0;
        byte y = 0;
        byte ancho = tablero.getAncho();
        byte alto = tablero.getAlto();
        int[][] matriz = tablero.getMapa();

        MotorGrafico.dibujarMatriz(g, paleta, matriz, x, y, ancho, alto);
    }
    
    //Dibuja un panel:
    static public void dibujarPanel(Graphics g, Juego juego)
    {
        //La paleta la koge del objeto juego.
    }
    
    //Dibuja una matriz en una posicion inicial dada:
    static public void dibujarMatriz(Graphics g, Paleta paleta, int[][] matriz, byte left, byte top, byte ancho, byte alto)
    {
        int indiceColor;
        byte x, y = top;
        for (byte f = 0; f < alto; f++)
        {
            x = left;
            for (byte c = 0; c < ancho; c++)
            {
                indiceColor = matriz[f][c];
                //System.out.print(indiceColor);//BORRAR!!!
                MotorGrafico.dibujarCasilla(g, paleta, indiceColor, x, y);
                x++;
                //MotorGrafico.mapaJuego[x][y] = indiceColor; //BORRAR!!!
            }
            y++;
            //System.out.println("");
        }
        //System.out.println("");System.out.println("");System.out.println("");System.out.println("");
    }
    
    //Dibuja una casilla en una posicion dada:
    static protected void dibujarCasilla(Graphics g, Paleta paleta, int indiceColor, byte x, byte y)
    {
        //Si se ha enviado la x o la y negativas, sale de la funcion:
        if (x < 0 || y < 0) { return; }
        
        //Decodifica el color, si hace falta:
        if (indiceColor < 0) { indiceColor /= MotorGrafico.numeroCodificacionPiezas; }
        
        //Si la casilla que se va a pintar es igual a la que ya hay, no la pinta:
        //if (MotorGrafico.graficoBackup[x][y] == indiceColor) { return; } //<-- parece ser ke no va porke el metodo paint lo borra todo y deja el background!!!
        //else { MotorGrafico.actualizarGraficoBackup(indiceColor, x, y); } //Actualiza el grafico backup, para la proxima vez.
        MotorGrafico.actualizarGraficoBackup(indiceColor, x, y);

        //Pone el color que corresponde:
        Color color = paleta.getColor(indiceColor);
        g.setColor(color);
        //System.out.print(indiceColor + " ");
        //Coge el alto y ancho de la casilla definidos en la configuracion:
        int xReal = x * configuracion.Aspecto.getCeldaAncho();
        int yReal = y * configuracion.Aspecto.getCeldaAlto();
        g.fillRect(xReal, yReal, configuracion.Aspecto.getCeldaAncho(), configuracion.Aspecto.getCeldaAlto());
    }
    
    //Actualiza el grafico backup:
    static protected void actualizarGraficoBackup(int indiceColor, byte x, byte y)
    {
        //Si la casilla es diferente a la que habia antes, la guarda:
        if (MotorGrafico.graficoBackup[x][y] != indiceColor)
        {
            MotorGrafico.graficoBackup[x][y] = indiceColor;
        }
    }
    
    //Inicializa ("vacia") el grafico backup:
    static protected void inicializarGraficoBackup()
    {
        for (byte f = 0; f < MotorGrafico.graficoBackup.length; f++)
        {
            for (byte c = 0; c < MotorGrafico.graficoBackup[0].length; c++)
            {
                MotorGrafico.graficoBackup[f][c] = -1;
            }
        }
    }
}
