package tetrisdai;

/* Classe: Tablero
 *
 * Propietats:
 *      protected byte ancho
 *      protected byte alto
 *      protected int[][] mapa
 *      protected Color[] paleta
 *
 * Metodes:
 *      __constructor(byte ancho, byte alto, Color[] paleta)
 *      protected void setAncho(byte ancho)
 *      public byte getAncho()
 *      protected void setAlto(byte alto)
 *      public byte getAlto() 
 *      public void vaciar()
 *      protected void setPaleta(Color[] paleta)
 *      protected Color[] getPaleta()
 *      public boolean estaLLeno()
 *      public byte procesarLineas()
 *      protected boolean hayLinea(byte fila)
 *      protected void borrarLinea(byte fila)
 *      protected void bajarPiezas()
 *      public boolean agregarPieza(Pieza pieza, byte left, byte top) //<- pensar si fa falta la y (top)
 *      public void dibujar(Graphics contenedor)
 */

//Falta: en totes les classes, impedir ficar valors no possibles en els sets (valors negatius, etc).

import java.awt.Color;
import java.awt.Graphics;

public class Tablero
{
    protected byte ancho;
    protected byte alto;
    
    protected int[][] mapa;
    
    protected Color[] paleta; //<- no instanciar??
    
    public Tablero(byte ancho, byte alto, Color[] paleta)
    {
        this.vaciar();
        this.setAncho(ancho);
        this.setAlto(alto);
        this.setPaleta(paleta);
    }

    public byte getAncho()
    {
        return this.ancho;
    }
    
    protected void setAncho(byte ancho)
    {
        this.ancho = ancho;
    }
    
    public byte getAlto()
    {
        return this.alto;
    }
    
    protected void setAlto(byte alto)
    {
        this.alto = alto;
    }
    
    public void vaciar()
    {
        for (byte f = 0; f < this.getAlto(); f++)
        {
            for (byte c = 0; c < this.getAncho(); c++)
            {
                mapa[f][c] = 0;
            }
        }
    }

    protected void setPaleta(Color[] paleta)
    {
        this.paleta = paleta;
    }

    protected Color[] getPaleta()
    {
        return this.paleta;
    }
    
    public boolean estaLleno()
    {
        //Si hay alguna celda ocupada en la ultima fila, se asume lleno:
        boolean lleno = false;
        for (byte c = 0; c < this.getAncho(); c++)
        {
            if (mapa[0][c] != 0) { lleno = true; }
        }
        return lleno;
    }
    
    public byte procesarLineas()
    {
        byte numeroLineas = 0;
        
        for (byte f = 0; f < this.getAlto(); f++)
        {
            if (this.hayLinea(f))
            {
                numeroLineas++;
                this.borrarLinea(f);
            }
        }
        
        if (numeroLineas > 0) { this.bajarPiezas(); }
        
        return numeroLineas;
    }
    
    protected boolean hayLinea(byte fila)
    {
        boolean hayLinea = true;
        for (byte c = 0; c < this.getAncho(); c++)
        {
            if (mapa[fila][c] == 0) { hayLinea = false; }
        }
        return hayLinea;
    }
    
    protected void borrarLinea(byte fila)
    {
        for (byte c = 0; c < this.getAncho(); c++)
        {
            mapa[fila][c] = 0;
        }
    }
    
    protected void bajarPiezas()
    {
    
    }
    
    public boolean agregarPieza(Pieza pieza, byte left, byte top) //<- pensar si fa falta la y (top)
    {
        //Retornar false si no se puede agregar de ninguna manera (ni moviendola hacia alguna direccion).
        return true; //<--CANVIAR!!!
    }

    public void dibujar(Graphics contenedor)
    {
    
    }
}
