package logica;

//El constructor es un metode???

/* Classe: Pieza
 *
 * Propietats:
 *      protected byte ancho
 *      protected byte alto
 *      protected byte left
 *      protected byte top
 *      protected int[][] forma  <--(matriu de numeros, cada numero un color).
 *      protected Paleta paleta
 *      private final int VACIO;
 *
 * Metodes:
 *      __constructor(int[][] forma, Paleta paleta)
 *      protected void setForma(int[][] forma)
 *      public int[][] getForma()
 *      protected void setPaleta(Paleta paleta)
 *      protected Paleta getPaleta()
 *      protected void setAncho(byte ancho)
 *      public byte getAncho()
 *      protected void setAlto(byte alto)
 *      public byte getAlto()
 *      protected void setLeft(byte left)
 *      public byte getLeft()
 *      protected void setTop(byte top)
 *      public byte getTop()
 *      public void moverIzquierda()
 *      public void moverDerecha()
 *      public void moverAbajo()
 *      public void mover(byte left, byte top)
 *      protected boolean calcularColision(Tablero tablero)
 *      public void rotarIzquierda()
 *      public void rotarDerecha()
 *      public void cabePieza(Tablero tablero)
 *      public void dibujar(Graphics contenedor)
 */

//Falta: en totes les classes, impedir ficar valors no possibles en els sets (valors negatius, etc).

//import java.awt.Color;
import java.awt.Graphics;

public class Pieza
{
    protected byte ancho = 0; //Ancho de la pieza.
    protected byte alto = 0; //Alto de la pieza.

    protected byte left = 0; //Posicion horizontal de la pieza (en el tablero).
    protected byte top = 0; //Posicion vertical de la pieza (en el tablero).
    
    protected int[][] forma = new int[alto][ancho]; //<- no instanciar?? //Forma de la pieza (numero = color).
    
    protected Paleta paleta; //<- no instanciar?? //Paleta que utiliza la pieza.
    //ficar un atribut Tablero per a no pasar-lo sempre als metodes de moure, calcularColision, etc.?

    private final int VACIO = 0; //Numero que nos marca un vacio (no hay pieza).
    
    //Constructor que recibe la forma y la paleta de la pieza:
    public Pieza(int[][] forma, Paleta paleta)
    {
        this.setForma(forma);
        this.setPaleta(paleta);
    }
    
    protected void setForma(int[][] forma)
    {
        this.forma = forma;
        this.setAncho((byte) this.getForma()[0].length);
        this.setAlto((byte) this.getForma().length);
    }
    
    public int[][] getForma()
    {
        return this.forma;
    }

    protected void setPaleta(Paleta paleta)
    {
        this.paleta = paleta;
    }
    
    protected Paleta getPaleta()
    {
        return this.paleta;
    }
    
    protected void setAncho(byte ancho)
    {
        this.ancho = ancho;
    }
    
    public byte getAncho()
    {
        return this.ancho;
    }
    
    protected void setAlto(byte alto)
    {
        this.alto = alto;
    }
    
    public byte getAlto()
    {
        return this.alto;
    }

    protected void setLeft(byte left)
    {
        this.left = left;
    }
    
    public byte getLeft()
    {
        return this.left;
    }
    
    protected void setTop(byte top)
    {
        this.top = top;
    }
    
    public byte getTop()
    {
        return this.top;
    }
    
    //Mueve a la izquierda la pieza (decrementa su left):
    public void moverIzquierda()
    {
        this.setLeft((byte) (this.getLeft() - 1));
    }
    
    //Mueve a la derecha la pieza (incrementa su left):
    public void moverDerecha()
    {
        this.setLeft((byte) (this.getLeft() + 1));
    }

    //Mueve abajo la pieza (incrementa su top):
    public void moverAbajo()
    {
        this.setTop((byte) (this.getTop() + 1));
    }
    
    //Mueve la pieza a una posicion del mapa pasada por parametro:
    public void mover(byte left, byte top)
    {
        this.setLeft(left);
        this.setTop(top);
    }
    
    //Calcula si la pieza ha colisionado:
    protected boolean calcularColision(Tablero tablero)
    {
        boolean colision = false;
        
        //Si la pieza ya no esta en una posicion correcta, hay colision:
        if (!this.cabePieza(tablero)) { colision = true; }
        //...o si la pieza al bajar estuviera en una posicion incorrecta, tambien hay colision:
        else if (!this.cabePieza(tablero, this.getLeft(), (byte) (this.getTop() + 1))) { colision = true; }
        //...o si ha llegado al fondo (suelo), tambien hay colision:
        else if (this.getTop() + this.getAlto() >= tablero.getAlto()) { colision = true; }
        
        return colision;
    }

    //Rota la pieza a la izquierda:
    public void rotarIzquierda()
    {
        //ACORDARSE: de comprobar con cabePieza() y si no, ir probando a desplazarla hacia las cuatro direcciones posibles.
    }
    
    //Rota a la derecha la pieza:
    public void rotarDerecha()
    {
        //ACORDARSE: de comprobar con cabePieza() y si no, ir probando a desplazarla hacia las cuatro direcciones posibles.
    }

    //Calcula si la pieza esta en una posicion correcta en su posicion actual:
    public boolean cabePieza(Tablero tablero)
    {
        return this.cabePieza(tablero, this.getLeft(), this.getTop());
    }

    //Calcula si la pieza estaria posicionada correctamente en una posicion dada:
    public boolean cabePieza(Tablero tablero, byte left, byte top)
    {
        boolean cabe = true;
        
        byte fPieza = 0, cPieza;
        
        for (byte f = this.getTop(); f < this.getTop() + this.getAlto(); f++, fPieza++)
        {
            cPieza = 0;
            for (byte c = this.getLeft(); c < this.getLeft() + this.getAncho(); c++, cPieza++)
            {
                //Solo tiene en cuenta si en la pieza no hay un cero (cero = vacio):
                if (this.getForma()[fPieza][cPieza] != this.VACIO)
                {
                    //Si la pieza esta demasiado arriba, no cabe:
                    if (f < 0) { cabe = false; }
                    //...o si la pieza esta demasiado abajo, no cabe:
                    if (f >= tablero.getAlto()) { cabe = false; }
                    //...o si la pieza esta demasiado a la derecha, no cabe:
                    else if (c < 0) { cabe = false; }
                    //...o si la pieza esta demasiado a la derecha, no cabe:
                    else if (c >= tablero.getAncho()) { cabe = false; }
                    //...o si la pieza se pone encima de las ya puestas, no cabe:
                    else if (tablero.getMapa()[f][c] != tablero.VACIO)
                    {
                        cabe = false;
                    }
                    if (!cabe) { break; }
                }
            }
            if (!cabe) { break; }
        }

        return cabe;
    }
    
    //Dibuja la pieza:
    public void dibujar(Graphics contenedor)
    {
        //PRUEBAS:
        contenedor.setColor(java.awt.Color.GREEN);
        contenedor.drawRect(1, 1, 2000, 2000);
        contenedor.setColor(java.awt.Color.BLUE);
        contenedor.drawRect(20, 20, 2000, 2000);
    }
}