package gui;

import java.awt.Graphics;
import java.awt.Color;

import logica.*;

//ACORDARSE de kitar todos los imports de Graphics en los demas sitios!!!

public class MotorGrafico
{
    private MotorGrafico()
    {
    }
    
    //Dibuja un tablero, una pieza o el panel:
    static public void dibujar(Graphics contenedor, Object objeto)
    {
        //if (objeto == null) { return; }
        if (objeto instanceof Pieza) { dibujarPieza(contenedor, (Pieza) objeto); }
        else if (objeto instanceof Tablero) { dibujarTablero(contenedor, (Tablero) objeto); }
        else if (objeto instanceof Juego) { dibujarPanel(contenedor, (Juego) objeto); }
    }

    static public void dibujarPieza(Graphics contenedor, Pieza pieza)
    {
        Paleta paleta = pieza.getPaleta();
        int x = pieza.getLeft();
        int y = pieza.getTop();
        int indiceColor;
        for (byte f = 0; f < pieza.getAlto(); f++)
        {
            for (byte c = 0; c < pieza.getAncho(); c++)
            {
                indiceColor = pieza.getForma()[f][c];
                MotorGrafico.dibujarCasilla(contenedor, paleta, indiceColor, x, y);
                x++;
            }
            y++;
        }
    }
    
    static public void dibujarTablero(Graphics contenedor, Tablero tablero)
    {
        //La paleta la koge del objeto tablero.
    }
    
    static public void dibujarPanel(Graphics contenedor, Juego juego)
    {
        //La paleta la koge del objeto juego.
    }
    
    //Dibuja una casilla en una posicion dada:
    static protected void dibujarCasilla(Graphics contenedor, Paleta paleta, int indiceColor, int x, int y)
    {
        //Pone el color que corresponde:
        Color color = paleta.getColor(indiceColor);
        contenedor.setColor(color);
        //Coge el alto y ancho de la casilla definidos en la configuracion:
        contenedor.fillRect(x, y, configuracion.Aspecto.getCeldaAncho(), configuracion.Aspecto.getCeldaAlto());
    }
    
}
