package logica;

/* Classe: Juego
 *
 * Propietats:
 *      protected int[] teclaArriba  <-- (son vectors per poder definir mes d'una tecla)
 *      protected int[] teclaAbajo
 *      protected int[] teclaDerecha
 *      protected int[] teclaIzquierda
 *      protected int[] teclaRotarDerecha
 *      protected int[] teclaRotarIzquierda
 *      protected Graphics contenedorGrafico
 *      protected Paleta paleta <-- poder cambiar paleta con setPaleta por si se kieren kambiar los kolores desde fuera.
 *      protected Pieza[] piezasBase
 *      protected int velocidad
 *      final protected int velocidadMinima
 *      final protected int velocidadMaxima
 *      final protected int incrementoVelocidad
 *      protected boolean juegoPausado
 *      protected int nivel
 *      protected int puntos
 *      protected int lineas
 *      protected Tablero tablero
 *      protected Pieza piezaActual
 *      protected Pieza piezaSiguiente
 *
 * Metodes:
 *      __constructor(Graphics contenedor)
 *      __constructor(Graphics contenedor, Paleta paleta)
 *      __constructor(Graphics contenedor, Paleta paleta, Pieza[] piezasBase)
 *      public void setContenedorGrafico(Graphics contenedor)
 *      public Graphics getContenedorGrafico()
 *      public void setPaleta(Paleta paleta)
 *      public Paleta getPaleta()
 *      public void setPiezasBase(Pieza[] piezasBase)
 *      public Pieza[] getPiezasBase()
 *      protected int numeroPiezasBase()
 *      public void definirTeclas(int[] teclaArriba, int[] teclaAbajo, int[] teclaDerecha, int[] teclaIzquierda, int[] teclaRotarDerecha, int[] teclaRotarIzquierda)
 *      public void modificarDimensionesTablero(byte ancho, byte alto)
 *      public void setVelocidad(int velocidad)
 *      public int getVelocidad()
 *      protected void subirVelocidad()
 *      public void setNivel(int nivel)
 *      public int getNivel()
 *      protected void subirNivel()
 *      protected void setPuntos(int puntos)
 *      public int getPuntos()
 *      protected void sumarPuntos(int puntos)
 *      protected void setLineas(int lineas)
 *      public int getLineas()
 *      protected void sumarLineas(int numeroLineas)
 *      public int leerTeclado(KeyEvent evento)
 *      public void procesarTecla(int tecla)
 *      public boolean comprobarGameOver()
 *      public void iniciarJuego()
 *      public void finalizarJuego()
 *      public void pausarJuego()
 *      public void reanudarJuego()
 *      public void reiniciarJuego()
 *      protected Pieza obtenerPieza()
 *      protected void sacarPieza()
 *      protected void cicloJuego()
 *      protected void actualizarPanel(Graphics contenedor);
 *      protected void representarTodo(Graphics contenedor)
 */

//Falta: en totes les classes, impedir ficar valors no possibles en els sets (valors negatius, etc).

//Preguntar si se puede en una clase abstracta poner constructores abstractos o al menos no abstractos.

//FALTA: en todos, pensar si poner un destructor (para piezas iria bien, a lo mejor).

//FALTA: crear archivo de konfiguracion para teklas i si no se envian las teklas al konstruktor, kogerlas de ahi.

//PENSAR: si poner propiedad i metodo para piezaSiguiente, i para ke lo use MotorGrafico al dibujarPanel().

//FALTA: poder hacer velocidadMinima, velocidadMaxima e incrementoVelocidad modificable desde fuera (necesitaran metodos get y set y no ser final).

import configuracion.*; //Utiliza el archivo de configuracion del juego.
import java.awt.Graphics;
import java.awt.event.*;

public class Juego
{
    protected int[] teclaArriba; //Tecla(s) para ir arriba (en Tetris no se puede, pero por si hubiera algun menu).
    protected int[] teclaAbajo; //Tecla(s) para ir abajo.
    protected int[] teclaDerecha; //Tecla(s) para ir a la derecha.
    protected int[] teclaIzquierda; //Tecla(s) para ir a la izquierda.
    protected int[] teclaRotarDerecha; //Tecla(s) para rotar a la derecha.
    protected int[] teclaRotarIzquierda; //Tecla(s) para rotar a la derecha.

    protected Graphics contenedorGrafico; //Contenedor grafico donde se representara todo el juego.
    
    protected Paleta paleta; //<- no instanciar?? //Paleta que utiliza el juego.
    
    protected Pieza[] piezasBase; //Vector con las piezas base.
            
    protected int velocidad = configuracion.Otros.getVelocidadInicial(); //Retraso entre ciclos, en milisegundos (numero menor = mas rapido).
    final protected int velocidadMinima = configuracion.Otros.getVelocidadMinima(); //Velocidad minima posible.
    final protected int velocidadMaxima = configuracion.Otros.getVelocidadMaxima(); //Velocidad maxima posible.
    final protected int incrementoVelocidad = configuracion.Otros.getIncrementoVelocidad(); //Incremento de la velocidad cuando esta sube.
    
    protected boolean juegoPausado; //Define si el juego esta en pausa o no.
            
    protected int nivel; //Numero de nivel.
    
    protected int puntos; //Puntuacion.
    
    protected int lineas; //Lineas hechas.

    protected Tablero tablero; //Tablero del juego.
    
    protected Pieza piezaActual; //Ficha actual que controla el jugador.
    protected Pieza piezaSiguiente; //Ficha que va a venir luego.
    
    //Constructor que recibe el contenedor del juego:
    public Juego(Graphics contenedor)
    {
        this(contenedor, null, null);
    }
    
    //Constructor que recibe el contenedor y la paleta del juego:
    public Juego(Graphics contenedor, Paleta paleta)
    {
        this(contenedor, paleta, null); //Pondra como piezas base las definidas en la configuracion.
    }
    
    //Constructor que recibe el contenedor, la paleta y las piezas base del juego:
    public Juego(Graphics contenedor, Paleta paleta, Pieza[] piezasBase)
    {
        this.setContenedorGrafico(contenedor);
        //Si no se ha enviado una paleta, pone la definida en la configuracion:
        if (paleta == null)
        {
            paleta = PaletaColores.getPaleta();
        }
        this.setPaleta(paleta);
        //Si no se ha enviado piezas base, pone las definidas en la configuracion:
        if (piezasBase == null)
        {
            piezasBase = configuracion.Piezas.getPiezas(this.getPaleta());
        }
        this.setPiezasBase(piezasBase);
        
        //Crea el tablero con el alto y ancho definidos en la configuracion:
        byte alto = configuracion.Otros.getTableroAlto();
        byte ancho = configuracion.Otros.getTableroAncho();
        this.tablero = new Tablero(ancho, alto, this.getPaleta());
    }
    
    public void setContenedorGrafico(Graphics contenedor)
    {
        this.contenedorGrafico = contenedor;
    }
    
    public Graphics getContenedorGrafico()
    {
        return this.contenedorGrafico;
    }
    
    public void setPaleta(Paleta paleta)
    {
        this.paleta = paleta;
    }
    
    public Paleta getPaleta()
    {
        return this.paleta;
    }
    
    public void setPiezasBase(Pieza[] piezasBase)
    {
        this.piezasBase = piezasBase;
    }
    
    protected int numeroPiezasBase()
    {
        return this.getPiezasBase().length;
    }
    
    public Pieza[] getPiezasBase()
    {
        return this.piezasBase;
    }
    
    //Define las teclas de funcionamiento:
    public void definirTeclas(int[] teclaArriba, int[] teclaAbajo, int[] teclaDerecha, int[] teclaIzquierda, int[] teclaRotarDerecha, int[] teclaRotarIzquierda)
    {
        this.teclaArriba = teclaArriba;
        this.teclaAbajo = teclaAbajo;
        this.teclaDerecha = teclaDerecha;
        this.teclaIzquierda = teclaIzquierda;
        this.teclaRotarDerecha = teclaRotarDerecha;
        this.teclaRotarIzquierda = teclaRotarIzquierda;
    }
    
    //Modifica la dimension del tablero:
    public void modificarDimensionesTablero(byte ancho, byte alto)
    {
        this.tablero.setAncho(ancho);
        this.tablero.setAlto(alto);
    }
    
    public void setVelocidad(int velocidad)
    {
        if (velocidad >= this.velocidadMinima && velocidad <= this.velocidadMaxima)
        {
            this.velocidad = velocidad;
        }
    }
 
    public int getVelocidad()
    {
        return this.velocidad;
    }
    
    protected void subirVelocidad()
    {
        this.setVelocidad(this.getVelocidad() + this.incrementoVelocidad);
    }
    
    public void setNivel(int nivel)
    {
        this.nivel = nivel;
    }
    
    public int getNivel()
    {
        return this.nivel;
    }
    
    protected void subirNivel()
    {
        this.setNivel(this.getNivel() + 1);
    }
    
    protected void setPuntos(int puntos)
    {
        //Permitiremos numeros negativos por si se quisiera hacer un juego con magias o penalizaciones que restaran puntos:
        this.puntos = puntos;
    }
    
    public int getPuntos()
    {
        return this.puntos;
    }
    
    protected void sumarPuntos(int puntos)
    {
        this.setPuntos(this.getPuntos() + puntos);
    }
    
    protected void setLineas(int lineas)
    {
        if (lineas >= 0)
        {
            this.lineas = lineas;
        }
    }
    
    public int getLineas()
    {
        return this.lineas;
    }
    
    protected void sumarLineas(int numeroLineas)
    {
        //Se permiten mas de 5 porque pueden haber piezas personalizadas:
        if (numeroLineas > 0)
        {
            this.setLineas(this.getLineas() + numeroLineas);
        }
    }
 
    //Retorna la tecla que se ha apretado (si se ha apretado alguna):
    public int leerTeclado(KeyEvent evento)
    {
        //PENSAR: si retornar null si no se pulsa nada o como hacerlo.
        return 0; //CAMBIAR!!!
    }
 
    //Realiza una accion dependiendo de una tecla dada:
    public void procesarTecla(int tecla)
    {
        //Acordarse de que las teclas estan en un vector!!!
    }

    //Comprueba si se ha perdido el juego o no:
    public boolean comprobarGameOver() //ACORDARSE: del GameOver que esta en gui.
    {
        //Si se ha perdido, finalizar juego y acordarse del GameOver.
        return true; //CAMBIAR!!!
    }
 
    //Inicia el juego:
    public void iniciarJuego()
    {
        //Comenzar los ciclos.
        
        //PRUEBA:
        this.representarTodo(contenedorGrafico); //BORRAR ESTA LINEA!!!
    }
    
    //Finaliza el juego:
    public void finalizarJuego()
    {
        //Acabar los ciclos.
    }
    
    //Pausa el juego:
    public void pausarJuego()
    {
        this.juegoPausado = true;
    }
    
    //Reanuda el juego (quita la pausa):
    public void reanudarJuego()
    {
        this.juegoPausado = false;
    }
    
    //Reinicia el juego:
    public void reiniciarJuego()
    {
        this.finalizarJuego();
        this.iniciarJuego();
    }
  
    //Retorna una pieza aleatoria de entre las piezas base posibles:
    protected Pieza obtenerPieza()
    {
        return null; //CAMBIAR!!!
    }
    
    //Introduce una pieza en el juego (la que el usuario va a controlar):
    protected void sacarPieza()
    {
    
    }
    
    //Hace el ciclo del juego (contiene toda la logica):
    protected void cicloJuego()
    {
        //Si el juego esta en pausa, no hace el ciclo:
        if (this.juegoPausado) { return; }
        else //else innecesario.
        {
            //FALTA: hacer ciclo.
            //ACORDARSE: de llamar a representarTodo(this.getContenedorGrafico())
        }
    }

    //Actualiza el panel con la puntuacion, la pieza siguiente, etc:
    protected void actualizarPanel(Graphics contenedor)
    {
        //PENSAR: si hacer un objeto solo para el Panel y si ponerlo en GUI o en logica o en ambos una clase diferente o donde.
    }
    
    //Dibuja el juego (tablero, pieza y panel):
    protected void representarTodo(Graphics contenedor)
    {
        //Dibuja el tablero:
        this.tablero.dibujar(contenedor);
        
        //Dibuja la pieza:
        this.piezaActual.dibujar(contenedor);
        
        //Actualiza el panel:
        this.actualizarPanel(contenedor);
    }
}
