package primera_part;

import java.util.Date;

public class Bicicleta extends Producte
{
    protected String marcaQuadre = ""; //Per defecte no hi ha.
    protected enum tipus { MUNTANYA, CARRETERA };
    protected int tipusBicicleta;
    protected byte numVelocitats = 1;

    public Bicicleta(float preu, String codi, String marcaQuadre) throws Exception
    {
        super(preu, codi);
        this.setMarcaQuadre(marcaQuadre);
    }
    
    /*public Bicicleta(float preu, String codi, String marcaQuadre) throws Exception
    {
        super(preu, codi, marcaQuadre);
        super();
        //super.setPreu(preu);
        setPreu(preu);
    }*/
    
    public Bicicleta(float preu, String codi, String marcaQuadre, int tipusBicicleta) throws Exception
    {
        this(preu, codi, marcaQuadre);
        this.setTipusBicicleta(tipusBicicleta);
    }
    
    public Bicicleta(float preu, String codi, String descripcio, String marcaQuadre, int tipusBicicleta) throws Exception
    {
        this(preu, codi, marcaQuadre, tipusBicicleta);
        this.setDescripcio(descripcio);
    }
    
    public Bicicleta(float preu, String codi, String descripcio, Date dataCaducitat, String marcaQuadre, int tipusBicicleta) throws Exception
    {
        this(preu, codi, descripcio, marcaQuadre, tipusBicicleta);
        this.setDataCaducitat(dataCaducitat);
    }
    
    public void setMarcaQuadre(String marcaQuadre) throws Exception
    {
        if (marcaQuadre != null) { this.marcaQuadre = marcaQuadre; }
        else { throw new Exception("La marca del quadre no pot ser nul"); }
    }
    
    public String getMarcaQuadre()
    {
        return this.marcaQuadre = marcaQuadre;
    }
    
    public void setTipusBicicleta(int tipusBicicleta) throws Exception
    {
        if (this.tipusValid(tipusBicicleta))
        {
            this.tipusBicicleta = tipusBicicleta;
        }
        else { throw new Exception("El tipus no es valid"); }
    }
    
    public int getTipusBicicleta()
    {
        return this.tipusBicicleta;
    }
    
    public boolean tipusValid(int tipusBicicleta) //Ho faig public per si algu vol consultar un tipus si es valid des de fora.
    {
        boolean valid = false;
        /*for (tipus x : tipus.values())
        {
            if (tipusBicicleta == x) { valid = true; break; }
        }*/
        if (tipusBicicleta >= 0 &&tipusBicicleta < tipus.values().length) { valid = true; }
        return valid;
    }
    
    public void setVelocitats(byte numVelocitats) throws Exception
    {
        //No existeixen bicicletes amb menys de 1 marxa:
        if (numVelocitats >= 1) { this.numVelocitats = numVelocitats; }
        else { throw new Exception("El numero de velocitats ha de ser 1 o superior."); }
    }
    
    public byte getVelocitats()
    {
        return this.numVelocitats;
    }
    
    public String toString()
    {
        String cadena;
        
        //Nota: es podria fer que sortir el tipus en text i no un numero.
        cadena = " [Quadre: " + this.getMarcaQuadre() + "] [Tipus: " + getTipusBicicleta() + "] [Velocitats: " + this.getVelocitats() + "]";
        
        return super.toString() + " " + cadena; //Aixo no va: return super + " " + cadena;
    }
}
