package primera_part;

import java.util.Date;

import segona_part.AProducte;

public class Producte extends AProducte
{
    protected float preu;
    protected String codi;
    protected String descripcio = ""; //Per defecte no hi ha.
    protected Date dataCaducitat = null; //No fa falta.
    
    public Producte(float preu, String codi) throws Exception
    {
        this.setPreu(preu);
        this.setCodi(codi);
    }
    
    public Producte(float preu, String codi, String descripcio) throws Exception
    {
        this(preu, codi);
        this.setDescripcio(descripcio);
    }
    
    public Producte(float preu, String codi, String descripcio, Date dataCaducitat) throws Exception
    {
        this(preu, codi, descripcio);
        this.setDataCaducitat(dataCaducitat);
    }
    
    public void setPreu(float preu) throws Exception
    {
        //Permitim 0 per a productes gratuits:
        if (preu >= 0) { this.preu = preu; }
        else { throw new Exception("El preu ha de ser 0 (gratis) o superior"); }
    }
    
    public float getPreu()
    {
        return this.preu;
    }
    
    public void setCodi(String codi) throws Exception
    {
        if (codi != null) { this.codi = codi; }
        else { throw new Exception("El codi no pot ser nul"); }
    }
    
    public String getCodi()
    {
        return this.codi;
    }
    
    public void setDescripcio(String descripcio) throws Exception
    {
        if (descripcio != null) { this.descripcio = descripcio; }
        else { throw new Exception("La descripcio no pot ser nul"); }
    }
    
    public String getDescripcio()
    {
        return this.descripcio;
    }
    
    public String toString()
    {
        String cadena;
        cadena = "[" + this.getCodi() + "] " + this.getDescripcio() + " (" + this.getPreu() + ")";
        if (this.getDataCaducitat() != null) { cadena += " {" + this.getDataCaducitat() + "}"; }
        else { cadena += " {No caduca}"; }
        return cadena;
    }
}
