package segona_part;

import primera_part.*;

import java.util.Hashtable;

import java.util.Vector;

public class Magatzem<ID, ITEM extends Producte>
{
    //Com ha de ser agil i rapida, fem servir una Hashtable:
    protected Hashtable<ID, ITEM> items = new Hashtable<ID, ITEM>();
    
    public Magatzem()
    {
    }
    
    public boolean existeix(ID clau)
    {
        //Tambe es podria utilitzar contains(clau):
        return (items.get(clau) != null);
    }
    
    public void inserir(ID clau, ITEM item) throws Exception
    {
        if (!this.existeix(clau)) { items.put(clau, item); }
        else { throw new Exception("L'element ja existeix"); } //Es podria incrementar la quantitat.
    }
    
    public void elimina(ID clau)
    {
        //No faig excepcio ja que no es un error greu intentar esborrar un item inexistent:
        if (this.existeix(clau)) { items.remove(clau); }
    }
    
    public ITEM obtenir(ID clau)
    {
        //Si no existeix, retornara null (tampoc crec que sigui convenient fer una excepcio aqui):
        return items.get(clau);
    }
    
    public String preuTots()
    {
        String cadena = "Preus: ";
        
        for(ITEM item : this.items.values()) //for(ID id : this.items.keySet())
        {
            //En lloc de get getCodi() es podria ficar el codi ID generic:
            cadena += "\n [" + item.getCodi() + "] " + item.getPreu();
        }
        
        return cadena;
    }
    
    public void eliminaCaducats()
    {
        Vector<ID> eliminats = new Vector<ID>();
        
        //Recull els ID a eliminar (si els elimina de la mateixa Hashtable que esta recorrent, dona error):
        ITEM item;
        for(ID id : this.items.keySet())
        {
            item = items.get(id);
            if (item.caducat())
            {
                //this.elimina(id);
                //System.out.print("\nItem " + id + " eliminat!"); //Faig un println() per "testejar" (en realitat el id no sabem si es string o que, es solament una prova).
                eliminats.add(id);
            }
        }

        //Elimina els ID "marcats":
        for (ID id : eliminats)
        {
            this.elimina(id);
            System.out.print("\nItem " + id + " eliminat!"); //Faig un println() per "testejar" (en realitat el id no sabem si es string o que, es solament una prova).
        }
    }
    
    public String toString()
    {
        String cadena = "";
        
        for(ITEM item : this.items.values())
        {
            //En lloc de get getCodi() es podria ficar el codi ID generic:
            cadena += "\n" + item.toString(); //cadena += "\n" + item;
        }
        
        return cadena;
    }
}
