package bd_exercici;

//NOTA: no es te en compte el mySQLinjection.

import java.sql.*;

public class Llibre //No he fet excepcions en els sets, pero estaria be fer-les.
{
    protected String ISBN;
    protected String titol;
    protected String autor;
    protected String editorial;
    protected float preu;

    //Constructor que crea un llibre/plantilla, per poder omplirlo despres manualment o des de la base de dades:
    public Llibre()
    {
    }
    
    //Constructor que crea un nou llibre amb totes les dades necessaries:
    public Llibre(String ISBN, String titol, String autor, String editorial, float preu)
    {
        this.setISBN(ISBN);
        this.setTitol(titol);
        this.setAutor(autor);
        this.setEditorial(editorial);
        this.setPreu(preu);
    }

    //Constructor que, amb l'ISBN, obte de la base de dades el llibre corresponent (si existeix):
    public Llibre(String ISBN, BD bd) throws Exception
    {
        this.setISBN(ISBN);
        try
        {
            this.agafaDadesISBN(this.getISBN(), bd);
        } catch (Exception e) { System.out.println("Excepcio: " + e.getMessage()); }
    }
    
    public void setISBN(String ISBN)
    {
        if (ISBN.trim() != "") { this.ISBN = ISBN; }
    }
    
    public String getISBN()
    {
        return this.ISBN;
    }
    
    public void setTitol(String titol)
    {
        if (titol.trim() != "") { this.titol = titol; }
    }
    
    public String getTitol()
    {
        return this.titol;
    }
    
    public void setAutor(String autor)
    {
        if (autor.trim() != "") { this.autor = autor; }
    }
    
    public String getAutor()
    {
        return this.autor;
    }
    
    public void setEditorial(String editorial)
    {
        if (editorial.trim() != "") { this.editorial = editorial; }
    }
    
    public String getEditorial()
    {
        return this.editorial;
    }
    
    public void setPreu(float preu)
    {
        if (preu >= 0) { this.preu = preu; } //Deixarem 0 per als gratuits.
    }
    
    public float getPreu()
    {
        return this.preu;
    }

    public boolean existeixDadesISBN(String ISBN, BD bd) throws Exception
    {
        boolean existeix = false;
        
        if (bd != null && bd.getConectat())
        {
            bd.consulta("SELECT * FROM Llibres WHERE ISBN LIKE '" + ISBN + "'");
            ResultSet resultats = bd.getResultats();
            existeix = resultats.next(); //Seguramente hagi una altra manera.
            resultats.close();
        }
        
        return existeix;
    }
    
    public boolean agafaDadesISBN(String ISBN, BD bd) throws Exception
    {
        boolean totBe = false;
        
        if (bd != null && bd.getConectat())
        {
            if (this.existeixDadesISBN(ISBN, bd))
            {
                bd.consulta("SELECT * FROM Llibres WHERE ISBN LIKE '" + ISBN + "'");
                ResultSet resultats = bd.getResultats();
                if (resultats.next())
                {
                    totBe = true;
                    
                    String editorial = resultats.getString("Editorial");
                    String autor = resultats.getString("Autor");
                    String titol = resultats.getString("Titol");
                    float preu = resultats.getFloat("Preu");
                    
                    this.setISBN(ISBN);
                    this.setEditorial(editorial);
                    this.setAutor(autor);
                    this.setTitol(titol);
                    this.setPreu(preu);
                }
            }
        }
        
        return totBe;
    }

    public boolean esborraDades(BD bd) throws Exception
    {
        return this.esborraDadesISBN(this.getISBN(), bd);
    }
    
    public boolean esborraDadesISBN(String ISBN, BD bd) throws Exception
    {
        boolean totBe = true;
        
        if (bd != null && bd.getConectat())
        {
            if (this.existeixDadesISBN(ISBN, bd))
            {
                totBe = bd.consultaModificacio("DELETE FROM Llibres WHERE ISBN LIKE '" + ISBN + "'");
            } else { totBe = false; }
        } else { totBe = false; }
        
        return totBe;
    }
    
    public boolean inserirDades(BD bd) throws Exception
    {
        boolean totBe = true;
        
        if (bd != null && bd.getConectat())
        {
            if (this.getISBN().trim() != "" && this.getAutor().trim() != ""
                && this.getEditorial().trim() != "" && this.getTitol().trim() != ""
                && this.getPreu() >= 0)
            {
                if (!this.existeixDadesISBN(ISBN, bd))
                {
                    totBe = bd.consultaModificacio(
                                                    "INSERT INTO Llibres" +
                                                    "(ISBN, Autor, Editorial, Titol, Preu)" +
                                                    "VALUES ('" + this.getISBN() + "', '" +
                                                    this.getAutor() + "', '" +
                                                    this.getEditorial() + "', '" +
                                                    this.getTitol() + "', '" +
                                                    this.getPreu() + "')"
                                                  );
                } else { totBe = false; }
            } else { totBe = false; }
        } else { totBe = false; }
        
        return totBe;
    }
    
    public boolean modificarDades(BD bd) throws Exception
    {
        boolean totBe = true;
        
        if (bd != null && bd.getConectat())
        {
            if (this.getISBN().trim() != "" && this.getAutor().trim() != ""
                && this.getEditorial().trim() != "" && this.getTitol().trim() != ""
                && this.getPreu() >= 0)
            {
                if (this.existeixDadesISBN(ISBN, bd))
                {
                    totBe = bd.consultaModificacio(
                                                    "UPDATE Llibres SET " +
                                                    "ISBN = '" + this.getISBN() + "', " +
                                                    "Autor = '" + this.getAutor() + "', " +
                                                    "Editorial = '" + this.getEditorial() + "', " +
                                                    "Titol = '" + this.getTitol() + "', " +
                                                    "Preu = " + this.getPreu() + " " +
                                                    "WHERE ISBN = '" + this.getISBN() + "'"
                                                  );
                } else { totBe = false; }
            } else { totBe = false; }
        } else { totBe = false; }
        
        return totBe;
    }
}
